/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerListResult;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.Token;

@KerberosInfo(serverPrincipal="hdds.scm.kerberos.principal")
public interface StorageContainerLocationProtocol
extends Closeable {
    public static final long versionID = 1L;
    public static final Set<StorageContainerLocationProtocolProtos.Type> ADMIN_COMMAND_TYPE = Collections.unmodifiableSet(EnumSet.of(StorageContainerLocationProtocolProtos.Type.StartReplicationManager, StorageContainerLocationProtocolProtos.Type.StopReplicationManager, StorageContainerLocationProtocolProtos.Type.ForceExitSafeMode));

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, String var3) throws IOException;

    public ContainerInfo getContainer(long var1) throws IOException;

    public ContainerWithPipeline getContainerWithPipeline(long var1) throws IOException;

    public List<HddsProtos.SCMContainerReplicaProto> getContainerReplicas(long var1, int var3) throws IOException;

    public List<ContainerWithPipeline> getContainerWithPipelineBatch(Iterable<? extends Long> var1) throws IOException;

    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> var1);

    public ContainerListResult listContainer(long var1, int var3) throws IOException;

    public ContainerListResult listContainer(long var1, int var3, HddsProtos.LifeCycleState var4) throws IOException;

    public ContainerListResult listContainer(long var1, int var3, HddsProtos.LifeCycleState var4, HddsProtos.ReplicationFactor var5) throws IOException;

    public ContainerListResult listContainer(long var1, int var3, HddsProtos.LifeCycleState var4, HddsProtos.ReplicationType var5, ReplicationConfig var6) throws IOException;

    public void deleteContainer(long var1) throws IOException;

    public Map<String, List<ContainerID>> getContainersOnDecomNode(DatanodeDetails var1) throws IOException;

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState var1, HddsProtos.NodeState var2, HddsProtos.QueryScope var3, String var4, int var5) throws IOException;

    public HddsProtos.Node queryNode(UUID var1) throws IOException;

    public List<DatanodeAdminError> decommissionNodes(List<String> var1, boolean var2) throws IOException;

    public List<DatanodeAdminError> recommissionNodes(List<String> var1) throws IOException;

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> var1, int var2, boolean var3) throws IOException;

    public void closeContainer(long var1) throws IOException;

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType var1, HddsProtos.ReplicationFactor var2, HddsProtos.NodePool var3) throws IOException;

    public List<Pipeline> listPipelines() throws IOException;

    public Pipeline getPipeline(HddsProtos.PipelineID var1) throws IOException;

    public void activatePipeline(HddsProtos.PipelineID var1) throws IOException;

    public void deactivatePipeline(HddsProtos.PipelineID var1) throws IOException;

    public void closePipeline(HddsProtos.PipelineID var1) throws IOException;

    public ScmInfo getScmInfo() throws IOException;

    public void transferLeadership(String var1) throws IOException;

    public List<HddsProtos.DeletedBlocksTransactionInfo> getFailedDeletedBlockTxn(int var1, long var2) throws IOException;

    public int resetDeletedBlockRetryCount(List<Long> var1) throws IOException;

    public boolean inSafeMode() throws IOException;

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException;

    public boolean forceExitSafeMode() throws IOException;

    public void startReplicationManager() throws IOException;

    public void stopReplicationManager() throws IOException;

    public boolean getReplicationManagerStatus() throws IOException;

    public ReplicationManagerReport getReplicationManagerReport() throws IOException;

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(Optional<Double> var1, Optional<Integer> var2, Optional<Integer> var3, Optional<Long> var4, Optional<Long> var5, Optional<Long> var6, Optional<Integer> var7, Optional<Integer> var8, Optional<Integer> var9, Optional<Boolean> var10, Optional<String> var11, Optional<String> var12) throws IOException;

    public void stopContainerBalancer() throws IOException;

    public boolean getContainerBalancerStatus() throws IOException;

    public StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto getContainerBalancerStatusInfo() throws IOException;

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String var1, String var2, int var3) throws IOException;

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean var1, int var2, int var3) throws IOException;

    public UpgradeFinalization.StatusAndMessages finalizeScmUpgrade(String var1) throws IOException;

    public UpgradeFinalization.StatusAndMessages queryUpgradeFinalizationProgress(String var1, boolean var2, boolean var3) throws IOException;

    public Token<?> getContainerToken(ContainerID var1) throws IOException;

    public long getContainerCount() throws IOException;

    public long getContainerCount(HddsProtos.LifeCycleState var1) throws IOException;

    public List<ContainerInfo> getListOfContainers(long var1, int var3, HddsProtos.LifeCycleState var4) throws IOException;

    public StorageContainerLocationProtocolProtos.DecommissionScmResponseProto decommissionScm(String var1) throws IOException;

    public String getMetrics(String var1) throws IOException;
}

