/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.lifecycle;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.el.ELResolver;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.webbeans.annotation.InitializedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.lifecycle.AbstractLifeCycle;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.web.context.WebContextsService;
import org.apache.webbeans.web.lifecycle.ServletContextBean;
import org.apache.webbeans.web.lifecycle.ServletRequestBean;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public class WebContainerLifecycle
extends AbstractLifeCycle {
    public WebContainerLifecycle() {
        super(null);
        this.logger = WebBeansLoggerFacade.getLogger(WebContainerLifecycle.class);
    }

    public WebContainerLifecycle(WebBeansContext webBeansContext) {
        super(null, webBeansContext);
        this.logger = WebBeansLoggerFacade.getLogger(WebContainerLifecycle.class);
    }

    public void startApplication(Object startupObject) {
        ServletContext servletContext = this.getServletContext(startupObject);
        if ("true".equalsIgnoreCase(this.getWebBeansContext().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.web.add-beans", "true"))) {
            this.webBeansContext.getBeanManagerImpl().addInternalBean((Bean)new ServletContextBean(this.webBeansContext, servletContext));
            ContextsService contextsService = this.webBeansContext.getContextsService();
            if (WebContextsService.class.isInstance(contextsService)) {
                this.webBeansContext.getBeanManagerImpl().addInternalBean((Bean)new ServletRequestBean(this.webBeansContext, (WebContextsService)((Object)WebContextsService.class.cast(contextsService))));
            }
        }
        super.startApplication((Object)servletContext);
    }

    public void stopApplication(Object endObject) {
        ServletContext servletContext = this.getServletContext(endObject);
        super.stopApplication((Object)servletContext);
    }

    protected void afterStartApplication(Object startupObject) {
        if (this.getWebBeansContext().getOpenWebBeansConfiguration().isJspApplication()) {
            ELAdaptor elAdaptor = (ELAdaptor)this.getWebBeansContext().getService(ELAdaptor.class);
            this.logger.log(Level.FINE, "Application is configured as JSP. Adding EL Resolver.");
            this.setJspELFactory((ServletContext)startupObject, elAdaptor.getOwbELResolver());
        }
        ServletContext servletContext = null;
        if (startupObject instanceof ServletContext) {
            servletContext = (ServletContext)startupObject;
            servletContext.setAttribute(BeanManager.class.getName(), (Object)this.getBeanManager());
        }
        if (this.webBeansContext.getNotificationManager().hasContextLifecycleObserver((Annotation)InitializedLiteral.INSTANCE_APPLICATION_SCOPED)) {
            this.webBeansContext.getContextsService().startContext(RequestScoped.class, null);
            this.webBeansContext.getBeanManagerImpl().fireEvent(servletContext != null ? servletContext : new Object(), new Annotation[]{InitializedLiteral.INSTANCE_APPLICATION_SCOPED});
            this.webBeansContext.getContextsService().endContext(RequestScoped.class, null);
        }
    }

    protected void beforeStartApplication(Object startupObject) {
        this.scannerService.init(startupObject);
    }

    protected void beforeStopApplication(Object stopObject) {
        this.webBeansContext.getContextsService().endContext(RequestScoped.class, null);
        this.webBeansContext.getContextsService().endContext(ConversationScoped.class, null);
        this.webBeansContext.getContextsService().endContext(SessionScoped.class, null);
        this.webBeansContext.getContextsService().endContext(ApplicationScoped.class, null);
        this.webBeansContext.getContextsService().endContext(Singleton.class, null);
        ELContextStore elStore = ELContextStore.getInstance((boolean)false);
        if (elStore != null) {
            elStore.destroyELContextStore();
        }
    }

    protected void afterStopApplication(Object stopObject) {
        ServletContext servletContext = stopObject instanceof ServletContext ? (ServletContext)stopObject : this.getServletContext(stopObject);
        ResourceInjectionService injectionServices = (ResourceInjectionService)this.getWebBeansContext().getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        this.cleanupShutdownThreadLocals();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "INFO_0002", ServletCompatibilityUtil.getServletInfo(servletContext));
        }
    }

    private void cleanupShutdownThreadLocals() {
        this.contextsService.removeThreadLocals();
    }

    private ServletContext getServletContext(Object object) {
        if (object != null) {
            if (object instanceof ServletContextEvent) {
                object = ((ServletContextEvent)object).getServletContext();
                return (ServletContext)object;
            }
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0018"));
        }
        throw new IllegalArgumentException("ServletContextEvent object but found null");
    }

    protected void setJspELFactory(ServletContext startupObject, Object resolver) {
        JspFactory factory = JspFactory.getDefaultFactory();
        if (factory == null) {
            try {
                try {
                    Class.forName("org.apache.jasper.servlet.JasperInitializer", true, WebContainerLifecycle.class.getClassLoader());
                }
                catch (Throwable th) {
                    Class.forName("org.apache.jasper.compiler.JspRuntimeContext", true, WebContainerLifecycle.class.getClassLoader());
                }
                factory = JspFactory.getDefaultFactory();
            }
            catch (Exception th) {
                // empty catch block
            }
        }
        if (factory != null) {
            JspApplicationContext applicationCtx = factory.getJspApplicationContext(startupObject);
            applicationCtx.addELResolver((ELResolver)ELResolver.class.cast(resolver));
        } else {
            this.logger.log(Level.FINE, "Default JSPFactroy instance has not found");
        }
    }
}

