/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import javassist.util.proxy.ProxyObjectInputStream;
import javassist.util.proxy.ProxyObjectOutputStream;
import javax.enterprise.context.Conversation;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.web.context.SessionContextManager;

public class FailOverBag
implements Serializable {
    private static final long serialVersionUID = -6314819837009653189L;
    String sessionId;
    String owbFailoverJVMId;
    SessionContext sessionContext;
    Map<Conversation, ConversationContext> conversationContextMap;

    public FailOverBag() {
    }

    public FailOverBag(HttpSession session, FailOverService service) {
        this.sessionId = session.getId();
        this.owbFailoverJVMId = service.getJVMId();
        this.updateOwbFailOverBag(session, service);
    }

    public void updateOwbFailOverBag(HttpSession session, FailOverService service) {
        SessionContextManager sessionManager = SessionContextManager.getInstance();
        this.sessionContext = sessionManager.getSessionContextWithSessionId(session.getId());
        ConversationManager conversationManager = ConversationManager.getInstance();
        this.conversationContextMap = conversationManager.getConversationMapWithSessionId(session.getId());
    }

    public void restore() {
        try {
            if (this.sessionContext != null) {
                SessionContextManager sessionManager = SessionContextManager.getInstance();
                sessionManager.addNewSessionContext(this.sessionId, this.sessionContext);
                this.sessionContext.setActive(true);
            }
            if (this.conversationContextMap != null && !this.conversationContextMap.isEmpty()) {
                ConversationManager conversationManager = ConversationManager.getInstance();
                for (Conversation c : this.conversationContextMap.keySet()) {
                    ConversationContext cc = this.conversationContextMap.get(c);
                    conversationManager.addConversationContext(c, cc);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getJVMId() {
        return this.owbFailoverJVMId;
    }

    public static Object testSerializable(Object obj0) {
        byte[] buf = FailOverBag.getBytes(obj0);
        Object obj1 = FailOverBag.getObject(buf);
        return obj1;
    }

    private static byte[] getBytes(Object obj) {
        ByteArrayOutputStream baos = null;
        ProxyObjectOutputStream oos = null;
        byte[] buf = new byte[]{};
        try {
            baos = new ByteArrayOutputStream();
            oos = new ProxyObjectOutputStream((OutputStream)baos);
            oos.writeObject(obj);
            buf = baos.toByteArray();
            oos.close();
            baos.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return buf;
    }

    private static Object getObject(byte[] buf) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ProxyObjectInputStream ois = new ProxyObjectInputStream((InputStream)bais);
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

