/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.scanner;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.WebBeansUtil;
import org.scannotation.ClasspathUrlFinder;
import org.scannotation.WarUrlFinder;

public class WebScannerService
extends AbstractMetaDataDiscovery {
    private WebBeansLogger logger = WebBeansLogger.getLogger(WebScannerService.class);
    private boolean configure = false;
    protected ServletContext servletContext = null;

    public void init(Object context) {
        this.servletContext = (ServletContext)context;
    }

    protected void configure() throws Exception {
        try {
            if (!this.configure) {
                Set<URL> arcs = this.getArchieves();
                URL[] urls = new URL[arcs.size()];
                arcs.toArray(urls);
                this.getAnnotationDB().scanArchives(urls);
                this.configure = true;
            }
        }
        catch (Exception e) {
            this.logger.error("ERROR_0002", (Throwable)e);
            throw e;
        }
    }

    private Set<URL> getArchieves() throws Exception {
        Set<URL> lists = this.createURLFromMarkerFile();
        URL warUrl = this.createURLFromWARFile();
        if (warUrl != null) {
            lists.add(warUrl);
        }
        return lists;
    }

    protected Set<URL> createURLFromMarkerFile() throws Exception {
        HashSet<URL> listURL = new HashSet<URL>();
        URL[] urls = null;
        urls = ClasspathUrlFinder.findResourceBases((String)"META-INF/beans.xml", (ClassLoader)WebBeansUtil.getCurrentClassLoader());
        if (urls != null) {
            for (URL url : urls) {
                URL addPath = null;
                String fileDir = url.getFile();
                if (fileDir.endsWith(".jar!/")) {
                    fileDir = fileDir.substring(0, fileDir.lastIndexOf("/")) + "/META-INF/beans.xml";
                    addPath = new URL("jar:" + fileDir);
                } else {
                    addPath = new URL("file:" + url.getFile() + "META-INF/beans.xml");
                }
                listURL.add(url);
                this.addWebBeansXmlLocation(addPath);
            }
        }
        return listURL;
    }

    protected URL createURLFromWARFile() throws Exception {
        if (this.servletContext == null) {
            return null;
        }
        URL url = this.servletContext.getResource("/WEB-INF/beans.xml");
        if (url != null) {
            this.addWebBeansXmlLocation(url);
            return WarUrlFinder.findWebInfClassesPath((ServletContext)this.servletContext);
        }
        return null;
    }
}

