/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.se;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.util.Files;

public class CDISeScannerService
extends AbstractMetaDataDiscovery {
    private boolean autoScanning = true;
    private final Collection<Class<?>> classes = new ArrayList();

    public OwbAnnotationFinder getFinder() {
        return this.finder;
    }

    public void loader(ClassLoader loader) {
        this.loader = loader;
    }

    public void classes(Class<?>[] classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public void packages(boolean recursive, Class<?>[] markers) {
        Stream.of(markers).forEach(c -> this.addPackages(recursive, c.getName().replace('.', '/') + ".class", c.getPackage().getName()));
    }

    public void packages(boolean recursive, Package[] packages) {
        Stream.of(packages).forEach(p -> this.addPackages(recursive, p.getName().replace('.', '/'), p.getName()));
    }

    public void disableAutoScanning() {
        this.autoScanning = false;
    }

    protected void configure() {
        if (this.autoScanning) {
            this.registerBeanArchives(this.loader);
        }
        if (!this.classes.isEmpty()) {
            try {
                this.addDeploymentUrl("cdi-standalone", new URL("openwebbeans", null, 0, "cdise", new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return null;
                    }
                }));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public Collection<Class<?>> configuredClasses() {
        return this.classes;
    }

    protected Archive getAdditionalArchive() {
        return this.classes.isEmpty() ? null : new ClassesArchive(this.classes);
    }

    private void addPackages(boolean recursive, String resource, String pack) {
        try {
            Enumeration<URL> urls = this.loader.getResources(resource);
            if (!urls.hasMoreElements()) {
                throw new IllegalArgumentException("No matching jar for '" + resource + "'");
            }
            block10: while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                CaptureClasses capturedClasses = new CaptureClasses(pack, this.classes, recursive, this.loader);
                switch (url.getProtocol()) {
                    case "jar": {
                        this.consume(new FilteredArchive((Archive)new JarArchive(this.loader, url), (Filter)capturedClasses));
                        continue block10;
                    }
                    case "file": {
                        File file = Files.toFile((URL)url);
                        if (!file.exists()) {
                            throw new IllegalArgumentException(file + " doesn't exist (from url" + url + ")");
                        }
                        int i = 0;
                        while ((long)i < pack.chars().filter(c -> c == 46).count()) {
                            file = file.getParentFile();
                            ++i;
                        }
                        if (resource.contains("/")) {
                            file = file.getParentFile();
                        }
                        if (resource.endsWith(".class")) {
                            file = file.getParentFile();
                        }
                        this.consume(new FilteredArchive((Archive)new FileArchive(this.loader, file), (Filter)capturedClasses));
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unsupported resource: " + url + " for resource '" + resource + "'");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void consume(FilteredArchive entries) {
        StreamSupport.stream(entries.spliterator(), false).forEach(e -> {});
    }

    private static final class CaptureClasses
    implements Filter {
        private final Collection<Class<?>> classes;
        private final String prefix;
        private final boolean recursive;
        private final long prefixSegments;
        private final ClassLoader loader;

        private CaptureClasses(String prefix, Collection<Class<?>> classes, boolean recursive, ClassLoader loader) {
            this.prefix = prefix == null ? "" : prefix;
            this.prefixSegments = this.prefix.chars().filter(c -> c == 46).count();
            this.classes = classes;
            this.recursive = recursive;
            this.loader = loader;
        }

        public boolean accept(String name) {
            boolean accepts;
            boolean bl = accepts = name.startsWith(this.prefix) && (this.recursive || name.chars().filter(c -> c == 46).count() == this.prefixSegments + 1L);
            if (accepts) {
                try {
                    this.classes.add(this.loader.loadClass(name));
                }
                catch (ClassNotFoundException e) {
                    logger.warning(e.getMessage());
                }
            }
            return accepts;
        }
    }
}

