/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.junit5.internal;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class CdiParametersResolverExtension
implements ParameterResolver,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CdiParametersResolverExtension.class.getName()});

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Instances instances = (Instances)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent(Instances.class, k -> new Instances(), Instances.class);
        if (instances != null && instances.instances != null && instances.instances.containsKey(parameterContext.getParameter())) {
            return false;
        }
        try {
            Parameter parameter = parameterContext.getParameter();
            BeanManager bm = CDI.current().getBeanManager();
            Bean<?> bean = this.resolveParameterBean(bm, parameter);
            if (bean == null) {
                return false;
            }
            CreationalContext creationalContext = bm.createCreationalContext(null);
            Object instance = bm.getReference(bean, parameter.getType(), creationalContext);
            if (instances.instances == null) {
                instances.instances = new HashMap<Parameter, Instance>();
            }
            instances.instances.put(parameter, new Instance(instance, creationalContext));
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    public void afterEach(ExtensionContext context) {
        Instances instances = (Instances)context.getStore(NAMESPACE).get(Instances.class, Instances.class);
        if (instances != null && instances.instances != null) {
            instances.instances.values().stream().map(i -> i.creationalContext).forEach(CreationalContext::release);
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Instances instances = (Instances)extensionContext.getStore(NAMESPACE).get(Instances.class, Instances.class);
        if (instances == null || instances.instances == null) {
            throw new ParameterResolutionException("No matching parameter: " + parameterContext.getParameter());
        }
        return instances.instances.get((Object)parameterContext.getParameter()).instance;
    }

    private Bean<?> resolveParameterBean(BeanManager beanManager, Parameter parameter) {
        Set beans = beanManager.getBeans(parameter.getType(), this.getQualifiers(beanManager, parameter));
        return beanManager.resolve(beans);
    }

    private Annotation[] getQualifiers(BeanManager beanManager, Parameter parameter) {
        return (Annotation[])Arrays.stream(parameter.getAnnotations()).filter(annotation -> beanManager.isQualifier(annotation.annotationType())).toArray(Annotation[]::new);
    }

    private static class Instances {
        private Map<Parameter, Instance> instances;

        private Instances() {
        }
    }

    private static class Instance {
        private final Object instance;
        private final CreationalContext<?> creationalContext;

        private Instance(Object instance, CreationalContext<?> creationalContext) {
            this.instance = instance;
            this.creationalContext = creationalContext;
        }
    }
}

