/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jms.component;

import java.lang.annotation.Annotation;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.jms.JMSModel;
import org.apache.webbeans.jms.component.JmsBean;
import org.apache.webbeans.util.Asserts;

public final class JmsComponentFactory {
    private static JmsComponentFactory instance = new JmsComponentFactory();

    private JmsComponentFactory() {
    }

    public static JmsComponentFactory getJmsComponentFactory() {
        return instance;
    }

    public <T> JmsBean<T> getJmsComponent(JMSModel model) {
        Annotation[] anns;
        Asserts.assertNotNull((Object)model, (String)"model parameter can not be null");
        JmsBean component = new JmsBean(model);
        if (model.getJmsType().equals((Object)JMSModel.JMSType.QUEUE)) {
            component.addApiType(Queue.class);
            component.addApiType(QueueConnection.class);
            component.addApiType(QueueSession.class);
            component.addApiType(QueueSender.class);
            component.addApiType(QueueReceiver.class);
        } else {
            component.addApiType(Topic.class);
            component.addApiType(TopicConnection.class);
            component.addApiType(TopicSession.class);
            component.addApiType(TopicPublisher.class);
            component.addApiType(TopicSubscriber.class);
        }
        component.setImplScopeType((Annotation)new DependentScopeLiteral());
        for (Annotation a : anns = model.getBindings()) {
            component.addQualifier(a);
        }
        return component;
    }
}

