/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.jetty9;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.webbeans.web.jetty9.JettyDecorator;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.webapp.ClasspathPattern;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class OwbConfiguration
implements Configuration {
    private static final String LISTENER_CLASS_NAME = "org.apache.webbeans.servlet.WebBeansConfigurationListener";

    static void addOwb(WebAppContext ctx) throws ServletException {
        URL url = OwbConfiguration.getBeansXml((ServletContext)ctx.getServletContext());
        if (url != null) {
            System.setProperty("org.apache.webbeans.application.jsp", "true");
            OwbConfiguration.addOwbListeners((ServletContextHandler.Context)ctx.getServletContext());
            OwbConfiguration.addOwbFilters(ctx.getServletContext());
            DecoratedObjectFactory decObjFact = ctx.getObjectFactory();
            decObjFact.addDecorator((Decorator)new JettyDecorator(ctx.getClassLoader()));
        }
    }

    private static void addOwbListeners(ServletContextHandler.Context context) throws ServletException {
        for (EventListener eventListener : context.getContextHandler().getEventListeners()) {
            if (!eventListener.getClass().getName().equals(LISTENER_CLASS_NAME)) continue;
            return;
        }
        context.addListener(LISTENER_CLASS_NAME);
    }

    private static void addOwbFilters(ContextHandler.Context context) {
    }

    private static URL getBeansXml(ServletContext ctx) throws ServletException {
        try {
            URL url = ctx.getResource("/WEB-INF/beans.xml");
            if (url == null) {
                url = ctx.getResource("/WEB-INF/classes/META-INF/beans.xml");
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void preConfigure(WebAppContext ctx) throws Exception {
        ClasspathPattern classpathPattern = ctx.getServerClasspathPattern();
        classpathPattern.add("-org.eclipse.jetty.util.Decorator");
        classpathPattern.add("-org.eclipse.jetty.util.DecoratedObjectFactory");
        classpathPattern.add("-org.eclipse.jetty.server.handler.ContextHandler");
        classpathPattern.add("-org.eclipse.jetty.servlet.ServletContextHandler$Context");
        classpathPattern.add("-org.eclipse.jetty.servlet.ServletContextHandler");
        classpathPattern.add("-org.eclipse.jetty.webapp.WebAppContext");
    }

    public void configure(WebAppContext ctx) throws Exception {
        OwbConfiguration.addOwb(ctx);
    }

    public void postConfigure(WebAppContext ctx) throws Exception {
    }

    public void deconfigure(WebAppContext ctx) throws Exception {
    }

    public void destroy(WebAppContext ctx) throws Exception {
    }

    public void cloneConfigure(WebAppContext template, WebAppContext ctx) throws Exception {
    }
}

