/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.jetty9;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.web.jetty9.JettyUtil;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JettyDecorator
implements Decorator {
    private static final Logger log = Log.getLogger(JettyDecorator.class);
    private ClassLoader loader;
    private Map<Object, Object> objects = new ConcurrentHashMap<Object, Object>();

    public JettyDecorator(ClassLoader loader) {
        this.loader = loader;
    }

    public <T> T decorate(T object) {
        try {
            Object injectorInstance;
            if (log.isDebugEnabled()) {
                log.debug("Injecting the dependencies for OpenWebBeans, instance : " + object, new Object[0]);
            }
            if ((injectorInstance = JettyUtil.inject(object, this.loader)) != null) {
                this.objects.put(object, injectorInstance);
            }
        }
        catch (Exception e) {
            log.warn("Error is occured while injecting the OpenWebBeans dependencies for instance " + object, (Throwable)e);
        }
        return object;
    }

    public void destroy(Object instance) {
        Object injectorInstance = this.objects.get(instance);
        if (injectorInstance != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Destroying the OpenWebBeans injector instance", new Object[0]);
                }
                JettyUtil.destroy(injectorInstance, this.loader);
            }
            catch (Exception e) {
                log.warn("Erros is occured while destroying the OpenWebBeans injector instance", (Throwable)e);
            }
        }
    }
}

