/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.boot;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;

public class Bootstrap {
    private static final Logger log = WebBeansLoggerFacade.getLogger(Bootstrap.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private ContainerLifecycle containerLifecycle;
    private Properties properties;

    public void init(Properties properties) {
        log.info("INFO_0006");
        this.containerLifecycle = WebBeansContext.getInstance().getService(ContainerLifecycle.class);
    }

    public void start() throws InterruptedException {
        log.info("INFO_0005");
        long begin = System.currentTimeMillis();
        this.containerLifecycle.startApplication((Object)this.properties);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bootstrap.this.latch.countDown();
            }
        });
        log.log(Level.INFO, "INFO_0001", Long.toString(System.currentTimeMillis() - begin));
        this.latch.await();
        log.info("INFO_0008");
        this.containerLifecycle.stopApplication((Object)this.properties);
        log.info("INFO_0009");
    }

    public static void main(String[] args) {
        Bootstrap boot = new Bootstrap();
        boot.init(System.getProperties());
    }
}

