/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;

public class TrackingAnnotatedTypeConfiguratorImpl<T>
implements AnnotatedTypeConfigurator<T> {
    private final AnnotatedTypeConfiguratorImpl<T> delegate;
    private final List<String> actions = new ArrayList<String>();

    public TrackingAnnotatedTypeConfiguratorImpl(AnnotatedTypeConfiguratorImpl<T> delegate) {
        this.delegate = delegate;
    }

    public String getPassivationId() {
        return this.actions.stream().collect(Collectors.joining(">>"));
    }

    public final boolean equals(Object o) {
        if (!(o instanceof TrackingAnnotatedTypeConfiguratorImpl)) {
            return false;
        }
        TrackingAnnotatedTypeConfiguratorImpl that = (TrackingAnnotatedTypeConfiguratorImpl)o;
        return this.getPassivationId().equals(that.getPassivationId());
    }

    public int hashCode() {
        return this.getPassivationId().hashCode();
    }

    public AnnotatedType<T> getAnnotated() {
        return this.delegate.getAnnotated();
    }

    public AnnotatedTypeConfigurator<T> add(Annotation annotation) {
        this.actions.add("+@" + annotation.annotationType());
        this.delegate.add(annotation);
        return this;
    }

    public AnnotatedTypeConfigurator<T> remove(Predicate<Annotation> predicate) {
        this.delegate.remove((T a) -> {
            if (predicate.test((Annotation)a)) {
                this.actions.add("-@" + ((Annotation)a).annotationType());
                return true;
            }
            return false;
        });
        return this;
    }

    public AnnotatedTypeConfigurator<T> removeAll() {
        this.actions.add("--");
        this.delegate.removeAll();
        return this;
    }

    public Set<AnnotatedMethodConfigurator<? super T>> methods() {
        return this.delegate.methods().stream().map(m -> new TrackingAnnotatedMethodConfiguratorImpl(m, this.actions)).collect(Collectors.toSet());
    }

    public Stream<AnnotatedMethodConfigurator<? super T>> filterMethods(Predicate<AnnotatedMethod<? super T>> predicate) {
        return this.delegate.filterMethods(a -> {
            if (predicate.test((AnnotatedMethod<? super T>)a)) {
                this.actions.add("-m@" + a);
                return true;
            }
            return false;
        });
    }

    public Set<AnnotatedFieldConfigurator<? super T>> fields() {
        return this.delegate.fields().stream().map(f -> new TrackingAnnotatedFieldConfiguratorImpl(f, this.actions)).collect(Collectors.toSet());
    }

    public Stream<AnnotatedFieldConfigurator<? super T>> filterFields(Predicate<AnnotatedField<? super T>> predicate) {
        return this.delegate.filterFields(a -> {
            if (predicate.test((AnnotatedField<? super T>)a)) {
                this.actions.add("-f@" + a);
                return true;
            }
            return false;
        });
    }

    public Set<AnnotatedConstructorConfigurator<T>> constructors() {
        return this.delegate.constructors().stream().map(c -> new TrackingAnnotatedConstructorConfiguratorImpl(c, this.actions)).collect(Collectors.toSet());
    }

    public Stream<AnnotatedConstructorConfigurator<T>> filterConstructors(Predicate<AnnotatedConstructor<T>> predicate) {
        return this.delegate.filterConstructors(a -> {
            if (predicate.test((AnnotatedConstructor<T>)a)) {
                this.actions.add("-c@" + a);
                return true;
            }
            return false;
        });
    }

    public AnnotatedTypeImpl<T> getNewAnnotatedType() {
        return this.delegate.getNewAnnotatedType();
    }

    public static class TrackingAnnotatedParameterConfiguratorImpl<T>
    implements AnnotatedParameterConfigurator<T> {
        private final AnnotatedParameterConfigurator<T> delegate;
        private final List<String> actions;

        public TrackingAnnotatedParameterConfiguratorImpl(AnnotatedParameterConfigurator<T> delegate, List<String> actions) {
            this.delegate = delegate;
            this.actions = actions;
            this.actions.add("\n\t");
        }

        public final boolean equals(Object o) {
            if (!(o instanceof TrackingAnnotatedParameterConfiguratorImpl)) {
                return false;
            }
            TrackingAnnotatedParameterConfiguratorImpl that = (TrackingAnnotatedParameterConfiguratorImpl)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "TrackingParameter(" + this.delegate + ")";
        }

        public AnnotatedParameterConfigurator<T> add(Annotation annotation) {
            this.actions.add("+@" + annotation.annotationType());
            this.delegate.add(annotation);
            return this;
        }

        public AnnotatedParameter<T> getAnnotated() {
            return this.delegate.getAnnotated();
        }

        public AnnotatedParameterConfigurator<T> remove(Predicate<Annotation> predicate) {
            this.delegate.remove(a -> {
                if (predicate.test((Annotation)a)) {
                    this.actions.add("-p@" + a.toString());
                    return true;
                }
                return false;
            });
            return this;
        }

        public AnnotatedParameterConfigurator<T> removeAll() {
            this.actions.add("--");
            this.delegate.removeAll();
            return this;
        }
    }

    public static class TrackingAnnotatedConstructorConfiguratorImpl<T>
    implements AnnotatedConstructorConfigurator<T> {
        private final AnnotatedConstructorConfigurator<T> delegate;
        private final List<String> actions;

        public TrackingAnnotatedConstructorConfiguratorImpl(AnnotatedConstructorConfigurator<T> delegate, List<String> actions) {
            this.delegate = delegate;
            this.actions = actions;
            this.actions.add("\n\t");
        }

        public final boolean equals(Object o) {
            if (!(o instanceof TrackingAnnotatedConstructorConfiguratorImpl)) {
                return false;
            }
            TrackingAnnotatedConstructorConfiguratorImpl that = (TrackingAnnotatedConstructorConfiguratorImpl)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "TrackingConstructor(" + this.delegate + ")";
        }

        public AnnotatedConstructor<T> getAnnotated() {
            return this.delegate.getAnnotated();
        }

        public AnnotatedConstructorConfigurator<T> add(Annotation annotation) {
            this.actions.add("+@" + annotation.annotationType());
            this.delegate.add(annotation);
            return this;
        }

        public AnnotatedConstructorConfigurator<T> remove(Predicate<Annotation> predicate) {
            this.actions.add("-@" + predicate.toString());
            this.delegate.remove(predicate);
            return this;
        }

        public AnnotatedConstructorConfigurator<T> removeAll() {
            this.actions.add("--");
            this.delegate.removeAll();
            return this;
        }

        public List<AnnotatedParameterConfigurator<T>> params() {
            return this.delegate.params().stream().map(p -> new TrackingAnnotatedParameterConfiguratorImpl(p, this.actions)).map(p -> p).collect(Collectors.toList());
        }

        public Stream<AnnotatedParameterConfigurator<T>> filterParams(Predicate<AnnotatedParameter<T>> predicate) {
            return this.delegate.filterParams(a -> {
                if (predicate.test((AnnotatedParameter<T>)a)) {
                    this.actions.add("-p@" + a.toString());
                    return true;
                }
                return false;
            });
        }
    }

    public static class TrackingAnnotatedMethodConfiguratorImpl<T>
    implements AnnotatedMethodConfigurator<T> {
        private final AnnotatedMethodConfigurator<T> delegate;
        private final List<String> actions;

        public TrackingAnnotatedMethodConfiguratorImpl(AnnotatedMethodConfigurator<T> delegate, List<String> actions) {
            this.delegate = delegate;
            this.actions = actions;
            this.actions.add("\n\t");
        }

        public final boolean equals(Object o) {
            if (!(o instanceof TrackingAnnotatedMethodConfiguratorImpl)) {
                return false;
            }
            TrackingAnnotatedMethodConfiguratorImpl that = (TrackingAnnotatedMethodConfiguratorImpl)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "TrackingMethod(" + this.delegate + ")";
        }

        public AnnotatedMethodConfigurator<T> add(Annotation annotation) {
            this.actions.add("+@" + annotation.annotationType());
            this.delegate.add(annotation);
            return this;
        }

        public Stream<AnnotatedParameterConfigurator<T>> filterParams(Predicate<AnnotatedParameter<T>> predicate) {
            return this.delegate.filterParams(a -> {
                if (predicate.test((AnnotatedParameter<T>)a)) {
                    this.actions.add("-p@" + a);
                    return true;
                }
                return false;
            });
        }

        public AnnotatedMethod<T> getAnnotated() {
            return this.delegate.getAnnotated();
        }

        public List<AnnotatedParameterConfigurator<T>> params() {
            return this.delegate.params().stream().map(p -> new TrackingAnnotatedParameterConfiguratorImpl(p, this.actions)).map(p -> p).collect(Collectors.toList());
        }

        public AnnotatedMethodConfigurator<T> remove(Predicate<Annotation> predicate) {
            this.delegate.remove(a -> {
                if (predicate.test((Annotation)a)) {
                    this.actions.add("-@" + a.toString());
                    return true;
                }
                return false;
            });
            return this;
        }

        public AnnotatedMethodConfigurator<T> removeAll() {
            this.actions.add("--");
            this.delegate.removeAll();
            return this;
        }
    }

    public static class TrackingAnnotatedFieldConfiguratorImpl<T>
    implements AnnotatedFieldConfigurator<T> {
        private final AnnotatedFieldConfigurator<T> delegate;
        private final List<String> actions;

        public TrackingAnnotatedFieldConfiguratorImpl(AnnotatedFieldConfigurator<T> delegate, List<String> actions) {
            this.delegate = delegate;
            this.actions = actions;
            this.actions.add("\n\t");
        }

        public final boolean equals(Object o) {
            if (!(o instanceof TrackingAnnotatedFieldConfiguratorImpl)) {
                return false;
            }
            TrackingAnnotatedFieldConfiguratorImpl that = (TrackingAnnotatedFieldConfiguratorImpl)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "TrackingField(" + this.delegate + ")";
        }

        public AnnotatedField<T> getAnnotated() {
            return this.delegate.getAnnotated();
        }

        public AnnotatedFieldConfigurator<T> removeAll() {
            this.actions.add("--");
            this.delegate.removeAll();
            return this;
        }

        public AnnotatedFieldConfigurator<T> remove(Predicate<Annotation> predicate) {
            this.delegate.remove(a -> {
                if (predicate.test((Annotation)a)) {
                    this.actions.add("-@" + a);
                    return true;
                }
                return false;
            });
            return this;
        }

        public AnnotatedFieldConfigurator<T> add(Annotation annotation) {
            this.actions.add("+@" + annotation.annotationType());
            this.delegate.add(annotation);
            return this;
        }
    }
}

