/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.component.creation.ExtensionBeanBuilder;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.archive.FileArchive;

public class ExtensionLoader {
    private final Map<Class<?>, Object> extensions = new ConcurrentHashMap();
    private final Set<Class<? extends Extension>> extensionClasses = new HashSet<Class<? extends Extension>>();
    private final BeanManagerImpl manager;
    private final WebBeansContext webBeansContext;
    private final Set<URL> extensionJars = new HashSet<URL>();
    private boolean loaded;

    public ExtensionLoader(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.manager = this.webBeansContext.getBeanManagerImpl();
    }

    public synchronized void loadExtensionServices() {
        if (!this.loaded) {
            this.loadExtensionServices(WebBeansUtil.getCurrentClassLoader());
            this.loaded = true;
        }
    }

    public void loadExtensionServices(ClassLoader classLoader) {
        List loader = this.webBeansContext.getLoaderService().load(Extension.class, classLoader);
        this.addExtensions(loader);
        if (!this.webBeansContext.getOpenWebBeansConfiguration().getScanExtensionJars()) {
            this.extensionJars.addAll(this.extensionClasses.stream().map(clazz -> this.toJar(classLoader, (Class<?>)clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
    }

    private URL toJar(ClassLoader loader, Class<?> clazz) {
        try {
            String resource = clazz.getName().replace('.', '/') + ".class";
            Enumeration<URL> urls = loader.getResources(resource);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                switch (url.getProtocol()) {
                    case "jar": {
                        String spec = url.getFile();
                        int separator = spec.indexOf(33);
                        if (separator == -1) break;
                        url = new URL(spec.substring(0, separator));
                        return new File(FileArchive.decode((String)url.getFile())).toURI().toURL();
                    }
                    case "file": {
                        String path = url.getFile();
                        path = path.substring(0, path.length() - resource.length());
                        return new File(FileArchive.decode((String)path)).toURI().toURL();
                    }
                }
            }
        }
        catch (IOException ioe) {
            WebBeansLoggerFacade.getLogger(ExtensionLoader.class).warning(ioe.getMessage());
        }
        return null;
    }

    public Set<URL> getExtensionJars() {
        return this.extensionJars;
    }

    public <T> T getExtension(Class<T> extensionClass) {
        return (T)this.extensions.get(extensionClass);
    }

    public void addExtensions(List<Extension> extensions) {
        Set<String> ignoredExtensions = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredExtensions();
        if (!ignoredExtensions.isEmpty()) {
            WebBeansLoggerFacade.getLogger(ExtensionLoader.class).info("Ignoring the following CDI Extensions. See org.apache.webbeans.ignoredExtensions " + ignoredExtensions.toString());
        }
        HashMap<ExtensionBean<Extension>, AnnotatedType<Extension>> extensionBeans = new HashMap<ExtensionBean<Extension>, AnnotatedType<Extension>>(extensions.size());
        for (Extension extension : extensions) {
            if (ignoredExtensions.contains(extension.getClass().getName())) {
                WebBeansLoggerFacade.getLogger(ExtensionLoader.class).info("Skipping CDI Extension due to exclusion: " + extension.getClass().getName());
                continue;
            }
            if (this.extensionClasses.contains(extension.getClass())) continue;
            this.extensionClasses.add(extension.getClass());
            try {
                ExtensionBeanBuilder<Extension> extensionBeanBuilder = new ExtensionBeanBuilder<Extension>(this.webBeansContext, extension);
                ExtensionBean<Extension> bean = this.createExtensionBean(extensionBeanBuilder);
                extensionBeans.put(bean, extensionBeanBuilder.getAnnotatedType());
            }
            catch (Exception e) {
                if (e instanceof DefinitionException || e instanceof DeploymentException) {
                    ExceptionUtil.throwAsRuntimeException(e);
                }
                throw new WebBeansException("Error occurred while reading Extension service list", e);
            }
        }
        for (Map.Entry entry : extensionBeans.entrySet()) {
            new ObserverMethodsBuilder(this.webBeansContext, (AnnotatedType)entry.getValue()).defineObserverMethods((AbstractOwbBean)entry.getKey(), true);
            this.webBeansContext.getNotificationManager().clearCaches();
        }
    }

    public ExtensionBean<Extension> createExtensionBean(ExtensionBeanBuilder<Extension> extensionBeanBuilder) {
        Extension extension = extensionBeanBuilder.getExtension();
        Class<?> extensionClass = extension.getClass();
        this.extensions.put(extensionClass, extension);
        ExtensionBean<Extension> bean = extensionBeanBuilder.buildBean();
        this.manager.addBean(bean);
        return bean;
    }

    public void clear() {
        this.extensions.clear();
        this.extensionClasses.clear();
    }
}

