/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.AbstractBeanBuilder;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.events.ProcessBeanAttributesImpl;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerMethodBeansBuilder<T>
extends AbstractBeanBuilder {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ProducerMethodBeansBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(annotatedType, "annotated type");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ProducerMethodBean<?>> defineProducerMethods(InjectionTargetBean<T> bean, Set<ProducerFieldBean<?>> producerFields) {
        HashSet producerBeans = new HashSet();
        Set annotatedMethods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType);
        HashSet skipMethods = new HashSet();
        for (AnnotatedMethod<T> annotatedMethod : annotatedMethods) {
            boolean isProducer = annotatedMethod.isAnnotationPresent(Produces.class);
            if (isProducer && annotatedMethod.getJavaMember().getDeclaringClass().equals(this.annotatedType.getJavaClass())) {
                this.checkProducerMethodForDeployment(annotatedMethod);
                boolean specialize = false;
                if (annotatedMethod.isAnnotationPresent(Specializes.class)) {
                    if (annotatedMethod.isStatic()) {
                        throw new WebBeansConfigurationException("Specializing annotated producer method : " + annotatedMethod + " can not be static");
                    }
                    specialize = true;
                }
                AnnotatedMethod<T> method = annotatedMethod;
                ProcessBeanAttributesImpl<T> processBeanAttributes = this.webBeansContext.getWebBeansUtil().fireProcessBeanAttributes((Annotated)annotatedMethod, annotatedMethod.getJavaMember().getReturnType(), BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(method).build());
                if (processBeanAttributes == null) continue;
                ProducerMethodBeanBuilder<T> producerMethodBeanCreator = new ProducerMethodBeanBuilder<T>(bean, annotatedMethod, processBeanAttributes.getAttributes());
                ProducerMethodBean<T> producerMethodBean = producerMethodBeanCreator.getBean();
                UnproxyableResolutionException lazyException = this.webBeansContext.getDeploymentValidationService().validateProxyable(producerMethodBean, processBeanAttributes.isIgnoreFinalMethods());
                if (lazyException != null) {
                    throw lazyException;
                }
                producerMethodBeanCreator.validate();
                if (specialize) {
                    producerMethodBean.setSpecializedBean(true);
                }
                producerMethodBean.setCreatorMethod(annotatedMethod.getJavaMember());
                this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, producerMethodBean, AnnotationUtil.asArray(annotatedMethod.getAnnotations()));
                WebBeansUtil.checkProducerGenericType(producerMethodBean, annotatedMethod.getJavaMember());
                producerBeans.add(producerMethodBean);
                continue;
            }
            if (!isProducer) continue;
            skipMethods.add(annotatedMethod);
        }
        this.validateNoDisposerWithoutProducer(annotatedMethods, producerBeans, producerFields, skipMethods);
        return producerBeans;
    }

    private void checkProducerMethodForDeployment(AnnotatedMethod<? super T> annotatedMethod) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument");
        if (annotatedMethod.isAnnotationPresent(Inject.class) || annotatedMethod.isAnnotationPresent(Disposes.class) || annotatedMethod.isAnnotationPresent(Observes.class) || annotatedMethod.isAnnotationPresent(ObservesAsync.class)) {
            throw new WebBeansConfigurationException("Producer annotated method : " + annotatedMethod + " can not be annotated with @Initializer/@Destructor annotation or has a parameter annotated with @Disposes/@Observes");
        }
    }
}

