/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public class ObserverMethodsBuilder<T> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ObserverMethodsBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(annotatedType, "annotated type");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ObserverMethod<?>> defineObserverMethods(AbstractOwbBean<T> ownerBean, boolean checkContainerEvents) {
        HashSet definedObservers = new HashSet();
        for (AnnotatedMethod<T> annotatedMethod : this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType)) {
            ObserverMethod<T> observerMethod = this.defineObserverMethod(ownerBean, annotatedMethod, checkContainerEvents);
            if (observerMethod == null) continue;
            definedObservers.add(observerMethod);
        }
        this.checkDefinedObservers(ownerBean, definedObservers);
        return definedObservers;
    }

    public ObserverMethod<?> defineObserverMethod(AbstractOwbBean<T> ownerBean, AnnotatedMethod<?> annotatedMethod, boolean checkContainerEvents) {
        AnnotatedParameter<?> observesParameter = this.findObservesParameter(annotatedMethod);
        if (observesParameter != null) {
            this.checkObserverMethodConditions(ownerBean, observesParameter);
            ObserverMethod<?> definedObserver = this.webBeansContext.getNotificationManager().getObservableMethodForAnnotatedMethod(annotatedMethod, observesParameter, ownerBean, checkContainerEvents);
            return definedObserver;
        }
        return null;
    }

    private AnnotatedParameter<?> findObservesParameter(AnnotatedMethod<?> annotatedMethod) {
        List parameters = annotatedMethod.getParameters();
        AnnotatedParameter observesParameter = null;
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(Observes.class) && !parameter.isAnnotationPresent(ObservesAsync.class)) continue;
            if (observesParameter != null) {
                throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " must not define two parameters that are annotated with @Observes or @ObservesAsync");
            }
            observesParameter = parameter;
        }
        return observesParameter;
    }

    private void checkDefinedObservers(AbstractOwbBean<T> ownerBean, Set<ObserverMethod<?>> definedObservers) {
        if (!definedObservers.isEmpty()) {
            for (InjectionPoint ip : ownerBean.getInjectionPoints()) {
                Set qualifiers = ip.getQualifiers();
                if (EventMetadata.class != ip.getType() || qualifiers == null || ip.getQualifiers().size() != 1 || Default.class != ((Annotation)qualifiers.iterator().next()).annotationType()) continue;
                throw new WebBeansConfigurationException(ip + " is not an observer parameter");
            }
        }
    }

    private void checkObserverMethodConditions(AbstractOwbBean<?> bean, AnnotatedParameter<?> annotatedParameter) {
        Asserts.assertNotNull(annotatedParameter, "annotatedParameter");
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedParameter.getDeclaringCallable();
        if (annotatedMethod.isAnnotationPresent(Produces.class) || annotatedMethod.isAnnotationPresent(Inject.class)) {
            throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " can not annotated with annotation in the list {@Produces, @Initializer, @Destructor}");
        }
        if (AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " can not annotated with annotation @Disposes");
        }
        if (bean != null && bean.getScope().equals(Dependent.class)) {
            Observes observes = (Observes)annotatedParameter.getAnnotation(Observes.class);
            ObservesAsync observesAsync = (ObservesAsync)annotatedParameter.getAnnotation(ObservesAsync.class);
            if (observes != null && observesAsync != null) {
                throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " can not be annotated with both @Observes *and* @ObservesAsync!");
            }
            Reception reception = observes != null ? observes.notifyObserver() : observesAsync.notifyObserver();
            if (reception == Reception.IF_EXISTS) {
                throw new WebBeansConfigurationException("Dependent Bean : " + this.annotatedType.getJavaClass() + " can not define observer method with @Receiver = IF_EXIST");
            }
        }
    }
}

