/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class ConversationImpl
implements Conversation,
Serializable {
    private static final long serialVersionUID = 8511063860333431722L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ConversationImpl.class);
    private String id;
    private boolean isTransient = true;
    private long timeout;
    private long lastAccessTime;
    private transient RuntimeException problemDuringCreation;
    private transient Set<Long> threadsUsingIt = new HashSet<Long>();
    private transient WebBeansContext webBeansContext;

    public ConversationImpl() {
    }

    public ConversationImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        try {
            this.timeout = Long.parseLong(this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.timeoutInterval", "1800000"));
        }
        catch (NumberFormatException e) {
            this.timeout = 1800000L;
        }
    }

    public void begin() {
        this.begin(null);
    }

    public void begin(String id) {
        if (id == null) {
            id = this.webBeansContext.getConversationService().generateConversationId();
        }
        if (!this.isTransient) {
            logger.log(Level.WARNING, "WARN_0003", id);
            throw new IllegalStateException();
        }
        this.isTransient = false;
        this.id = id;
        this.iUseIt();
        this.updateLastAccessTime();
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        ConversationContext conversationContext = (ConversationContext)this.webBeansContext.getContextsService().getCurrentContext(ConversationScoped.class);
        conversationManager.addToConversationStorage(conversationContext, id);
    }

    public void end() {
        this.checkThreadUsage();
        if (this.isTransient) {
            logger.log(Level.WARNING, "WARN_0004", this.id);
            throw new IllegalStateException(this.toString() + " has already ended");
        }
        this.iDontUseItAnymore();
        this.id = null;
        this.isTransient = true;
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        ConversationContext conversationContext = (ConversationContext)this.webBeansContext.getContextsService().getCurrentContext(ConversationScoped.class);
        conversationManager.removeConversationFromStorage(conversationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int iUseIt() {
        long thread = Thread.currentThread().getId();
        ConversationImpl conversationImpl = this;
        synchronized (conversationImpl) {
            this.threadsUsingIt.add(thread);
            int size = this.threadsUsingIt.size();
            if (size == 1) {
                this.updateLastAccessTime();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iDontUseItAnymore() {
        long thread = Thread.currentThread().getId();
        ConversationImpl conversationImpl = this;
        synchronized (conversationImpl) {
            this.threadsUsingIt.remove(thread);
        }
    }

    public String getId() {
        return this.id;
    }

    public long getTimeout() {
        this.checkThreadUsage();
        return this.timeout;
    }

    public boolean isTransient() {
        this.checkThreadUsage();
        return this.isTransient;
    }

    private synchronized void checkThreadUsage() {
        if (this.threadsUsingIt.size() > 1) {
            throw new BusyConversationException("Propogated conversation with sessionid/cid=" + this.id + " is used by other request.");
        }
    }

    public void setTimeout(long milliseconds) {
        this.checkThreadUsage();
        this.timeout = milliseconds;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String toString() {
        return "Conversation with id [ " + this.id + " ]";
    }

    public RuntimeException getProblemDuringCreation() {
        return this.problemDuringCreation;
    }

    public void setProblemDuringCreation(RuntimeException problemDuringCreation) {
        this.problemDuringCreation = problemDuringCreation;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webBeansContext = WebBeansContext.currentInstance();
        this.threadsUsingIt = new HashSet<Long>();
    }
}

