/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

public class ObserverMethodsBuilder<T> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ObserverMethodsBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ObserverMethod<?>> defineObserverMethods(AbstractOwbBean<T> bean) {
        HashSet definedObservers = new HashSet();
        for (AnnotatedMethod<T> annotatedMethod : this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType)) {
            List parameters = annotatedMethod.getParameters();
            AnnotatedParameter observesParameter = null;
            for (AnnotatedParameter parameter : parameters) {
                if (!parameter.isAnnotationPresent(Observes.class)) continue;
                if (observesParameter != null) {
                    throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " must not define two parameters that are annotated with @Observes");
                }
                observesParameter = parameter;
            }
            if (observesParameter == null) continue;
            this.checkObserverMethodConditions(bean, observesParameter);
            ObserverMethod<T> definedObserver = this.webBeansContext.getBeanManagerImpl().getNotificationManager().getObservableMethodForAnnotatedMethod(annotatedMethod, observesParameter, bean);
            definedObservers.add(definedObserver);
        }
        if (!definedObservers.isEmpty()) {
            for (InjectionPoint ip : bean.getInjectionPoints()) {
                Set qualifiers = ip.getQualifiers();
                if (EventMetadata.class != ip.getType() || qualifiers == null || ip.getQualifiers().size() != 1 || Default.class != ((Annotation)qualifiers.iterator().next()).annotationType()) continue;
                throw new WebBeansConfigurationException(ip + " is not an observer parameter");
            }
        }
        return definedObservers;
    }

    private void checkObserverMethodConditions(AbstractOwbBean<?> bean, AnnotatedParameter<?> annotatedParameter) {
        Observes observes;
        Reception reception;
        Asserts.assertNotNull(annotatedParameter, "annotatedParameter can not be null");
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedParameter.getDeclaringCallable();
        if (annotatedMethod.isAnnotationPresent(Produces.class) || annotatedMethod.isAnnotationPresent(Inject.class)) {
            throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " can not annotated with annotation in the list {@Produces, @Initializer, @Destructor}");
        }
        if (AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " can not annotated with annotation @Disposes");
        }
        if (bean.getScope().equals(Dependent.class) && (reception = (observes = (Observes)annotatedParameter.getAnnotation(Observes.class)).notifyObserver()).equals((Object)Reception.IF_EXISTS)) {
            throw new WebBeansConfigurationException("Dependent Bean : " + this.annotatedType.getJavaClass() + " can not define observer method with @Receiver = IF_EXIST");
        }
    }
}

