/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.CdiInterceptorBean;
import org.apache.webbeans.component.DecoratorBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.CdiInterceptorBeanBuilder;
import org.apache.webbeans.component.creation.DecoratorBeanBuilder;
import org.apache.webbeans.component.creation.ManagedBeanBuilder;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeansBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeansBuilder;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.corespi.se.DefaultJndiService;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.exception.inject.DeploymentException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.discovery.AfterBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AfterDeploymentValidationImpl;
import org.apache.webbeans.portable.events.discovery.BeforeBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessManagedBean;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansWebPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class BeansDeployer {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(BeansDeployer.class);
    public static final String JAVAX_ENTERPRISE_PACKAGE = "javax.enterprise.";
    protected boolean deployed = false;
    protected WebBeansXMLConfigurator xmlConfigurator = null;
    protected boolean discoverEjb = false;
    private final WebBeansContext webBeansContext;

    public BeansDeployer(WebBeansXMLConfigurator xmlConfigurator, WebBeansContext webBeansContext) {
        this.xmlConfigurator = xmlConfigurator;
        this.webBeansContext = webBeansContext;
        String usage = this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService");
        this.discoverEjb = Boolean.parseBoolean(usage);
    }

    public synchronized void deploy(ScannerService scanner) {
        try {
            if (!this.deployed) {
                this.webBeansContext.getExtensionLoader().loadExtensionServices();
                JNDIService service = this.webBeansContext.getService(JNDIService.class);
                if (service instanceof DefaultJndiService) {
                    service.bind("java:comp/BeanManager", (Object)new InjectableBeanManager(this.webBeansContext.getBeanManagerImpl()));
                } else {
                    service.bind("java:comp/BeanManager", (Object)this.webBeansContext.getBeanManagerImpl().getReference());
                }
                this.webBeansContext.getBeanManagerImpl().addInternalBean(this.webBeansContext.getWebBeansUtil().getManagerBean());
                this.fireBeforeBeanDiscoveryEvent();
                this.deployFromXML(scanner);
                this.checkStereoTypes(scanner);
                this.configureDefaultBeans();
                this.deployFromClassPath(scanner);
                this.deployAdditionalAnnotatedTypes();
                this.processSpecializations(scanner);
                this.fireAfterBeanDiscoveryEvent();
                this.validateInjectionPoints();
                this.fireAfterDeploymentValidationEvent();
                scanner.release();
                this.webBeansContext.getAnnotatedElementFactory().clear();
            }
        }
        catch (UnsatisfiedResolutionException e) {
            throw new DeploymentException(e);
        }
        catch (AmbiguousResolutionException e) {
            throw new DeploymentException(e);
        }
        catch (UnproxyableResolutionException e) {
            throw new DeploymentException(e);
        }
        catch (WebBeansConfigurationException e) {
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
        finally {
            this.deployed = true;
        }
    }

    private void configureDefaultBeans() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        beanManager.addInternalBean(webBeansUtil.getConversationBean());
        beanManager.addInternalBean(webBeansUtil.getInjectionPointBean());
        beanManager.addInternalBean(webBeansUtil.getInstanceBean());
        beanManager.addInternalBean(webBeansUtil.getEventBean());
        beanManager.addInternalBean(webBeansUtil.getBeanMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getInterceptorMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getDecoratorMetadataBean());
        beanManager.addInternalBean(webBeansUtil.getInterceptedOrDecoratedBeanMetadataBean());
        OpenWebBeansJavaEEPlugin beanEeProvider = this.webBeansContext.getPluginLoader().getJavaEEPlugin();
        OpenWebBeansWebPlugin beanWebProvider = this.webBeansContext.getPluginLoader().getWebPlugin();
        if (beanEeProvider != null) {
            this.addDefaultBean(this.webBeansContext, "org.apache.webbeans.ee.common.beans.PrincipalBean");
            this.addDefaultBean(this.webBeansContext, "org.apache.webbeans.ee.beans.ValidatorBean");
            this.addDefaultBean(this.webBeansContext, "org.apache.webbeans.ee.beans.ValidatorFactoryBean");
            this.addDefaultBean(this.webBeansContext, "org.apache.webbeans.ee.beans.UserTransactionBean");
        } else if (beanWebProvider != null) {
            this.addDefaultBean(this.webBeansContext, "org.apache.webbeans.ee.common.beans.PrincipalBean");
        }
    }

    private void addDefaultBean(WebBeansContext ctx, String className) {
        Bean bean = null;
        Class<?> beanClass = ClassUtil.getClassFromName(className);
        if (beanClass != null) {
            bean = (Bean)this.newInstance(ctx, beanClass);
        }
        if (bean != null) {
            ctx.getBeanManagerImpl().addInternalBean(bean);
        }
    }

    private Object newInstance(WebBeansContext wbc, Class<?> clazz) {
        try {
            if (System.getSecurityManager() != null) {
                Constructor c = this.webBeansContext.getSecurityService().doPrivilegedGetConstructor(clazz, new Class[]{WebBeansContext.class});
                if (c == null) {
                    return this.webBeansContext.getSecurityService().doPrivilegedObjectCreate(clazz);
                }
                return c.newInstance(wbc);
            }
            if (clazz.getConstructors().length > 0) {
                try {
                    return clazz.getConstructor(WebBeansContext.class).newInstance(wbc);
                }
                catch (Exception e) {
                    return clazz.newInstance();
                }
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException) {
                cause = e.getCause();
            }
            String error = "Error occurred while creating an instance of class : " + clazz.getName();
            logger.log(Level.SEVERE, error, cause);
            throw new WebBeansException(error, cause);
        }
    }

    private void fireBeforeBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireLifecycleEvent(new BeforeBeanDiscoveryImpl(this.webBeansContext), new Annotation[0]);
    }

    private void fireAfterBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireLifecycleEvent(new AfterBeanDiscoveryImpl(this.webBeansContext), new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by AfterBeanDiscovery event observers. Look at logs for further details");
    }

    private void fireAfterDeploymentValidationEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireLifecycleEvent(new AfterDeploymentValidationImpl(manager), new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by AfterDeploymentValidation event observers. Look at logs for further details");
    }

    private void validateInjectionPoints() {
        logger.fine("Validation of injection points has started.");
        this.webBeansContext.getDecoratorsManager().validateDecoratorClasses();
        this.webBeansContext.getInterceptorsManager().validateInterceptorClasses();
        Set<Bean<?>> beans = new HashSet();
        Set<Decorator<?>> decorators = this.webBeansContext.getDecoratorsManager().getDecorators();
        beans.addAll(decorators);
        logger.fine("Validation of the decorator's injection points has started.");
        this.validate(beans);
        beans.clear();
        List<Interceptor<?>> interceptors = this.webBeansContext.getInterceptorsManager().getCdiInterceptors();
        for (Interceptor<?> interceptor : interceptors) {
            beans.add((Bean<?>)interceptor);
        }
        logger.fine("Validation of the interceptor's injection points has started.");
        this.validate(beans);
        beans.clear();
        beans = this.webBeansContext.getBeanManagerImpl().getBeans();
        this.validate(beans);
        logger.info("INFO_0003");
    }

    private <T> void validate(Set<Bean<?>> beans) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        if (beans != null && beans.size() > 0) {
            Stack<String> beanNames = new Stack<String>();
            for (Bean<?> bean : beans) {
                OwbBean owbBean;
                if (bean instanceof OwbBean && !((OwbBean)bean).isEnabled() || bean.getBeanClass().getName().startsWith(JAVAX_ENTERPRISE_PACKAGE)) continue;
                String beanName = bean.getName();
                if (beanName != null) {
                    beanNames.push(beanName);
                }
                if (bean instanceof OwbBean && !(bean instanceof Interceptor) && !(bean instanceof Decorator) && (owbBean = (OwbBean)bean).getProducer() instanceof AbstractProducer) {
                    AbstractProducer producer = (AbstractProducer)owbBean.getProducer();
                    AnnotatedType annotatedType = owbBean instanceof InjectionTargetBean ? ((InjectionTargetBean)owbBean).getAnnotatedType() : this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(owbBean.getReturnType());
                    producer.defineInterceptorStack(owbBean, annotatedType, this.webBeansContext);
                }
                this.checkPassivationScope(bean);
                Set injectionPoints = bean.getInjectionPoints();
                if (injectionPoints == null) continue;
                for (InjectionPoint injectionPoint : injectionPoints) {
                    if (!injectionPoint.isDelegate()) {
                        manager.validate(injectionPoint);
                        continue;
                    }
                    if (bean.getBeanClass().isAnnotationPresent(javax.decorator.Decorator.class) || this.webBeansContext.getDecoratorsManager().containsCustomDecoratorClass(bean.getBeanClass())) continue;
                    throw new WebBeansConfigurationException("Delegate injection points can not defined by beans that are not decorator. Injection point : " + injectionPoint);
                }
            }
            this.validateBeanNames(beanNames);
            beanNames.clear();
        }
    }

    private void validateBeanNames(Stack<String> beanNames) {
        if (beanNames.size() > 0) {
            for (String beanName : beanNames) {
                for (String other : beanNames) {
                    String part = null;
                    int i = beanName.lastIndexOf(46);
                    if (i != -1) {
                        part = beanName.substring(0, i);
                    }
                    if (beanName.equals(other)) {
                        InjectionResolver resolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
                        Set<Bean<?>> beans = resolver.implResolveByName(beanName);
                        if (beans.size() <= 1 || (beans = resolver.findByAlternatives(beans)).size() <= 1) continue;
                        InjectionExceptionUtil.throwAmbiguousResolutionExceptionForBeanName(beans, beanName);
                        continue;
                    }
                    if (part == null || !part.equals(other)) continue;
                    throw new WebBeansConfigurationException("EL name of one bean is of the form x.y, where y is a valid bean EL name, and x is the EL name of the other bean for the bean name : " + beanName);
                }
            }
        }
    }

    protected void deployFromClassPath(ScannerService scanner) throws ClassNotFoundException {
        logger.fine("Deploying configurations from class files has started.");
        Set classIndex = scanner.getBeanClasses();
        if (classIndex != null) {
            AnnotatedElementFactory annotatedElementFactory = this.webBeansContext.getAnnotatedElementFactory();
            for (Class implClass : classIndex) {
                AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(implClass);
                if (null != annotatedType) {
                    this.deploySingleAnnotatedType(implClass, annotatedType);
                    this.webBeansContext.getBeanManagerImpl().removeAdditionalAnnotatedType(annotatedType);
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Error creating managed bean " + implClass);
            }
        }
        logger.fine("Deploying configurations from class files has ended.");
    }

    private void deployAdditionalAnnotatedTypes() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        Collection<AnnotatedType<?>> annotatedTypes = beanManager.getAdditionalAnnotatedTypes();
        for (AnnotatedType<?> type : annotatedTypes) {
            Class implClass = type.getJavaClass();
            this.deploySingleAnnotatedType(implClass, type);
        }
    }

    private void deploySingleAnnotatedType(Class implClass, AnnotatedType annotatedType) {
        GProcessAnnotatedType processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
        if (processAnnotatedEvent.isVeto()) {
            return;
        }
        Class beanClass = processAnnotatedEvent.getAnnotatedType().getJavaClass();
        if (this.discoverEjb && EJBWebBeansConfigurator.isSessionBean(implClass, this.webBeansContext)) {
            logger.log(Level.FINE, "Found Enterprise Bean with class name : [{0}]", implClass.getName());
            this.defineEnterpriseWebBean(implClass, processAnnotatedEvent);
        } else if ((ClassUtil.isConcrete(beanClass) || WebBeansUtil.isDecorator(processAnnotatedEvent.getAnnotatedType())) && this.isValidManagedBean(processAnnotatedEvent.getAnnotatedType())) {
            this.defineManagedBean(processAnnotatedEvent);
        }
    }

    private boolean isValidManagedBean(AnnotatedType<?> type) {
        Class beanClass = type.getJavaClass();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        if (!webBeansUtil.isConstructorOk(beanClass)) {
            if (BeansDeployer.isNormalScoped(type)) {
                logger.info("Bean implementation class : " + beanClass.getName() + " must define at least one Constructor");
            }
            return false;
        }
        try {
            webBeansUtil.checkManagedBean(beanClass);
        }
        catch (DefinitionException e) {
            logger.log(Level.FINE, "skipped deployment of: " + beanClass.getName() + " reason: " + e.getMessage());
            logger.log(Level.FINER, "skipped deployment of: " + beanClass.getName() + " details: ", e);
            return false;
        }
        webBeansUtil.checkManagedBeanCondition(beanClass);
        return true;
    }

    private static boolean isNormalScoped(AnnotatedType<?> type) {
        Set annotations = type.getAnnotations();
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (!AnnotationUtil.hasMetaAnnotation(a.annotationType().getAnnotations(), NormalScope.class) && !AnnotationUtil.hasAnnotation(a.annotationType().getAnnotations(), NormalScope.class)) continue;
                return true;
            }
        }
        return false;
    }

    protected void deployFromXML(ScannerService scanner) throws WebBeansDeploymentException {
        logger.fine("Deploying configurations from XML files has started.");
        Set xmlLocations = scanner.getBeanXmls();
        for (URL url : xmlLocations) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("OpenWebBeans BeansDeployer configuring: " + url.toExternalForm());
            }
            InputStream fis = null;
            try {
                fis = url.openStream();
                this.xmlConfigurator.configure(fis, url.toExternalForm(), scanner);
            }
            catch (IOException e) {
                throw new WebBeansDeploymentException("Error configuring: filename: " + url.toExternalForm(), e);
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deploying configurations from XML has ended successfully.");
        }
    }

    protected void processSpecializations(ScannerService scanner) {
        logger.fine("Checking Specialization constraints has started.");
        try {
            Set beanClasses = scanner.getBeanClasses();
            if (beanClasses != null && beanClasses.size() > 0) {
                ArrayList superClassList = new ArrayList();
                ArrayList specialClassList = new ArrayList();
                for (Class specialClass : beanClasses) {
                    if (!AnnotationUtil.hasClassAnnotation(specialClass, Specializes.class)) continue;
                    Class superClass = specialClass.getSuperclass();
                    if (superClass.equals(Object.class)) {
                        throw new WebBeansConfigurationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0003") + specialClass.getName() + WebBeansLoggerFacade.getTokenString("EXCEPT_0004"));
                    }
                    if (superClassList.contains(superClass)) {
                        InconsistentSpecializationException exception = new InconsistentSpecializationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0005") + superClass.getName());
                        throw new WebBeansDeploymentException(exception);
                    }
                    superClassList.add(superClass);
                    specialClassList.add(specialClass);
                }
                this.webBeansContext.getWebBeansUtil().configureSpecializations(specialClassList);
            }
            this.webBeansContext.getWebBeansUtil().configureProducerMethodSpecializations();
        }
        catch (DefinitionException e) {
            throw e;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
        logger.fine("Checking Specialization constraints has ended.");
    }

    protected void checkPassivationScope(Bean<?> beanObj) {
        boolean validate = false;
        if (beanObj instanceof EnterpriseBeanMarker) {
            EnterpriseBeanMarker marker = (EnterpriseBeanMarker)beanObj;
            if (marker.isPassivationCapable()) {
                validate = true;
            }
        } else if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(beanObj.getScope())) {
            if (WebBeansUtil.getPassivationId(beanObj) == null && !(beanObj instanceof AbstractProducerBean)) {
                throw new WebBeansConfigurationException("Passivation scoped defined bean must be passivation capable, but bean : " + beanObj.toString() + " is not passivation capable");
            }
            validate = true;
        }
        if (validate) {
            this.webBeansContext.getDeploymentValidationService().validatePassivationCapable((OwbBean)beanObj);
        }
    }

    protected void checkStereoTypes(ScannerService scanner) {
        logger.fine("Checking StereoType constraints has started.");
        this.addDefaultStereoTypes();
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        Set beanClasses = scanner.getBeanClasses();
        if (beanClasses != null && beanClasses.size() > 0) {
            for (Class beanClass : beanClasses) {
                Class stereoClass;
                if (!beanClass.isAnnotation() || !annotationManager.isStereoTypeAnnotation(stereoClass = beanClass)) continue;
                this.webBeansContext.getAnnotationManager().checkStereoTypeClass(stereoClass, stereoClass.getDeclaredAnnotations());
                StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereoClass);
                this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
            }
        }
        logger.fine("Checking StereoType constraints has ended.");
    }

    protected void addDefaultStereoTypes() {
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, Model.class);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
    }

    protected <T> void defineManagedBean(ProcessAnnotatedTypeImpl<T> processAnnotatedEvent) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        AnnotatedType<T> annotatedType = processAnnotatedEvent.getAnnotatedType();
        Class beanClass = processAnnotatedEvent.getAnnotatedType().getJavaClass();
        if (this.webBeansContext.getWebBeansUtil().supportsJavaEeComponentInjections(beanClass)) {
            GProcessInjectionTarget processInjectionTargetEvent = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEventForJavaEeComponents(beanClass);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
            this.webBeansContext.getAnnotationManager().checkInjectionPointForInjectInjectionPoint(beanClass);
        }
        BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedType).build();
        ManagedBeanBuilder managedBeanCreator = new ManagedBeanBuilder(this.webBeansContext, annotatedType, beanAttributes);
        if (WebBeansUtil.isDecorator(annotatedType)) {
            DecoratorBeanBuilder<T> dbb;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found Managed Bean Decorator with class name : [{0}]", annotatedType.getJavaClass().getName());
            }
            if ((dbb = new DecoratorBeanBuilder<T>(this.webBeansContext, annotatedType, beanAttributes)).isDecoratorEnabled()) {
                dbb.defineDecoratorRules();
                DecoratorBean<T> decorator = dbb.getBean();
                this.webBeansContext.getDecoratorsManager().addDecorator(decorator);
            }
        } else if (WebBeansUtil.isCdiInterceptor(annotatedType)) {
            CdiInterceptorBeanBuilder<T> ibb;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found Managed Bean Interceptor with class name : [{0}]", annotatedType.getJavaClass().getName());
            }
            if ((ibb = new CdiInterceptorBeanBuilder<T>(this.webBeansContext, annotatedType, beanAttributes)).isInterceptorEnabled()) {
                ibb.defineCdiInterceptorRules();
                CdiInterceptorBean interceptor = (CdiInterceptorBean)ibb.getBean();
                this.webBeansContext.getInterceptorsManager().addCdiInterceptor(interceptor);
            }
        } else {
            Object bean = managedBeanCreator.getBean();
            if (this.webBeansContext.getDecoratorsManager().containsCustomDecoratorClass(annotatedType.getJavaClass()) || this.webBeansContext.getInterceptorsManager().containsCustomInterceptorClass(annotatedType.getJavaClass())) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found Managed Bean with class name : [{0}]", annotatedType.getJavaClass().getName());
            }
            Set<Object> observerMethods = new HashSet();
            if (((AbstractOwbBean)bean).isEnabled()) {
                observerMethods = new ObserverMethodsBuilder(this.webBeansContext, ((InjectionTargetBean)bean).getAnnotatedType()).defineObserverMethods(bean);
            }
            Set<ProducerMethodBean<?>> producerMethods = new ProducerMethodBeansBuilder(((AbstractOwbBean)bean).getWebBeansContext(), ((InjectionTargetBean)bean).getAnnotatedType()).defineProducerMethods(bean);
            Set<ProducerFieldBean<?>> producerFields = new ProducerFieldBeansBuilder(((AbstractOwbBean)bean).getWebBeansContext(), ((InjectionTargetBean)bean).getAnnotatedType()).defineProducerFields(bean);
            ManagedBean managedBean = (ManagedBean)bean;
            HashMap annotatedMethods = new HashMap();
            for (ProducerMethodBean<?> producerMethod : producerMethods) {
                AnnotatedMethod<T> method = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
                this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
                annotatedMethods.put(producerMethod, method);
            }
            HashMap annotatedFields = new HashMap();
            for (ProducerFieldBean<?> producerField : producerFields) {
                this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
                annotatedFields.put(producerField, this.webBeansContext.getAnnotatedElementFactory().newAnnotatedField(producerField.getCreatorField(), this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(producerField.getBeanClass())));
            }
            HashMap observerMethodsMap = new HashMap();
            for (ObserverMethod observerMethod : observerMethods) {
                ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
                AnnotatedMethod annotatedMethod = impl.getObserverMethod();
                observerMethodsMap.put(observerMethod, annotatedMethod);
            }
            BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
            GProcessManagedBean gProcessManagedBean = new GProcessManagedBean((ManagedBean<?>)managedBean, annotatedType);
            beanManager.fireEvent((Object)gProcessManagedBean, new Annotation[0]);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessManagedBean event observers for managed beans. Look at logs for further details");
            this.webBeansContext.getWebBeansUtil().fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
            this.webBeansContext.getWebBeansUtil().fireProcessProducerFieldBeanEvent(annotatedFields);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
            this.webBeansContext.getWebBeansUtil().fireProcessObservableMethodBeanEvent(observerMethodsMap);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
            if (!this.webBeansContext.getWebBeansUtil().isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
                beanManager.addBean((Bean<?>)bean);
                for (ProducerMethodBean<?> producerMethodBean : producerMethods) {
                    beanManager.addBean(producerMethodBean);
                }
                for (ProducerFieldBean producerFieldBean : producerFields) {
                    beanManager.addBean(producerFieldBean);
                }
            }
        }
    }

    protected <T> void defineEnterpriseWebBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        InjectionTargetBean bean = (InjectionTargetBean)EJBWebBeansConfigurator.defineEjbBean(clazz, processAnnotatedTypeEvent, this.webBeansContext);
        this.webBeansContext.getWebBeansUtil().setInjectionTargetBeanEnableFlag(bean);
    }
}

