/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.deployment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.util.Asserts;

public class StereoTypeManager {
    private Map<String, IStereoTypeModel> stereoTypeMap = new ConcurrentHashMap<String, IStereoTypeModel>();

    public static StereoTypeManager getInstance() {
        StereoTypeManager instance = (StereoTypeManager)WebBeansFinder.getSingletonInstance(StereoTypeManager.class.getName());
        return instance;
    }

    public void addStereoTypeModel(IStereoTypeModel model) {
        Asserts.assertNotNull(model, "model parameter can not be null");
        this.stereoTypeMap.put(model.getName(), model);
    }

    public IStereoTypeModel getStereoTypeModel(String modelName) {
        Asserts.assertNotNull(modelName, "modelName parameter can not be null");
        if (this.stereoTypeMap.containsKey(modelName)) {
            return this.stereoTypeMap.get(modelName);
        }
        return null;
    }
}

