/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.context.creational.EjbInterceptorContext;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.WebBeansUtil;

public class InterceptorDataImpl
implements InterceptorData {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorDataImpl.class);
    private Method aroundInvoke = null;
    private Method postConstruct = null;
    private Method preDestroy = null;
    private Interceptor<?> webBeansInterceptor;
    private boolean definedInInterceptorClass;
    private boolean definedInMethod;
    private Method annotatedMethod;
    private boolean isDefinedWithWebBeansInterceptor;
    private Class<?> interceptorClass = null;
    private WebBeansDecoratorInterceptor decoratorInterceptor = null;

    public InterceptorDataImpl(boolean isDefinedWithWebBeansInterceptor) {
        this(isDefinedWithWebBeansInterceptor, null);
    }

    public InterceptorDataImpl(boolean isDefinedWithWebBeansInterceptor, WebBeansDecoratorInterceptor decoratorInterceptor) {
        this.isDefinedWithWebBeansInterceptor = isDefinedWithWebBeansInterceptor;
        this.decoratorInterceptor = decoratorInterceptor;
    }

    @Override
    public Class<?> getInterceptorClass() {
        return this.interceptorClass;
    }

    @Override
    public void setInterceptorClass(Class<?> clazz) {
        this.interceptorClass = clazz;
    }

    @Override
    public void setInterceptorMethod(Method m, Class<? extends Annotation> annotation) {
        if (annotation.equals(AroundInvoke.class)) {
            this.setAroundInvoke(m);
        } else if (annotation.equals(PostConstruct.class)) {
            this.setPostConstruct(m);
        } else if (annotation.equals(PreDestroy.class)) {
            this.setPreDestroy(m);
        }
    }

    public void setAroundInvoke(Method m) {
        this.aroundInvoke = m;
    }

    protected void setPostConstruct(Method m) {
        this.postConstruct = m;
    }

    protected void setPreDestroy(Method m) {
        this.preDestroy = m;
    }

    @Override
    public Method getPostConstruct() {
        return this.postConstruct;
    }

    @Override
    public Method getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public Method getAroundInvoke() {
        return this.aroundInvoke;
    }

    @Override
    public boolean isDefinedInInterceptorClass() {
        return this.definedInInterceptorClass;
    }

    @Override
    public void setDefinedInInterceptorClass(boolean definedInInterceptorClass) {
        this.definedInInterceptorClass = definedInInterceptorClass;
    }

    @Override
    public boolean isDefinedInMethod() {
        return this.definedInMethod;
    }

    @Override
    public void setDefinedInMethod(boolean definedInMethod) {
        this.definedInMethod = definedInMethod;
    }

    @Override
    public Method getInterceptorBindingMethod() {
        return this.annotatedMethod;
    }

    @Override
    public void setInterceptorBindingMethod(Method annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
    }

    @Override
    public boolean isDefinedWithWebBeansInterceptor() {
        return this.isDefinedWithWebBeansInterceptor;
    }

    @Override
    public Interceptor<?> getWebBeansInterceptor() {
        return this.webBeansInterceptor;
    }

    @Override
    public void setWebBeansInterceptor(Interceptor<?> webBeansInterceptor) {
        this.webBeansInterceptor = webBeansInterceptor;
    }

    @Override
    public Method getInterceptorMethod() {
        if (this.aroundInvoke != null) {
            return this.aroundInvoke;
        }
        if (this.postConstruct != null) {
            return this.postConstruct;
        }
        if (this.preDestroy != null) {
            return this.preDestroy;
        }
        return null;
    }

    @Override
    public boolean isLifecycleInterceptor() {
        return this.preDestroy != null || this.postConstruct != null;
    }

    @Override
    public Object createNewInstance(Object ownerInstance, CreationalContextImpl<?> ownerCreationalContext) {
        if (this.isDefinedWithWebBeansInterceptor && this.definedInInterceptorClass) {
            Object interceptor = null;
            if (this.webBeansInterceptor == null) {
                return this.decoratorInterceptor;
            }
            interceptor = ownerCreationalContext.getDependentInterceptor(ownerInstance, (Contextual<?>)this.webBeansInterceptor);
            if (interceptor == null) {
                BeanManagerImpl manager = BeanManagerImpl.getManager();
                WebBeansInterceptor actualInterceptor = (WebBeansInterceptor)this.webBeansInterceptor;
                CreationalContext creationalContext = manager.createCreationalContext(actualInterceptor);
                interceptor = manager.getReference(actualInterceptor, actualInterceptor.getBeanClass(), creationalContext);
                actualInterceptor.setInjections(interceptor, creationalContext);
                ownerCreationalContext.addDependent(ownerInstance, (WebBeansInterceptor)this.webBeansInterceptor, interceptor);
            }
            return interceptor;
        }
        EjbInterceptorContext ctx = null;
        Object interceptor = null;
        if (this.definedInInterceptorClass) {
            ctx = ownerCreationalContext.getEjbInterceptor(ownerInstance, this.interceptorClass);
            if (ctx == null) {
                interceptor = WebBeansUtil.newInstanceForced(this.interceptorClass);
                try {
                    OWBInjector injector = new OWBInjector();
                    injector.inject(interceptor);
                    ctx = new EjbInterceptorContext();
                    ctx.setInjectorInstance(injector);
                    ctx.setInterceptorInstance(interceptor);
                }
                catch (Exception e) {
                    this.logger.error("ERROR_0022", e, this.interceptorClass);
                }
                ownerCreationalContext.addEjbInterceptor(this.interceptorClass, ctx);
            } else {
                interceptor = ctx.getInterceptorInstance();
            }
        }
        return interceptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Class: [").append(this.webBeansInterceptor.getBeanClass()).append("]");
        sb.append(" aroundInvoke [").append(this.aroundInvoke).append("]");
        sb.append(" postConstruct [").append(this.postConstruct).append("]");
        sb.append(" preDestroy [").append(this.preDestroy).append("]");
        return sb.toString();
    }
}

