/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import org.apache.webbeans.util.ClassUtil;

abstract class AbstractAnnotated
implements Annotated {
    private final Type baseType;
    private Set<Type> typeClosures = new HashSet<Type>();
    private Set<Annotation> annotations = new HashSet<Annotation>();

    protected AbstractAnnotated(Type baseType) {
        this.baseType = baseType;
        this.typeClosures.add((Type)((Object)Object.class));
        ClassUtil.setTypeHierarchy(this.typeClosures, this.baseType);
    }

    protected void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    protected void setAnnotations(Annotation[] annotations) {
        this.annotations.clear();
        for (Annotation annotation : annotations) {
            this.annotations.add(annotation);
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return (T)ann;
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Set<Type> getTypeClosure() {
        return this.typeClosures;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Base Type : " + this.baseType.toString() + ",");
        builder.append("Type Closures : " + this.typeClosures.toString() + ",");
        builder.append("Annotations : " + this.annotations.toString());
        return builder.toString();
    }
}

