/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class OWBInjector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CreationalContextImpl<?> ownerCreationalContext = null;
    private Object javaEEInstance;

    public void destroy() {
        BeanManagerImpl beanManager = BeanManagerImpl.getManager();
        InjectionTargetWrapper<?> wrapper = beanManager.getInjectionTargetWrapper(this.javaEEInstance.getClass());
        if (wrapper != null) {
            wrapper.dispose(this.javaEEInstance);
            this.javaEEInstance = null;
            this.ownerCreationalContext = null;
        } else if (this.ownerCreationalContext != null) {
            this.ownerCreationalContext.release();
            this.ownerCreationalContext = null;
        }
    }

    public OWBInjector inject(Object javaEeComponentInstance) throws Exception {
        return this.inject(javaEeComponentInstance, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWBInjector inject(Object javaEeComponentInstance, CreationalContext<?> creationalContext) throws Exception {
        block10: {
            BeanManagerImpl beanManager = BeanManagerImpl.getManager();
            this.javaEEInstance = javaEeComponentInstance;
            if (creationalContext == null) {
                this.ownerCreationalContext = (CreationalContextImpl)beanManager.createCreationalContext(null);
            }
            Class<?> injectableComponentClass = javaEeComponentInstance.getClass();
            InjectionTarget<?> injectionTarget = null;
            InjectionTargetWrapper<?> wrapper = beanManager.getInjectionTargetWrapper(injectableComponentClass);
            if (wrapper != null) {
                wrapper.inject(javaEeComponentInstance, this.ownerCreationalContext);
                return this;
            }
            AnnotatedType<?> annotated = beanManager.createAnnotatedType(injectableComponentClass);
            injectionTarget = beanManager.createInjectionTarget(annotated);
            Set injectionPoints = injectionTarget.getInjectionPoints();
            if (injectionPoints == null || injectionPoints.size() <= 0) break block10;
            for (InjectionPoint injectionPoint : injectionPoints) {
                boolean injectionPointBeanSet = false;
                try {
                    Bean<?> injectedBean;
                    if (injectionPoint.getMember() instanceof Field && WebBeansUtil.isDependent(injectedBean = InjectionResolver.getInstance().getInjectionPointBean(injectionPoint)) && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(injectionPoint.getType()))) {
                        injectionPointBeanSet = true;
                        InjectionPointBean.local.set(injectionPoint);
                    }
                    Object object = beanManager.getInjectableReference(injectionPoint, this.ownerCreationalContext);
                    if (injectionPoint.getMember() instanceof Method) {
                        Method method = (Method)injectionPoint.getMember();
                        ClassUtil.callInstanceMethod(method, javaEeComponentInstance, new Object[]{object});
                        continue;
                    }
                    if (!(injectionPoint.getMember() instanceof Field)) continue;
                    Field field = (Field)injectionPoint.getMember();
                    ClassUtil.setField(javaEeComponentInstance, field, object);
                }
                finally {
                    if (!injectionPointBeanSet) continue;
                    InjectionPointBean.local.remove();
                }
            }
            return this;
        }
        return null;
    }

    public static void checkInjectionPointForInjectInjectionPoint(Class<?> clazz) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        for (Field field : fields = SecurityUtil.doPrivilegedGetDeclaredFields(clazz)) {
            Annotation[] anns;
            if (field.getAnnotation(Inject.class) == null || field.getType() != InjectionPoint.class || !AnnotationUtil.hasAnnotation(anns = AnnotationUtil.getQualifierAnnotations(field.getDeclaredAnnotations()), Default.class)) continue;
            throw new WebBeansConfigurationException("Java EE Component class :  " + clazz + " can not inject InjectionPoint");
        }
    }

    public static boolean checkInjectionPointForInterceptorPassivation(Class<?> clazz) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        for (Field field : fields = SecurityUtil.doPrivilegedGetDeclaredFields(clazz)) {
            Class<?> type;
            if (field.getAnnotation(Inject.class) == null || Serializable.class.isAssignableFrom(type = field.getType())) continue;
            return false;
        }
        return true;
    }
}

