/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.context.creational.EjbInterceptorContext;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Object, List<DependentCreationalContext<?>>> dependentObjects = Collections.synchronizedMap(new WeakHashMap());
    private volatile Contextual<T> contextual = null;
    private ConcurrentMap<Object, List<EjbInterceptorContext>> ejbInterceptors = new ConcurrentHashMap<Object, List<EjbInterceptorContext>>();
    public static ThreadLocal<Object> currentRemoveObject = new ThreadLocal();

    CreationalContextImpl(Contextual<T> contextual) {
        this.contextual = contextual;
    }

    public void addEjbInterceptor(Object ownerInstance, EjbInterceptorContext instance) {
        List oldList;
        Asserts.assertNotNull(ownerInstance, "Owner instance parameter can not be null");
        Asserts.assertNotNull(instance, "Instance parameter can not be null");
        List<EjbInterceptorContext> list = (ArrayList<EjbInterceptorContext>)this.ejbInterceptors.get(ownerInstance);
        if (list == null && (oldList = (List)this.ejbInterceptors.putIfAbsent(ownerInstance, list = new ArrayList<EjbInterceptorContext>())) != null) {
            list = oldList;
        }
        list.add(instance);
    }

    public EjbInterceptorContext getEjbInterceptor(Object ownerInstance, Class<?> clazz) {
        Asserts.assertNotNull(ownerInstance, "Owner instance can not be null");
        List ejbInterceptors = (List)this.ejbInterceptors.get(ownerInstance);
        if (ejbInterceptors != null) {
            for (EjbInterceptorContext ejbInterceptor : ejbInterceptors) {
                if (ejbInterceptor.getInterceptorClass() != clazz) continue;
                return ejbInterceptor;
            }
        }
        return null;
    }

    public void push(T incompleteInstance) {
    }

    public <K> void addDependent(Object ownerInstance, Contextual<K> dependent, Object instance) {
        Asserts.assertNotNull(dependent, "ownerInstance parameter cannot be null");
        Asserts.assertNotNull(dependent, "dependent parameter cannot be null");
        Asserts.assertNotNull(dependent, "instance parameter cannot be null");
        Asserts.assertNotNull(dependent, "cc parameter cannot be null");
        if (instance != null) {
            DependentCreationalContext<K> dependentCreational = new DependentCreationalContext<K>(dependent);
            if (dependent instanceof Interceptor) {
                dependentCreational.setDependentType(DependentCreationalContext.DependentType.INTERCEPTOR);
            } else if (dependent instanceof Decorator) {
                dependentCreational.setDependentType(DependentCreationalContext.DependentType.DECORATOR);
            } else {
                dependentCreational.setDependentType(DependentCreationalContext.DependentType.BEAN);
            }
            dependentCreational.setInstance(instance);
            List<DependentCreationalContext<?>> dependentList = this.dependentObjects.get(ownerInstance);
            if (dependentList == null) {
                dependentList = new ArrayList();
                this.dependentObjects.put(ownerInstance, dependentList);
            }
            dependentList.add(dependentCreational);
        }
    }

    public Object getDependentInterceptor(Object ownerInstance, Contextual<?> interceptor) {
        Asserts.assertNotNull(interceptor, "Interceptor parameter can not be null");
        if (ownerInstance != null) {
            List<DependentCreationalContext<?>> dcs = this.getDependentInterceptors(ownerInstance);
            for (DependentCreationalContext<?> dc : dcs) {
                if (!dc.getContextual().equals(interceptor)) continue;
                return dc.getInstance();
            }
        }
        return null;
    }

    public Object getDependentDecorator(Contextual<?> decorator) {
        Asserts.assertNotNull(decorator, "Decorator parameter can not be null");
        List<DependentCreationalContext<?>> dcs = this.getDependentDecorators();
        for (DependentCreationalContext<?> dc : dcs) {
            if (!dc.getContextual().equals(decorator)) continue;
            return dc.getInstance();
        }
        return null;
    }

    private List<DependentCreationalContext<?>> getDependentInterceptors(Object ownerInstance) {
        List<DependentCreationalContext<?>> values;
        ArrayList list = new ArrayList();
        if (ownerInstance != null && (values = this.dependentObjects.get(ownerInstance)) != null && values.size() > 0) {
            for (DependentCreationalContext<?> dc : values) {
                if (!dc.getDependentType().equals((Object)DependentCreationalContext.DependentType.INTERCEPTOR)) continue;
                list.add(dc);
            }
        }
        return list;
    }

    private List<DependentCreationalContext<?>> getDependentDecorators() {
        ArrayList list = new ArrayList();
        ArrayList values = new ArrayList();
        if (values != null && values.size() > 0) {
            for (DependentCreationalContext dc : values) {
                if (!dc.getDependentType().equals((Object)DependentCreationalContext.DependentType.DECORATOR)) continue;
                list.add(dc);
            }
        }
        return list;
    }

    public void removeDependents(Object ownerInstance) {
        List interceptors;
        if (ownerInstance == null) {
            return;
        }
        List<DependentCreationalContext<?>> values = this.dependentObjects.get(ownerInstance);
        if (values != null) {
            for (DependentCreationalContext<?> dependent : values) {
                dependent.getContextual().destroy(dependent.getInstance(), CreationalContextFactory.getInstance().getCreationalContext(dependent.getContextual()));
            }
            this.dependentObjects.remove(ownerInstance);
        }
        if ((interceptors = (List)this.ejbInterceptors.get(ownerInstance)) != null) {
            for (EjbInterceptorContext intereptor : interceptors) {
                intereptor.getInjectorInstance().destroy();
            }
        }
        this.ejbInterceptors.remove(ownerInstance);
    }

    public void removeAllDependents() {
        Collection<List<DependentCreationalContext<?>>> values = this.dependentObjects.values();
        if (values != null) {
            for (List<DependentCreationalContext<?>> value : values) {
                if (values == null) continue;
                for (DependentCreationalContext<?> dependent : value) {
                    dependent.getContextual().destroy(dependent.getInstance(), CreationalContextFactory.getInstance().getCreationalContext(dependent.getContextual()));
                }
            }
        }
        this.dependentObjects.clear();
        Collection interceptorValues = this.ejbInterceptors.values();
        if (interceptorValues != null) {
            for (List interceptors : interceptorValues) {
                if (interceptors == null) continue;
                for (EjbInterceptorContext intereptor : interceptors) {
                    intereptor.getInjectorInstance().destroy();
                }
            }
        }
        this.ejbInterceptors.clear();
    }

    public void release() {
        if (currentRemoveObject.get() == null) {
            this.removeAllDependents();
        } else {
            this.removeDependents(currentRemoveObject.get());
        }
    }

    public Contextual<T> getBean() {
        return this.contextual;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        HashMap depo = new HashMap(this.dependentObjects);
        s.writeObject(depo);
        String id = WebBeansUtil.isPassivationCapable(this.contextual);
        if (this.contextual != null && id != null) {
            s.writeObject(id);
        } else {
            s.writeObject(null);
        }
        s.writeObject(this.ejbInterceptors);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        HashMap depo = (HashMap)s.readObject();
        this.dependentObjects = new WeakHashMap(depo);
        String id = (String)s.readObject();
        if (id != null) {
            this.contextual = BeanManagerImpl.getManager().getPassivationCapableBean(id);
        }
        this.ejbInterceptors = (ConcurrentMap)s.readObject();
    }
}

