/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.IBeanHasParent;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerFieldBean<T>
extends AbstractProducerBean<T>
implements IBeanHasParent<T> {
    private Field producerField;

    public ProducerFieldBean(InjectionTargetBean<?> ownerComponent, Class<T> returnType) {
        super(WebBeansType.PRODUCERFIELD, returnType, ownerComponent);
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        T instance = null;
        instance = this.createDefaultInstance(creationalContext);
        this.checkNullInstance(instance);
        this.checkScopeType();
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected T createDefaultInstance(CreationalContext<T> creationalContext) {
        Object instance = null;
        Object parentInstance = null;
        CreationalContext parentCreational = null;
        try {
            parentCreational = this.getManager().createCreationalContext(this.ownerComponent);
            if (!this.producerField.isAccessible()) {
                SecurityUtil.doPrivilegedSetAccessible(this.producerField, true);
            }
            if (Modifier.isStatic(this.producerField.getModifiers())) {
                instance = this.producerField.get(null);
            } else {
                parentInstance = this.getParentInstanceFromContext(parentCreational);
                instance = this.producerField.get(parentInstance);
            }
            if (!this.ownerComponent.getScope().equals(Dependent.class)) return (T)instance;
        }
        catch (Exception e) {
            try {
                throw new WebBeansException(e);
            }
            catch (Throwable throwable) {
                if (!this.ownerComponent.getScope().equals(Dependent.class)) throw throwable;
                this.destroyBean(this.ownerComponent, parentInstance, parentCreational);
                throw throwable;
            }
        }
        this.destroyBean(this.ownerComponent, parentInstance, parentCreational);
        return (T)instance;
    }

    public Field getCreatorField() {
        return this.producerField;
    }

    public Type[] getActualTypeArguments() {
        Type type = this.producerField.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return pType.getActualTypeArguments();
        }
        return new Type[0];
    }

    public void setProducerField(Field field) {
        this.producerField = field;
    }

    protected void checkNullInstance(Object instance) {
        String errorMessage = "WebBeans producer field : " + this.producerField.getName() + " return type in the component implementation class : " + this.ownerComponent.getReturnType().getName() + " scope must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage);
    }

    protected void checkScopeType() {
        String errorMessage = "WebBeans producer method : " + this.producerField.getName() + " return type in the component implementation class : " + this.ownerComponent.getReturnType().getName() + " with passivating scope @" + this.getScope().getName() + " must be Serializable";
        WebBeansUtil.checkSerializableScopeType(this.getScope(), this.isSerializable(), errorMessage);
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable(this.producerField.getType(), this.producerField.getModifiers());
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

