/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.component.xml.XMLProducerBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.exception.definition.NonexistentTypeException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.xml.WebBeansErrorHandler;
import org.apache.webbeans.xml.WebBeansNameSpaceContainer;
import org.apache.webbeans.xml.WebBeansResolver;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public final class XMLUtil {
    private static WebBeansLogger log = WebBeansLogger.getLogger(XMLUtil.class);

    private XMLUtil() {
    }

    public static SAXReader getSaxReader() {
        return new SAXReader();
    }

    public static Element getRootElement(InputStream stream) throws WebBeansException {
        try {
            SAXReader saxReader = XMLUtil.getSaxReader();
            saxReader.setMergeAdjacentText(true);
            saxReader.setStripWhitespaceText(true);
            saxReader.setErrorHandler((ErrorHandler)new WebBeansErrorHandler());
            saxReader.setEntityResolver((EntityResolver)new WebBeansResolver());
            saxReader.setValidation(false);
            saxReader.setDefaultHandler(new ElementHandler(){

                public void onEnd(ElementPath path) {
                }

                public void onStart(ElementPath path) {
                    Element element = path.getCurrent();
                    if (element.getNamespaceURI() == null || element.getNamespaceURI().equals("")) {
                        throw new WebBeansConfigurationException(log.getTokenString("EXCEPT_0012"));
                    }
                    if (element.isRootElement()) {
                        WebBeansNameSpaceContainer.getInstance().addNewPackageNameSpace(element.getNamespace().getURI());
                        List allNs = element.declaredNamespaces();
                        for (Namespace namespace : allNs) {
                            WebBeansNameSpaceContainer.getInstance().addNewPackageNameSpace(namespace.getURI());
                        }
                    }
                }
            });
            Document document = saxReader.read(stream);
            return document.getRootElement();
        }
        catch (DocumentException e) {
            log.fatal("FATAL_0002", e);
            throw new WebBeansException(log.getTokenString("EXCEPT_0013"), e);
        }
    }

    public static Element getSpecStrictRootElement(InputStream stream) throws WebBeansException {
        try {
            SAXReader saxReader = XMLUtil.getSaxReader();
            saxReader.setMergeAdjacentText(true);
            saxReader.setStripWhitespaceText(true);
            saxReader.setErrorHandler((ErrorHandler)new WebBeansErrorHandler());
            saxReader.setEntityResolver((EntityResolver)new WebBeansResolver());
            saxReader.setValidation(false);
            Document document = saxReader.read(stream);
            return document.getRootElement();
        }
        catch (DocumentException e) {
            log.fatal("FATAL_0002", e);
            throw new WebBeansException(log.getTokenString("EXCEPT_0013"), e);
        }
    }

    public static boolean isElementInNamespace(Element element, String namespace) {
        Asserts.assertNotNull(element, "element parameter can not be null");
        Asserts.assertNotNull(namespace, "namespace parameter can not be null");
        Namespace ns = element.getNamespace();
        return !Namespace.NO_NAMESPACE.equals((Object)ns) && ns.getURI().equals(namespace);
    }

    public static boolean isElementInWebBeansNameSpace(Element element) {
        XMLUtil.nullCheckForElement(element);
        String ns = XMLUtil.getElementNameSpace(element);
        return ns != null && ns.equals("urn:java:ee");
    }

    public static boolean isElementInWebBeansNameSpaceWithName(Element element, String name) {
        String txtName;
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpace(element) && name.equals(txtName = element.getName());
    }

    public static String getElementNameSpace(Element element) {
        XMLUtil.nullCheckForElement(element);
        Namespace ns = element.getNamespace();
        if (!Namespace.NO_NAMESPACE.equals((Object)ns)) {
            return ns.getURI();
        }
        return null;
    }

    public static boolean isElementWebBeanDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return !XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Deploy") && !XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Interceptors") && !XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Decorators") && !XMLUtil.hasChildElement(element, "BindingType") && !XMLUtil.hasChildElement(element, "InterceptorBindingType") && !XMLUtil.hasChildElement(element, "StereoType");
    }

    public static boolean isElementBindingTypeDecleration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "BindingType");
    }

    public static boolean isElementInterceptorBindingTypeDecleration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "InterceptorBindingType");
    }

    public static boolean isElementStereoTypeDecleration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "StereoType");
    }

    public static boolean isElementDeployDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Deploy");
    }

    public static boolean isElementInterceptorsDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Interceptors");
    }

    public static boolean isElementDecoratosDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Decorators");
    }

    public static boolean isElementJMSDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementWebBeanDeclaration(element) && (XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Queue") || XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Topic"));
    }

    public static boolean isElementHasDecoratesChild(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "Decorates");
    }

    public static boolean isElementField(Element element) {
        XMLUtil.nullCheckForElement(element);
        List childs = element.elements();
        for (Element child : childs) {
            if (!(XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Inject") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Destructor") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Produces") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Disposes") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Observers") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Decorates"))) {
                Class<?> clazz = XMLUtil.getElementJavaType(child);
                if (clazz == null || !clazz.isAnnotation() || !AnnotationUtil.isInterceptorBindingAnnotation(clazz)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isElementMethod(Element element) {
        Asserts.nullCheckForDomElement(element);
        List childs = element.elements();
        for (Element child : childs) {
            if (XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Inject") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Destructor") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Produces") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Disposes") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Observers")) {
                return true;
            }
            Class<?> clazz = XMLUtil.getElementJavaType(child);
            if (clazz == null || !clazz.isAnnotation() || !AnnotationUtil.isInterceptorBindingAnnotation(clazz)) continue;
            return true;
        }
        return false;
    }

    public static String getName(Element element) {
        XMLUtil.nullCheckForElement(element);
        return element.getName();
    }

    public static Class<?> getElementJavaType(Element element) {
        String ns = XMLUtil.getElementNameSpace(element);
        List<String> packageNames = WebBeansNameSpaceContainer.getInstance().getPackageNameFromNameSpace(ns);
        Class<?> clazz = null;
        Class<?> foundClazz = null;
        if (packageNames != null) {
            boolean found = false;
            for (String packageName : packageNames) {
                String className = packageName + XMLUtil.getName(element);
                clazz = ClassUtil.getClassFromName(className);
                if (clazz == null) continue;
                if (found) {
                    throw new DefinitionException(log.getTokenString("EXCEPT_0014") + clazz.getName());
                }
                foundClazz = clazz;
                found = true;
            }
        }
        return foundClazz;
    }

    public static String getElementJavaClassName(Element element) {
        Class<?> clazz = XMLUtil.getElementJavaType(element);
        if (clazz != null) {
            return clazz.getName();
        }
        return XMLUtil.getName(element);
    }

    private static void nullCheckForElement(Element element) {
        Asserts.nullCheckForDomElement(element);
    }

    public static boolean hasChildElement(Element parent, String childName) {
        Asserts.assertNotNull(parent, "parent parameter can not be null");
        Asserts.assertNotNull(childName, "childName parameter can not be null");
        return parent.element(childName) != null;
    }

    public static boolean hasChildElementWithWebBeansNameSpace(Element parent, String childName) {
        Asserts.assertNotNull(parent, "parent parameter can not be null");
        Asserts.assertNotNull(childName, "childName parameter can not be null");
        Element child = parent.element(childName);
        if (child == null) {
            return false;
        }
        return XMLUtil.isElementInWebBeansNameSpace(child);
    }

    public static XMLInjectionPointModel getInjectionPointModel(Element typeElement, String errorMessage) {
        Asserts.assertNotNull(typeElement, "typeElement parameter can not be null");
        if (typeElement.getName().equals("Array")) {
            return XMLUtil.getArrayInjectionPointModel(typeElement, errorMessage);
        }
        return XMLUtil.getTypeInjectionPointModel(typeElement, errorMessage);
    }

    private static XMLInjectionPointModel getTypeInjectionPointModel(Element typeElement, String errorMessage) {
        XMLInjectionPointModel model = null;
        Class<?> clazz = XMLUtil.getElementJavaType(typeElement);
        if (clazz == null) {
            throw new NonexistentTypeException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is not found in the deployment");
        }
        if (clazz.isAnnotation() || clazz.isArray() || clazz.isEnum()) {
            throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
        }
        TypeVariable<Class<?>>[] typeVariables = clazz.getTypeParameters();
        int actualTypeArgument = typeVariables.length;
        List childElements = typeElement.elements();
        ArrayList typeArguments = new ArrayList();
        ArrayList<Annotation> bindingAnnots = new ArrayList<Annotation>();
        Class<?> definedBindingType = null;
        for (Element childElement : childElements) {
            Class<?> clazz2 = XMLUtil.getElementJavaType(childElement);
            if (clazz2 == null) {
                throw new NonexistentTypeException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is not found in the deployment");
            }
            if (clazz2.isArray() || clazz2.isEnum()) {
                throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
            }
            if (clazz2.isAnnotation()) {
                Class<?> annotClazz = clazz2;
                if (!AnnotationUtil.isQualifierAnnotation(annotClazz)) {
                    throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is not a @Qualifier");
                }
                if (definedBindingType == null) {
                    definedBindingType = annotClazz;
                } else if (definedBindingType.equals(annotClazz)) {
                    throw new IllegalArgumentException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is duplicated");
                }
                bindingAnnots.add(XMLUtil.getXMLDefinedAnnotationMember(childElement, annotClazz, errorMessage));
                continue;
            }
            typeArguments.add(clazz2);
        }
        if (actualTypeArgument != typeArguments.size()) {
            throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " actual type parameters size are not equals defined in the xml");
        }
        int i = 0;
        for (Type type : typeArguments) {
            TypeVariable<Class<?>> typeVariable = typeVariables[i];
            Type[] bounds = typeVariable.getBounds();
            Class clazzBound = (Class)bounds[0];
            if (clazzBound.isAssignableFrom((Class)type)) continue;
            throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " actual type parameter bounded exception");
        }
        Type[] typeArray = new Type[typeArguments.size()];
        typeArray = typeArguments.toArray(typeArray);
        model = new XMLInjectionPointModel(clazz, typeArray);
        if (bindingAnnots.isEmpty()) {
            model.addBindingType((Annotation)((Object)new DefaultLiteral()));
        }
        for (Annotation annot : bindingAnnots) {
            model.addBindingType(annot);
        }
        return model;
    }

    public static Annotation getXMLDefinedAnnotationMember(Element annotationElement, Class<? extends Annotation> annotClazz, String errorMessage) {
        Method[] members;
        String value = annotationElement.getTextTrim();
        List attrs = annotationElement.attributes();
        ArrayList<String> attrsNames = new ArrayList<String>();
        for (Attribute attr : attrs) {
            attrsNames.add(attr.getName());
        }
        if (value != null && !value.equals("")) {
            if (attrsNames.contains("value")) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " can not have both element 'value' attribute and body text");
            }
        } else if (attrsNames.contains("value")) {
            try {
                annotClazz.getDeclaredMethod("value", new Class[0]);
            }
            catch (SecurityException e) {
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " must have 'value' method");
            }
        }
        for (String attrName : attrsNames) {
            try {
                annotClazz.getDeclaredMethod(attrName, new Class[0]);
            }
            catch (SecurityException e) {
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " does not have member with name : " + attrName);
            }
        }
        for (Method member : members = annotClazz.getDeclaredMethods()) {
            if (member.getDefaultValue() != null || value != null || attrsNames.contains(member.getName())) continue;
            throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " with non-default member method with name : " + member.getName() + " has to defined in the xml element attribute.");
        }
        return XMLUtil.createInjectionPointAnnotation(attrs, annotClazz, value, errorMessage);
    }

    private static WebBeansAnnotation createInjectionPointAnnotation(List<Attribute> attrs, Class<? extends Annotation> annotClazz, String valueText, String errorMessage) {
        WebBeansAnnotation annotation = JavassistProxyFactory.createNewAnnotationProxy(annotClazz);
        boolean isValueAttrDefined = false;
        for (Attribute attr : attrs) {
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (!isValueAttrDefined && attrName.equals("value")) {
                isValueAttrDefined = true;
            }
            Class<?> returnType = null;
            try {
                returnType = annotClazz.getDeclaredMethod(attrName, new Class[0]).getReturnType();
                Object value = null;
                if (returnType.isPrimitive()) {
                    value = ClassUtil.isValueOkForPrimitiveOrWrapper(returnType, attrValue);
                } else if (returnType.equals(String.class)) {
                    value = attrValue;
                } else if (returnType.equals(Class.class)) {
                    value = ClassUtil.getClassFromName(attrValue);
                } else if (returnType.isEnum()) {
                    value = ClassUtil.isValueOkForEnum(returnType, attrValue);
                } else {
                    throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " with member : " + attrName + " does not have sutiable member return type");
                }
                if (value == null) {
                    throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " with member : " + attrName + " value does not defined correctly");
                }
                annotation.setMemberValue(attrName, value);
            }
            catch (SecurityException e) {
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " does not have member with name : " + attrName);
            }
        }
        if (!isValueAttrDefined && valueText != null && !valueText.equals("")) {
            annotation.setMemberValue("value", valueText);
        }
        return annotation;
    }

    public static XMLInjectionPointModel getArrayInjectionPointModel(Element typeElement, String errorMessage) {
        XMLInjectionPointModel model = null;
        List childElements = typeElement.elements();
        boolean isElementTypeDefined = false;
        HashSet<Annotation> anns = new HashSet<Annotation>();
        for (Element childElement : childElements) {
            Class<?> clazz = XMLUtil.getElementJavaType(childElement);
            if (clazz == null) {
                throw new NonexistentTypeException(errorMessage + "Class with name : " + XMLUtil.getElementJavaClassName(childElement) + " is not found for Array element type");
            }
            if (clazz.isAnnotation()) {
                anns.add(XMLUtil.getXMLDefinedAnnotationMember(childElement, clazz, errorMessage));
                continue;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element child with Java type : " + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
            }
            if (isElementTypeDefined) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element can not have more than one child element. It has one child element that declares its type");
            }
            model = new XMLInjectionPointModel(clazz);
            isElementTypeDefined = true;
        }
        if (anns.size() == 0) {
            model.addBindingType((Annotation)((Object)new DefaultLiteral()));
        }
        for (Annotation ann : anns) {
            model.addBindingType(ann);
        }
        return model;
    }

    public static <T> void defineXMLProducerApiTypeFromArrayElement(XMLProducerBean<T> component, Element typeElement, String errorMessage) {
        List childElements = typeElement.elements();
        boolean isElementTypeDefined = false;
        HashSet<Annotation> anns = new HashSet<Annotation>();
        for (Element childElement : childElements) {
            Class<?> clazz = XMLUtil.getElementJavaType(childElement);
            if (clazz == null) {
                throw new NonexistentTypeException(errorMessage + "Class with name : " + XMLUtil.getElementJavaClassName(childElement) + " is not found for Array element type");
            }
            if (clazz.isAnnotation()) {
                anns.add(XMLUtil.getXMLDefinedAnnotationMember(childElement, clazz, errorMessage));
                continue;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element child with Java type : " + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
            }
            if (isElementTypeDefined) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element can not have more than one child element. It has one child element that declares its type");
            }
            isElementTypeDefined = true;
            component.addApiType(Array.newInstance(clazz, 0).getClass());
        }
        if (anns.size() == 0) {
            component.addQualifier((Annotation)((Object)new DefaultLiteral()));
        }
        for (Annotation ann : anns) {
            component.addQualifier(ann);
        }
    }
}

