/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.deployment.XMLStereoTypeModel;
import org.apache.webbeans.util.WebBeansUtil;
import org.dom4j.Element;

public class XMLAnnotationTypeManager {
    private Set<Class<? extends Annotation>> xmlBindingTypes = new CopyOnWriteArraySet<Class<? extends Annotation>>();
    private Set<Class<? extends Annotation>> xmlResources = new CopyOnWriteArraySet<Class<? extends Annotation>>();
    private Map<Class<? extends Annotation>, Set<Annotation>> xmlInterceptorBindingTypes = new ConcurrentHashMap<Class<? extends Annotation>, Set<Annotation>>();
    private Set<Class<? extends Annotation>> xmlStereoTypes = new CopyOnWriteArraySet<Class<? extends Annotation>>();

    public static XMLAnnotationTypeManager getInstance() {
        XMLAnnotationTypeManager manager = (XMLAnnotationTypeManager)WebBeansFinder.getSingletonInstance(WebBeansFinder.SINGLETON_XML_ANNOTATION_TYPE_MANAGER);
        return manager;
    }

    public void addBindingType(Class<? extends Annotation> bindingType) {
        this.xmlBindingTypes.add(bindingType);
    }

    public void addResource(Class<? extends Annotation> resource) {
        this.xmlResources.add(resource);
    }

    public boolean hasBindingType(Class<? extends Annotation> bindingType) {
        return this.xmlBindingTypes.contains(bindingType);
    }

    public boolean hasResource(Class<? extends Annotation> resource) {
        return this.xmlResources.contains(resource);
    }

    public void addStereoType(Class<? extends Annotation> stereoType, Element decleration, String name, String errorMessage) {
        WebBeansUtil.checkStereoTypeClass(stereoType);
        StereoTypeManager manager = StereoTypeManager.getInstance();
        XMLStereoTypeModel model = new XMLStereoTypeModel(decleration, name, errorMessage);
        manager.addStereoTypeModel(model);
        this.xmlStereoTypes.add(stereoType);
    }

    public boolean hasStereoType(Class<? extends Annotation> stereoType) {
        return this.xmlStereoTypes.contains(stereoType);
    }

    public void addInterceotorBindingTypeInheritAnnotation(Class<? extends Annotation> bindingType, Annotation inherit) {
        Set<Annotation> inherits = this.xmlInterceptorBindingTypes.get(bindingType);
        if (inherits == null) {
            inherits = new HashSet<Annotation>();
            inherits.add(inherit);
            this.xmlInterceptorBindingTypes.put(bindingType, inherits);
        } else {
            inherits.add(inherit);
        }
    }

    public void addInterceotorBindingTypeInheritAnnotation(Class<? extends Annotation> bindingType, Annotation ... inheritsArray) {
        Set<Annotation> inherits = this.xmlInterceptorBindingTypes.get(bindingType);
        if (inherits == null) {
            inherits = new HashSet<Annotation>();
            for (Annotation ann : inheritsArray) {
                inherits.add(ann);
            }
            this.xmlInterceptorBindingTypes.put(bindingType, inherits);
        } else {
            for (Annotation ann : inheritsArray) {
                inherits.add(ann);
            }
        }
    }

    public boolean hasInterceptorBindingType(Class<? extends Annotation> bindingType) {
        return this.xmlInterceptorBindingTypes.keySet().contains(bindingType);
    }

    public Set<Class<? extends Annotation>> getBindingTypes() {
        return Collections.unmodifiableSet(this.xmlBindingTypes);
    }

    public Set<Class<? extends Annotation>> getResources() {
        return Collections.unmodifiableSet(this.xmlResources);
    }

    public Set<Annotation> getInterceptorBindingTypeInherites(Class<? extends Annotation> interceptorBindingType) {
        return Collections.unmodifiableSet(this.xmlInterceptorBindingTypes.get(interceptorBindingType));
    }

    public Set<Class<? extends Annotation>> getInterceptorBindingTypes() {
        return Collections.unmodifiableSet(this.xmlInterceptorBindingTypes.keySet());
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.unmodifiableSet(this.xmlStereoTypes);
    }
}

