/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.config.WebBeansFinder;

public class WebBeansNameSpaceContainer {
    private Map<String, List<String>> nameSpaceToPackages = new ConcurrentHashMap<String, List<String>>();

    public static WebBeansNameSpaceContainer getInstance() {
        WebBeansNameSpaceContainer nameSpaceContainer = (WebBeansNameSpaceContainer)WebBeansFinder.getSingletonInstance(WebBeansFinder.SINGLETON_WEBBEANS_NAMESPACE_CONTAINER);
        return nameSpaceContainer;
    }

    public void addNewPackageNameSpace(String nameSpace) {
        if (nameSpace.startsWith("urn:java:") && !nameSpace.equals("urn:java:ee")) {
            String packageName = nameSpace.substring("urn:java:".length(), nameSpace.length()) + ".";
            if (this.nameSpaceToPackages.containsKey(packageName)) {
                this.nameSpaceToPackages.get(nameSpace).add(packageName);
            } else {
                ArrayList<String> packageList = new ArrayList<String>();
                packageList.add(packageName);
                this.nameSpaceToPackages.put(nameSpace, packageList);
            }
        }
        if (nameSpace.equals("urn:java:ee") && !this.nameSpaceToPackages.containsKey(nameSpace)) {
            ArrayList<String> eePackages = new ArrayList<String>();
            eePackages.add("java.lang.");
            eePackages.add("java.util.");
            eePackages.add("javax.enterprise.context.");
            eePackages.add("javax.enterprise.context.spi.");
            eePackages.add("javax.enterprise.event.");
            eePackages.add("javax.enterprise.inject.");
            eePackages.add("org.apache.webbeans.annotation.deployment.");
            eePackages.add("javax.enterprise.inject.spi.");
            eePackages.add("javax.inject.");
            eePackages.add("javax.context.");
            eePackages.add("javax.interceptor.");
            eePackages.add("javax.decorator.");
            eePackages.add("javax.event.");
            eePackages.add("javax.ejb.");
            eePackages.add("javax.persistence.");
            eePackages.add("javax.xml.ws.");
            eePackages.add("javax.jms.");
            eePackages.add("javax.sql.");
            this.nameSpaceToPackages.put(nameSpace, eePackages);
        }
    }

    public List<String> getPackageNameFromNameSpace(String nameSpace) {
        if (this.nameSpaceToPackages.containsKey(nameSpace)) {
            return this.nameSpaceToPackages.get(nameSpace);
        }
        return null;
    }
}

