/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.spi.deployer;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.ClassUtil;
import org.scannotation.AnnotationDB;

public abstract class AbstractMetaDataDiscovery
implements ScannerService {
    private Set<URL> webBeansXmlLocations = new HashSet<URL>();
    private AnnotationDB annotationDB = null;

    protected AbstractMetaDataDiscovery() {
        try {
            if (this.annotationDB == null) {
                this.annotationDB = new AnnotationDB();
                this.annotationDB.setScanClassAnnotations(true);
                this.annotationDB.crossReferenceMetaAnnotations();
                this.annotationDB.setScanFieldAnnotations(false);
                this.annotationDB.setScanMethodAnnotations(false);
                this.annotationDB.setScanParameterAnnotations(false);
            }
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    public void scan() throws WebBeansDeploymentException {
        try {
            this.configure();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    protected abstract void configure() throws Exception;

    public void init(Object object) {
    }

    protected AnnotationDB getAnnotationDB() {
        return this.annotationDB;
    }

    protected void addWebBeansXmlLocation(URL file) {
        this.webBeansXmlLocations.add(file);
    }

    public Set<Class<?>> getBeanClasses() {
        Set strSet;
        HashSet classSet = new HashSet();
        Map index = this.annotationDB.getClassIndex();
        if (index != null && (strSet = index.keySet()) != null) {
            for (String str : strSet) {
                classSet.add(ClassUtil.getClassFromName(str));
            }
        }
        return classSet;
    }

    public Set<URL> getBeanXmls() {
        return Collections.unmodifiableSet(this.webBeansXmlLocations);
    }
}

