/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessObservableMethod;
import org.apache.webbeans.util.AnnotationUtil;

public class AfterBeanDiscoveryImpl
implements AfterBeanDiscovery {
    private BeanManagerImpl beanManager = BeanManagerImpl.getManager();

    public void addBean(Bean<?> bean) {
        GProcessBean processBeanEvent = new GProcessBean(bean, AnnotatedElementFactory.newAnnotatedType(bean.getBeanClass()));
        this.beanManager.fireEvent(processBeanEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        this.beanManager.addBean(bean);
    }

    public void addContext(Context context) {
        this.beanManager.addContext(context);
    }

    public void addDefinitionError(Throwable t) {
        this.beanManager.getErrorStack().pushError(t);
    }

    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        GProcessObservableMethod event = new GProcessObservableMethod(null, observerMethod);
        this.beanManager.fireEvent(event, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        NotificationManager.getInstance().addObserver(observerMethod, observerMethod.getObservedType());
    }
}

