/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;

public final class AnnotatedElementFactory {
    private AnnotatedElementFactory() {
    }

    public static <X> AnnotatedType<X> newAnnotatedType(Class<X> annotatedClass) {
        AnnotatedTypeImpl<X> annotatedType = new AnnotatedTypeImpl<X>(annotatedClass);
        Field[] fields = annotatedClass.getDeclaredFields();
        Method[] methods = annotatedClass.getDeclaredMethods();
        Constructor<?>[] ctxs = annotatedClass.getDeclaredConstructors();
        for (Field field : fields) {
            AnnotatedFieldImpl<X> af = new AnnotatedFieldImpl<X>(field, annotatedType);
            annotatedType.addAnnotatedField(af);
        }
        for (AccessibleObject accessibleObject : methods) {
            AnnotatedMethodImpl<X> am = new AnnotatedMethodImpl<X>((Method)accessibleObject, annotatedType);
            annotatedType.addAnnotatedMethod(am);
        }
        for (AccessibleObject accessibleObject : ctxs) {
            AnnotatedConstructorImpl<X> ac = new AnnotatedConstructorImpl<X>(accessibleObject, annotatedType);
            annotatedType.addAnnotatedConstructor(ac);
        }
        return annotatedType;
    }

    public static <X> AnnotatedConstructor<X> newAnnotatedConstructor(Constructor<X> constructor) {
        return new AnnotatedConstructorImpl<X>(constructor);
    }

    public static <X> AnnotatedField<X> newAnnotatedField(Field field, Class<X> declaringClass) {
        return new AnnotatedFieldImpl(field);
    }

    public static <X> AnnotatedMethod<X> newAnnotatedMethod(Method method, Class<X> declaringClass) {
        return new AnnotatedMethodImpl(method);
    }
}

