/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.plugins.OpenWebBeansPlugin;

public class PluginLoader {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(PluginLoader.class);
    private List<OpenWebBeansPlugin> plugins = null;
    private AtomicBoolean started = new AtomicBoolean(false);

    public static PluginLoader getInstance() {
        return (PluginLoader)WebBeansFinder.getSingletonInstance(PluginLoader.class.getName());
    }

    public void startUp() throws WebBeansConfigurationException {
        if (this.started.compareAndSet(false, true)) {
            logger.debug("PluginLoader startUp called.");
            ArrayList<OpenWebBeansPlugin> ps = new ArrayList<OpenWebBeansPlugin>();
            ServiceLoader<OpenWebBeansPlugin> owbPluginsLoader = ServiceLoader.load(OpenWebBeansPlugin.class);
            for (OpenWebBeansPlugin plugin : owbPluginsLoader) {
                logger.info("INFO_0013", new Object[]{plugin.getClass().getSimpleName()});
                plugin.startUp();
                ps.add(plugin);
            }
            this.plugins = Collections.unmodifiableList(ps);
        } else {
            logger.debug("PluginLoader is already started.");
        }
    }

    public void shutDown() throws WebBeansConfigurationException {
        if (this.started.compareAndSet(true, false)) {
            logger.debug("PluginLoader shutDown called.");
            if (this.plugins == null) {
                logger.warn("WARN_0001");
                return;
            }
            ArrayList<String> failedShutdown = new ArrayList<String>();
            for (OpenWebBeansPlugin plugin : this.plugins) {
                try {
                    plugin.shutDown();
                }
                catch (Exception e) {
                    String pluginName = plugin.getClass().getSimpleName();
                    logger.error("ERROR_0009", new Object[]{pluginName}, e);
                    failedShutdown.add(pluginName);
                }
            }
            if (!failedShutdown.isEmpty()) {
                throw new WebBeansConfigurationException(logger.getTokenString("EXCEPT_0006") + failedShutdown.toString());
            }
        } else {
            logger.debug("PluginLoader is already shut down.");
        }
    }

    public List<OpenWebBeansPlugin> getPlugins() {
        return this.plugins;
    }

    public OpenWebBeansEjbPlugin getEjbPlugin() {
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansEjbPlugin)) continue;
            return (OpenWebBeansEjbPlugin)plugin;
        }
        return null;
    }

    public OpenWebBeansJmsPlugin getJmsPlugin() {
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansJmsPlugin)) continue;
            return (OpenWebBeansJmsPlugin)plugin;
        }
        return null;
    }

    public boolean isShowDown() {
        return !this.started.get();
    }
}

