/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle;

import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.ServiceLoader;
import org.apache.webbeans.spi.se.deployer.MetaDataDiscoveryStandard;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class StandaloneLifeCycle
implements ContainerLifecycle {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(StandaloneLifeCycle.class);
    private final BeansDeployer beansDeployer;
    protected final BeanManagerImpl beanManager;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    protected ScannerService discoveryService = null;
    protected final WebBeansXMLConfigurator xmlConfig;

    public StandaloneLifeCycle() {
        WebBeansFinder.clearInstances();
        this.beanManager = BeanManagerImpl.getManager();
        this.xmlConfig = new WebBeansXMLConfigurator();
        this.beansDeployer = new BeansDeployer(this.xmlConfig);
        this.init();
    }

    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.discoveryService = ServiceLoader.getService(ScannerService.class);
            if (this.discoveryService == null) {
                logger.warn("WARN_0003");
                this.discoveryService = new MetaDataDiscoveryStandard();
            } else {
                logger.info("INFO_0001", new Object[]{this.discoveryService.getClass().toString()});
            }
            this.beanManager.setXMLConfigurator(this.xmlConfig);
        }
    }

    public void applicationStarted(Object startupObject) throws WebBeansException {
        if (this.started.compareAndSet(false, true)) {
            logger.debug("OpenWebBeans Container is starting.");
            long begin = System.currentTimeMillis();
            ContextFactory.initSingletonContext(null);
            PluginLoader.getInstance().startUp();
            logger.debug("Scanning classpaths for beans artifacts.");
            this.discoveryService.scan();
            logger.debug("Deploying scanned beans.");
            this.beansDeployer.deploy(this.discoveryService);
            long end = System.currentTimeMillis();
            logger.info("INFO_0002", new Object[]{Long.toString(end - begin)});
        } else {
            logger.warn("WARN_0004");
        }
    }

    public void applicationEnded(Object endObject) {
        if (this.stopped.compareAndSet(false, true)) {
            logger.debug("OpenWebBeans Container is stopping.");
            this.beanManager.fireEvent(new BeforeShutdownImpl(), new Annotation[0]);
            JNDIService jndiService = ServiceLoader.getService(JNDIService.class);
            jndiService.unbind("java:comp/BeanManager");
            ContextFactory.destroySingletonContext(null);
            PluginLoader.getInstance().shutDown();
            ExtensionLoader.getInstance().clear();
            WebBeansFinder.clearInstances();
            logger.debug("OpenWebBeans Container has stopped.");
        } else {
            logger.warn("WARN_0005");
        }
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public ScannerService getDiscoveryService() {
        return this.discoveryService;
    }

    public void init(Properties properties) {
    }

    public void start(Object startupObject) throws Exception {
        this.applicationStarted(startupObject);
    }

    public void stop(Object endObject) {
        this.applicationEnded(endObject);
    }
}

