/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.util.ClassUtil;

public class InvocationContextImpl
implements InvocationContext {
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private Method method;
    private Object[] parameters;
    private List<InterceptorData> interceptorDatas;
    private Object target;
    private InterceptorType type;
    private int currentMethod = 1;
    private CreationalContext<?> creationalContext;

    public InvocationContextImpl(OwbBean<?> bean, Object instance, Method method, Object[] parameters, List<InterceptorData> datas, InterceptorType type) {
        this.method = method;
        this.parameters = parameters;
        this.interceptorDatas = datas;
        this.type = type;
        if (instance == null) {
            this.configureTarget(bean);
        } else {
            this.target = instance;
        }
    }

    public void setCreationalContext(CreationalContext<?> creationalContext) {
        this.creationalContext = creationalContext;
    }

    private void configureTarget(OwbBean<?> bean) {
        Context webbeansContext = BeanManagerImpl.getManager().getContext(bean.getScope());
        this.target = webbeansContext.get(bean, this.creationalContext);
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object proceed() throws Exception {
        try {
            if (this.type.equals((Object)InterceptorType.AROUND_INVOKE)) {
                return this.proceedAroundInvokes(this.interceptorDatas);
            }
            return this.proceedCommonAnnots(this.interceptorDatas, this.type);
        }
        catch (InvocationTargetException ite) {
            this.target = null;
            Throwable t = ite.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw ite;
        }
        catch (Exception e) {
            this.target = null;
            throw e;
        }
    }

    private Object proceedAroundInvokes(List<InterceptorData> datas) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            Object t;
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method method = intc.getAroundInvoke();
            boolean accessible = method.isAccessible();
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if ((t = intc.getInterceptorInstance()) == null) {
                t = this.target;
            }
            ++this.currentMethod;
            result = method.invoke(t, this);
            if (!accessible) {
                method.setAccessible(false);
            }
        } else {
            boolean accessible = this.method.isAccessible();
            if (!accessible) {
                this.method.setAccessible(true);
            }
            result = this.method.invoke(this.target, this.parameters);
            if (!accessible) {
                this.method.setAccessible(false);
            }
        }
        return result;
    }

    private Object proceedCommonAnnots(List<InterceptorData> datas, InterceptorType type) throws Exception {
        Object result = null;
        if (this.currentMethod <= datas.size()) {
            InterceptorData intc = datas.get(this.currentMethod - 1);
            Method method = null;
            if (type.equals((Object)InterceptorType.POST_CONSTRUCT)) {
                method = intc.getPostConstruct();
            } else if (type.equals((Object)InterceptorType.PRE_DESTROY)) {
                method = intc.getPreDestroy();
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            ++this.currentMethod;
            Object t = intc.getInterceptorInstance();
            if (t == null) {
                t = this.target;
                result = method.invoke(t, new Object[0]);
                this.proceedCommonAnnots(datas, type);
            } else {
                result = method.invoke(t, this);
            }
        }
        return result;
    }

    public void setParameters(Object[] params) {
        if (this.getMethod() != null) {
            if (params == null) {
                if (this.parameters.length >= 0) {
                    throw new IllegalArgumentException("Gvien parameters is null but expected not null parameters");
                }
            } else {
                if (params.length != this.parameters.length) {
                    throw new IllegalArgumentException("Expected " + this.parameters.length + " " + "parameters, but only got " + params.length + " parameters");
                }
                Class<?>[] methodParameters = this.method.getParameterTypes();
                int i = 0;
                for (Object obj : params) {
                    Class<?> parameterType = methodParameters[i++];
                    if (obj == null) {
                        if (!parameterType.isPrimitive()) continue;
                        throw new IllegalArgumentException("Expected parameter " + i + " to be primitive type " + parameterType.getName() + ", but got a parameter that is null");
                    }
                    if (parameterType.isPrimitive()) {
                        parameterType = ClassUtil.getPrimitiveWrapper(parameterType);
                    }
                    if (parameterType.isInstance(obj)) continue;
                    throw new IllegalArgumentException("Expected parameter " + i + " to be of type " + parameterType.getName() + ", but got a parameter of type " + obj.getClass().getName());
                }
                System.arraycopy(params, 0, this.parameters, 0, params.length);
            }
        }
    }

    public Object getTimer() {
        return null;
    }
}

