/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InterceptionType;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public final class InterceptorUtil {
    private InterceptorUtil() {
    }

    public static boolean isWebBeansBusinessMethod(Method method) {
        Asserts.nullCheckForMethod(method);
        int modifiers = method.getModifiers();
        if (ClassUtil.isStatic(modifiers) || ClassUtil.isPrivate(modifiers) || ClassUtil.isFinal(modifiers)) {
            return false;
        }
        if (AnnotationUtil.hasMethodAnnotation(method, Inject.class)) {
            return false;
        }
        if (AnnotationUtil.hasMethodAnnotation(method, PreDestroy.class) || AnnotationUtil.hasMethodAnnotation(method, PostConstruct.class) || AnnotationUtil.hasMethodAnnotation(method, AroundInvoke.class)) {
            return false;
        }
        if (AnnotationUtil.hasMethodAnnotation(method, Produces.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Disposes.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) {
            return true;
        }
        return true;
    }

    public static Class<? extends Annotation> getInterceptorAnnotationClazz(InterceptionType type) {
        if (type.equals((Object)InterceptionType.AROUND_INVOKE)) {
            return AroundInvoke.class;
        }
        if (type.equals((Object)InterceptionType.POST_CONSTRUCT)) {
            return PostConstruct.class;
        }
        if (type.equals((Object)InterceptionType.PRE_DESTROY)) {
            return PreDestroy.class;
        }
        throw new WebBeansException("Undefined interceotion type");
    }

    public static <T> boolean isBusinessMethodInterceptor(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(AroundInvoke.class) || methodA.getParameters().isEmpty()) continue;
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[0]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method.getJavaMember()).equals(Object.class) || ClassUtil.isMethodHasCheckedException(method.getJavaMember()) || ClassUtil.isStatic(method.getJavaMember().getModifiers()) || ClassUtil.isFinal(method.getJavaMember().getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBusinessMethodInterceptor(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class<?>[] params;
            if (!AnnotationUtil.hasMethodAnnotation(method, AroundInvoke.class) || !ClassUtil.isMethodHasParameter(method) || (params = ClassUtil.getMethodParameterTypes(method)).length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method).equals(Object.class) || !ClassUtil.isMethodHasException(method) || ClassUtil.isStatic(method.getModifiers()) || ClassUtil.isFinal(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isLifecycleMethodInterceptor(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class<?>[] params;
            if (!AnnotationUtil.hasMethodAnnotation(method, PostConstruct.class) && !AnnotationUtil.hasMethodAnnotation(method, PreDestroy.class) || !ClassUtil.isMethodHasParameter(method) || (params = ClassUtil.getMethodParameterTypes(method)).length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method).equals(Void.TYPE) || ClassUtil.isMethodHasCheckedException(method) || ClassUtil.isStatic(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isLifecycleMethodInterceptor(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(PostConstruct.class) && !method.isAnnotationPresent(PreDestroy.class) || methodA.getParameters().isEmpty()) continue;
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[0]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method.getJavaMember()).equals(Void.TYPE) || ClassUtil.isMethodHasCheckedException(method.getJavaMember()) || ClassUtil.isStatic(method.getJavaMember().getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static <T> void checkAnnotatedTypeInterceptorConditions(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            if (!methodA.isAnnotationPresent(Produces.class)) continue;
            throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass().getName() + " can not have producer methods but it has one with name : " + methodA.getJavaMember().getName());
        }
        Annotation[] anns = annotatedType.getAnnotations().toArray(new Annotation[0]);
        if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(anns)) {
            throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass().getName() + " must have at least one @InterceptorBinding annotation");
        }
        InterceptorUtil.checkLifecycleConditions(annotatedType, anns, "Lifecycle interceptor : " + annotatedType.getJavaClass().getName() + " interceptor binding type must be defined as @Target{TYPE}");
    }

    public static void checkInterceptorConditions(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!AnnotationUtil.hasMethodAnnotation(method, Produces.class)) continue;
            throw new WebBeansConfigurationException("Interceptor class : " + clazz + " can not have producer methods but it has one with name : " + method.getName());
        }
        if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(clazz.getDeclaredAnnotations())) {
            throw new WebBeansConfigurationException("WebBeans Interceptor class : " + clazz.getName() + " must have at least one @InterceptorBinding annotation");
        }
        InterceptorUtil.checkLifecycleConditions(clazz, clazz.getDeclaredAnnotations(), "Lifecycle interceptor : " + clazz.getName() + " interceptor binding type must be defined as @Target{TYPE}");
    }

    public static <T> void checkLifecycleConditions(Class<T> clazz, Annotation[] annots, String errorMessage) {
        Asserts.nullCheckForClass(clazz);
        if (InterceptorUtil.isLifecycleMethodInterceptor(clazz) && !InterceptorUtil.isBusinessMethodInterceptor(clazz)) {
            Annotation[] anns;
            for (Annotation annotation : anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(annots)) {
                Target target = annotation.annotationType().getAnnotation(Target.class);
                ElementType[] elementTypes = target.value();
                if (elementTypes.length == 1 && elementTypes[0].equals((Object)ElementType.TYPE)) continue;
                throw new WebBeansConfigurationException(errorMessage);
            }
        }
    }

    public static <T> void checkLifecycleConditions(AnnotatedType<T> annotatedType, Annotation[] annots, String errorMessage) {
        if (InterceptorUtil.isLifecycleMethodInterceptor(annotatedType) && !InterceptorUtil.isBusinessMethodInterceptor(annotatedType)) {
            Annotation[] anns;
            for (Annotation annotation : anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(annots)) {
                Target target = annotation.annotationType().getAnnotation(Target.class);
                ElementType[] elementTypes = target.value();
                if (elementTypes.length == 1 && elementTypes[0].equals((Object)ElementType.TYPE)) continue;
                throw new WebBeansConfigurationException(errorMessage);
            }
        }
    }

    public static void checkSimpleWebBeansInterceptorConditions(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Annotation[] anns = clazz.getDeclaredAnnotations();
        boolean hasClassInterceptors = false;
        if (AnnotationUtil.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = AnnotationUtil.getStereotypeMetaAnnotations(clazz.getDeclaredAnnotations());
            for (Annotation stero : stereoTypes) {
                if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (ClassUtil.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansConfigurationException("Final Simple class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (ClassUtil.isStatic(modifiers) || ClassUtil.isPrivate(modifiers) || !ClassUtil.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansConfigurationException("Simple web bean class : " + clazz.getName() + " can not define non-static, non-private final methods. Because it is annotated with at least one @InterceptorBinding");
            }
            if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) continue;
            throw new WebBeansConfigurationException("Method : " + method.getName() + "in simple web bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final . Because it is annotated with at least one @InterceptorBinding");
        }
    }
}

