/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class InterceptorHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorHandler.class);
    protected OwbBean<?> bean = null;
    private static Map<OwbBean<?>, Class<?>> interceptorProxyClasses = new ConcurrentHashMap();

    protected InterceptorHandler(OwbBean<?> bean2) {
        this.bean = bean2;
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments, CreationalContextImpl<?> ownerCreationalContext) throws Exception {
        try {
            if (this.bean instanceof InjectionTargetBean) {
                InjectionTargetBean injectionTarget = (InjectionTargetBean)this.bean;
                if ((!ClassUtil.isObjectMethod(method.getName()) || method.getName().equals("toString")) && InterceptorUtil.isWebBeansBusinessMethod(method)) {
                    DelegateHandler delegateHandler = null;
                    List<Object> decorators = null;
                    if (injectionTarget.getDecoratorStack().size() > 0) {
                        Class<?> proxyClass = interceptorProxyClasses.get(this.bean);
                        if (proxyClass == null) {
                            ProxyFactory delegateFactory = JavassistProxyFactory.createProxyFactory(this.bean);
                            proxyClass = JavassistProxyFactory.getProxyClass(delegateFactory);
                            interceptorProxyClasses.put(this.bean, proxyClass);
                        }
                        Object delegate = proxyClass.newInstance();
                        delegateHandler = new DelegateHandler();
                        ((ProxyObject)delegate).setHandler((MethodHandler)delegateHandler);
                        decorators = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, instance, delegate, ownerCreationalContext);
                        delegateHandler.setDecorators(decorators);
                    }
                    List<InterceptorData> stack = injectionTarget.getInterceptorStack();
                    ArrayList<InterceptorData> temp = new ArrayList<InterceptorData>(stack);
                    this.filterCommonInterceptorStackList(temp, method, ownerCreationalContext);
                    if (decorators != null && temp.size() > 0) {
                        WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(delegateHandler, instance);
                        InterceptorDataImpl data = new InterceptorDataImpl(true);
                        data.setInterceptorInstance(lastInterceptor);
                        data.setAroundInvoke(lastInterceptor.getClass().getDeclaredMethods()[0]);
                        temp.add(data);
                    }
                    if (WebBeansUtil.isContainsInterceptorMethod(temp, InterceptorType.AROUND_INVOKE)) {
                        return this.callAroundInvokes(method, arguments, WebBeansUtil.getInterceptorMethods(temp, InterceptorType.AROUND_INVOKE));
                    }
                    if (decorators != null) {
                        return delegateHandler.invoke(instance, method, proceed, arguments);
                    }
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
            }
            return method.invoke(instance, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (Exception.class.isAssignableFrom(target.getClass())) {
                throw (Exception)target;
            }
            throw e;
        }
    }

    protected abstract <T> Object callAroundInvokes(Method var1, Object[] var2, List<InterceptorData> var3) throws Exception;

    private boolean shouldRemoveInterceptorCommon(InterceptorData id, Method method) {
        boolean isMethodAnnotatedWithInterceptorClass = false;
        boolean isMethodAnnotatedWithExcludeInterceptorClass = false;
        if (id.isDefinedWithWebBeansInterceptor()) {
            if (AnnotationUtil.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) {
                isMethodAnnotatedWithInterceptorClass = true;
            }
            if (AnnotationUtil.hasMethodAnnotation(method, ExcludeClassInterceptors.class)) {
                isMethodAnnotatedWithExcludeInterceptorClass = true;
            }
        } else {
            if (AnnotationUtil.hasMethodAnnotation(method, Interceptors.class)) {
                isMethodAnnotatedWithInterceptorClass = true;
            }
            if (AnnotationUtil.hasMethodAnnotation(method, ExcludeClassInterceptors.class)) {
                isMethodAnnotatedWithExcludeInterceptorClass = true;
            }
        }
        if (isMethodAnnotatedWithExcludeInterceptorClass && !id.isDefinedInMethod() && id.isDefinedInInterceptorClass()) {
            return true;
        }
        return id.isDefinedInMethod() && !id.getInterceptorBindingMethod().equals(method);
    }

    private void filterCommonInterceptorStackList(List<InterceptorData> stack, Method method, CreationalContextImpl<?> ownerCreationalContext) {
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            InterceptorData data = it.next();
            if (!this.shouldRemoveInterceptorCommon(data, method)) continue;
            it.remove();
        }
        InterceptorHandler.injectInterceptorFields(stack, ownerCreationalContext);
    }

    public static void injectInterceptorFields(List<InterceptorData> stack, CreationalContextImpl<?> ownerCreationalContext) {
        Iterator<InterceptorData> it = stack.iterator();
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        while (it.hasNext()) {
            InterceptorData intData = it.next();
            if (!intData.isDefinedInInterceptorClass()) continue;
            try {
                if (!intData.isDefinedWithWebBeansInterceptor()) continue;
                WebBeansInterceptor interceptor = (WebBeansInterceptor)intData.getWebBeansInterceptor();
                CreationalContext creationalContext = manager.createCreationalContext((Contextual)interceptor);
                Object interceptorProxy = manager.getReference(interceptor, interceptor.getBeanClass(), creationalContext);
                interceptor.setInjections(interceptorProxy, creationalContext);
                intData.setInterceptorInstance(interceptorProxy);
                if (ownerCreationalContext == null) continue;
                ownerCreationalContext.addDependent(interceptor, interceptorProxy, creationalContext);
            }
            catch (WebBeansException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeLong(1L);
        String passivationId = this.bean.getId();
        if (passivationId != null) {
            s.writeObject(passivationId);
        } else {
            s.writeObject(null);
            logger.warn("Trying to serialize not passivated capable bean proxy : " + this.bean);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (s.readLong() == 1L) {
            String passivationId = (String)s.readObject();
            if (passivationId != null) {
                this.bean = (OwbBean)BeanManagerImpl.getManager().getPassivationCapableBean(passivationId);
            }
        } else {
            logger.warn("Trying to deserialize not passivated capable bean proxy : " + this.bean);
        }
    }
}

