/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AbstractInjectable;

public class InjectableMethods<T>
extends AbstractInjectable {
    protected Method method;
    protected Object instance;
    private boolean disposable;
    private Object producerMethodInstance = null;

    public InjectableMethods(Method m, Object instance, OwbBean<?> owner, CreationalContext<?> creationalContext) {
        super(owner, creationalContext);
        this.method = m;
        this.instance = instance;
        this.injectionMember = m;
    }

    public T doInjection() {
        List<InjectionPoint> injectedPoints = this.getInjectedPoints(this.method);
        ArrayList<Object> list = new ArrayList<Object>();
        block2: for (int i = 0; i < injectedPoints.size(); ++i) {
            for (InjectionPoint point : injectedPoints) {
                AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                if (parameter.getPosition() != i) continue;
                boolean injectionPoint = false;
                if (this.injectionOwnerBean instanceof ProducerMethodBean && parameter.getBaseType().equals(InjectionPoint.class)) {
                    BeanManagerImpl manager = BeanManagerImpl.getManager();
                    Bean injectionPointBean = (Bean)manager.getBeans((Type)((Object)InjectionPoint.class), new Annotation[]{new DefaultLiteral()}).iterator().next();
                    Object reference = manager.getReference(injectionPointBean, (Type)((Object)InjectionPoint.class), manager.createCreationalContext((Contextual)injectionPointBean));
                    list.add(reference);
                    injectionPoint = true;
                }
                if (injectionPoint) continue block2;
                if (this.isDisposable() && parameter.getAnnotation(Disposes.class) != null) {
                    list.add(this.producerMethodInstance);
                    continue block2;
                }
                list.add(this.inject(point));
                continue block2;
            }
        }
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            return (T)this.method.invoke(this.instance, list.toArray());
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
    }

    private boolean isDisposable() {
        return this.disposable;
    }

    public void setDisposable(boolean disposable) {
        this.disposable = disposable;
    }

    public void setProducerMethodInstance(Object instance) {
        this.producerMethodInstance = instance;
    }
}

