/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.deployment;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Named;
import javax.inject.Scope;
import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.definition.NonexistentTypeException;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.xml.XMLUtil;
import org.dom4j.Element;

public class XMLStereoTypeModel
implements IStereoTypeModel {
    private String name;
    private Annotation defaultDeploymentType;
    private Annotation defaultScopeType;
    private Set<Class<? extends Annotation>> supportedScopes = new HashSet<Class<? extends Annotation>>();
    private Set<Class<?>> restrictedTypes = new HashSet();
    private Set<Annotation> interceptorBindingTypes = new HashSet<Annotation>();
    private Annotation defaultName = null;
    private Set<Annotation> inherits = new HashSet<Annotation>();

    public XMLStereoTypeModel(Element stereoTypeDecleration, String name, String errorMessage) {
        this.configure(stereoTypeDecleration, errorMessage);
        this.setName(name);
    }

    private void configure(Element stereoTypeDecleration, String errorMessage) {
        List childs = stereoTypeDecleration.elements();
        if (childs != null && childs.size() > 0) {
            boolean scopeTypeFound = false;
            for (Element child : childs) {
                Class<?> clazz = XMLUtil.getElementJavaType(child);
                if (clazz == null) {
                    throw new NonexistentTypeException(errorMessage + "Type is not exist with class name : " + XMLUtil.getElementJavaClassName(child) + " in namespace : " + XMLUtil.getElementNameSpace(child));
                }
                Class<?> annClazz = null;
                if (!clazz.isAnnotation()) {
                    throw new WebBeansConfigurationException(errorMessage + "Type is not annotation type with class name : " + XMLUtil.getElementJavaClassName(child) + " in namespace : " + XMLUtil.getElementNameSpace(child));
                }
                annClazz = clazz;
                WebBeansAnnotation defaultAnn = JavassistProxyFactory.createNewAnnotationProxy(annClazz);
                if (clazz.isAnnotationPresent(NormalScope.class) || clazz.isAnnotationPresent(Scope.class)) {
                    if (scopeTypeFound) {
                        throw new WebBeansConfigurationException(errorMessage + "@StereoType annotation can not contain more than one @Scope/@NormalScope annotation");
                    }
                    this.defaultScopeType = defaultAnn;
                    scopeTypeFound = true;
                    continue;
                }
                if (AnnotationUtil.isInterceptorBindingAnnotation(annClazz)) {
                    Target target = clazz.getAnnotation(Target.class);
                    ElementType[] type = target.value();
                    if (type.length != 1 && !type[0].equals((Object)ElementType.TYPE)) {
                        throw new WebBeansConfigurationException(errorMessage + "Stereotype with @InterceptorBinding must be defined as @Target{TYPE}");
                    }
                    this.interceptorBindingTypes.add(XMLUtil.getXMLDefinedAnnotationMember(child, annClazz, errorMessage));
                    continue;
                }
                if (clazz.equals(Named.class)) {
                    this.defaultName = defaultAnn;
                    Named name = (Named)this.defaultName;
                    if (name.value().equals("")) continue;
                    throw new WebBeansConfigurationException(errorMessage + "@StereoType annotation can not define @Named annotation with value");
                }
                if (AnnotationUtil.isQualifierAnnotation(annClazz)) {
                    throw new WebBeansConfigurationException(errorMessage + "@StereoType annotation can not define @Qualifier annotation");
                }
                if (AnnotationUtil.isStereoTypeAnnotation(annClazz)) {
                    Target innerStereo = clazz.getAnnotation(Target.class);
                    Class<?> outerStereoClass = XMLUtil.getElementJavaType(stereoTypeDecleration);
                    Target outerStereo = outerStereoClass.getAnnotation(Target.class);
                    ElementType[] innerValues = innerStereo.value();
                    ElementType[] outerValues = outerStereo.value();
                    for (ElementType innerValue : innerValues) {
                        if (innerValue.equals((Object)ElementType.METHOD) || innerValue.equals((Object)ElementType.FIELD)) {
                            for (ElementType outerValue : outerValues) {
                                if (!outerValue.equals((Object)ElementType.TYPE)) continue;
                                throw new WebBeansConfigurationException(errorMessage + "Inherited StereoType with class name : " + clazz.getName() + " must have compatible @Target annotation with Stereotype class name : " + outerStereoClass.getName());
                            }
                            continue;
                        }
                        if (!innerValue.equals((Object)ElementType.TYPE)) continue;
                        for (ElementType outerValue : outerValues) {
                            if (!outerValue.equals((Object)ElementType.METHOD) && !outerValue.equals((Object)ElementType.FIELD)) continue;
                            throw new WebBeansConfigurationException(errorMessage + "Inherited StereoType with class name : " + clazz.getName() + " must have compatible @Target annotation with Stereotype class name : " + outerStereoClass.getName());
                        }
                    }
                    this.inherits.add(defaultAnn);
                    continue;
                }
                throw new WebBeansConfigurationException(errorMessage + "Type with class name : " + XMLUtil.getElementJavaClassName(child) + " is not applicable for stereotype");
            }
        }
    }

    @Override
    public Annotation getDefaultDeploymentType() {
        return this.defaultDeploymentType;
    }

    @Override
    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    @Override
    public Set<Annotation> getInterceptorBindingTypes() {
        return this.interceptorBindingTypes;
    }

    @Override
    public Set<Annotation> getInheritedStereoTypes() {
        return this.inherits;
    }

    public Annotation getDefaultNamed() {
        return this.defaultName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<Class<?>> getRestrictedTypes() {
        return this.restrictedTypes;
    }

    public Set<Class<? extends Annotation>> getSupportedScopes() {
        return this.supportedScopes;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLStereoTypeModel)) {
            return false;
        }
        XMLStereoTypeModel model = (XMLStereoTypeModel)obj;
        return model.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

