/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.deployment;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;

public class StereoTypeModel
implements IStereoTypeModel {
    private String name;
    private Annotation defaultDeploymentType;
    private Annotation defaultScopeType;
    private Set<Annotation> interceptorBindingTypes = new HashSet<Annotation>();
    private Set<Annotation> inherits = new HashSet<Annotation>();

    public StereoTypeModel(Class<? extends Annotation> clazz) {
        this(clazz, clazz.getDeclaredAnnotations());
    }

    public StereoTypeModel(Class<? extends Annotation> clazz, Annotation[] annotationDefs) {
        this.name = clazz.getName();
        this.configAnnotations(clazz, annotationDefs);
    }

    private void configAnnotations(Class<? extends Annotation> clazz, Annotation ... annotations) {
        if (AnnotationUtil.hasMetaAnnotation(annotations, NormalScope.class)) {
            this.defaultScopeType = AnnotationUtil.getMetaAnnotations(annotations, NormalScope.class)[0];
        }
        if (AnnotationUtil.hasMetaAnnotation(annotations, Scope.class)) {
            this.defaultScopeType = AnnotationUtil.getMetaAnnotations(annotations, Scope.class)[0];
        }
        if (AnnotationUtil.hasInterceptorBindingMetaAnnotation(annotations)) {
            Annotation[] ibs;
            for (Annotation ann : ibs = AnnotationUtil.getInterceptorBindingMetaAnnotations(annotations)) {
                this.interceptorBindingTypes.add(ann);
            }
        }
        if (AnnotationUtil.hasStereoTypeMetaAnnotation(annotations)) {
            Annotation[] isy = AnnotationUtil.getStereotypeMetaAnnotations(annotations);
            Target outerStereo = clazz.getAnnotation(Target.class);
            for (Annotation is : isy) {
                Target innerStereo = is.annotationType().getAnnotation(Target.class);
                ElementType[] innerValues = innerStereo.value();
                ElementType[] outerValues = outerStereo.value();
                for (ElementType innerValue : innerValues) {
                    if (innerValue.equals((Object)ElementType.METHOD) || innerValue.equals((Object)ElementType.FIELD)) {
                        for (ElementType outerValue : outerValues) {
                            if (!outerValue.equals((Object)ElementType.TYPE) || outerValues.length != 1) continue;
                            throw new WebBeansConfigurationException("Inherited StereoType with class name : " + clazz.getName() + " must have compatible @Target annotation with Stereotype class name : " + clazz.getName());
                        }
                        continue;
                    }
                    if (!innerValue.equals((Object)ElementType.TYPE) || innerValues.length != 1) continue;
                    for (ElementType outerValue : outerValues) {
                        if (!outerValue.equals((Object)ElementType.METHOD) && !outerValue.equals((Object)ElementType.FIELD)) continue;
                        throw new WebBeansConfigurationException("Inherited StereoType with class name : " + clazz.getName() + " must have compatible @Target annotation with Stereotype class name : " + clazz.getName());
                    }
                }
                this.inherits.add(is);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Annotation getDefaultDeploymentType() {
        return this.defaultDeploymentType;
    }

    @Override
    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    @Override
    public Set<Annotation> getInterceptorBindingTypes() {
        return this.interceptorBindingTypes;
    }

    @Override
    public Set<Annotation> getInheritedStereoTypes() {
        return this.inherits;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StereoTypeModel)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        StereoTypeModel model = (StereoTypeModel)obj;
        return model.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

