/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;

public class DelegateHandler
implements MethodHandler {
    private static transient WebBeansLogger logger = WebBeansLogger.getLogger(DelegateHandler.class);
    private transient List<Object> decorators;
    private transient int position = 0;
    private transient Object actualBean = null;

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        if (this.actualBean == null) {
            this.actualBean = instance;
        }
        while (this.position < this.decorators.size()) {
            Object decorator = this.decorators.get(this.position++);
            try {
                Method decMethod = decorator.getClass().getMethod(method.getName(), method.getParameterTypes());
                boolean methodInInterface = this.checkForMethodInInterfaces(decorator.getClass(), method);
                if (decMethod == null || !methodInInterface) continue;
                if (!decMethod.isAccessible()) {
                    decMethod.setAccessible(true);
                }
                Object returnValue = decMethod.invoke(decorator, arguments);
                --this.position;
                return returnValue;
            }
            catch (SecurityException e) {
                logger.error("ERROR_0011", new Object[]{method.getName(), decorator.getClass().getName()});
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                logger.error("ERROR_0012", new Object[]{method.getName(), decorator.getClass().getName()}, e.getTargetException());
                throw new WebBeansException(e);
            }
            catch (IllegalAccessException e) {
                logger.error("ERROR_0014", new Object[]{method.getName(), decorator.getClass().getName()});
                throw new WebBeansException(e);
            }
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        Object result = method.invoke(this.actualBean, arguments);
        return result;
    }

    private boolean checkForMethodInInterfaces(Class<? extends Object> class1, Method m) {
        Class<?>[] interfaces = class1.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                if (interfaces[i].getMethod(m.getName(), m.getParameterTypes()) == null) continue;
                return true;
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void setDecorators(List<Object> dec) {
        this.decorators = dec;
    }
}

