/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.util.Asserts;

public class ConversationManager {
    private ConcurrentHashMap<Conversation, ConversationContext> conversations = new ConcurrentHashMap();

    public static ConversationManager getInstance() {
        ConversationManager manager = (ConversationManager)WebBeansFinder.getSingletonInstance(WebBeansFinder.SINGLETON_CONVERSATION_MANAGER);
        return manager;
    }

    public void addConversationContext(Conversation conversation, ConversationContext context) {
        this.conversations.put(conversation, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConversationExistWithGivenId(String conversationId) {
        ConcurrentHashMap<Conversation, ConversationContext> concurrentHashMap = this.conversations;
        synchronized (concurrentHashMap) {
            ConversationImpl conv2 = null;
            Set set = this.conversations.keySet();
            for (ConversationImpl conv2 : set) {
                if (!conv2.getId().equals(conversationId)) continue;
                return true;
            }
        }
        return false;
    }

    public ConversationContext removeConversation(Conversation conversation) {
        Asserts.assertNotNull(conversation, "conversation can not be null");
        return this.conversations.remove(conversation);
    }

    public ConversationContext getConversationContext(Conversation conversation) {
        Asserts.assertNotNull(conversation, "conversation can not be null");
        return this.conversations.get(conversation);
    }

    public Conversation getPropogatedConversation(String conversationId, String sessionId) {
        Asserts.assertNotNull(conversationId, "conversationId parameter can not be null");
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        ConversationImpl conv2 = null;
        Set set = this.conversations.keySet();
        for (ConversationImpl conv2 : set) {
            if (!conv2.getId().equals(conversationId) || !conv2.getSessionId().equals(sessionId)) continue;
            return conv2;
        }
        return null;
    }

    public void destroyConversationContextWithSessionId(String sessionId) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        ConversationImpl conv = null;
        Set set = this.conversations.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            conv = (ConversationImpl)it.next();
            if (!conv.getSessionId().equals(sessionId)) continue;
            ConversationContext ctx = this.getConversationContext(conv);
            if (ctx != null) {
                ctx.destroy();
            }
            it.remove();
        }
    }

    public Conversation getConversationBeanReference() {
        BeanManagerImpl beanManager = BeanManagerImpl.getManager();
        Bean bean = (Bean)beanManager.getBeans((Type)((Object)Conversation.class), new Annotation[]{new DefaultLiteral()}).iterator().next();
        Conversation conversation = (Conversation)beanManager.getReference(bean, (Type)((Object)Conversation.class), beanManager.createCreationalContext((Contextual)bean));
        return conversation;
    }

    public void destroyWithRespectToTimout() {
        ConversationImpl conv = null;
        Set set = this.conversations.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            conv = (ConversationImpl)it.next();
            long timeout = conv.getTimeout();
            if (timeout == 0L || System.currentTimeMillis() - conv.getActiveTime() <= timeout) continue;
            ConversationContext ctx = this.getConversationContext(conv);
            if (ctx != null) {
                ctx.destroy();
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllConversations() {
        ConcurrentHashMap<Conversation, ConversationContext> concurrentHashMap = this.conversations;
        synchronized (concurrentHashMap) {
            if (this.conversations != null) {
                ConcurrentHashMap<Conversation, ConversationContext> oldConversations = this.conversations;
                this.conversations = new ConcurrentHashMap();
                for (ConversationContext ctx : oldConversations.values()) {
                    ctx.destroy();
                }
                this.conversations.clear();
            }
        }
    }
}

