/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
Serializable {
    private static final long serialVersionUID = -3416834742959340960L;
    private Object incompleteInstance = null;
    private Object proxyInstance = null;
    private Map<Object, DependentCreationalContext<?>> dependentObjects = new WeakHashMap();
    private Contextual<T> contextual = null;
    private CreationalContextImpl<?> ownerCreational = null;

    CreationalContextImpl(Contextual<T> contextual) {
        this.contextual = contextual;
    }

    public void push(T incompleteInstance) {
        this.incompleteInstance = incompleteInstance;
    }

    public void setProxyInstance(Object proxyInstance) {
        this.proxyInstance = proxyInstance;
    }

    public Object getProxyInstance() {
        return this.proxyInstance;
    }

    public <K> void addDependent(Contextual<K> dependent, Object instance, CreationalContext<K> cc) {
        Asserts.assertNotNull(dependent, "dependent parameter cannot be null");
        if (instance != null) {
            this.dependentObjects.put(instance, new DependentCreationalContext<K>(cc, dependent));
        }
    }

    public Object get() {
        return this.incompleteInstance;
    }

    public void remove() {
        this.incompleteInstance = null;
    }

    private void removeDependents() {
        Set<Object> values = this.dependentObjects.keySet();
        for (Object e : values) {
            DependentCreationalContext<?> dependent = this.dependentObjects.get(e);
            dependent.getContextual().destroy(e, dependent.getCreationalContext());
        }
        this.dependentObjects.clear();
    }

    public void release() {
        this.removeDependents();
    }

    public Contextual<T> getBean() {
        return this.contextual;
    }

    public CreationalContextImpl<?> getOwnerCreational() {
        return this.ownerCreational;
    }

    public void setOwnerCreational(CreationalContextImpl<?> ownerCreational) {
        this.ownerCreational = ownerCreational;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.incompleteInstance);
        s.writeObject(this.proxyInstance);
        HashMap depo = new HashMap(this.dependentObjects);
        s.writeObject(depo);
        String id = null;
        if (this.contextual != null && (id = WebBeansUtil.isPassivationCapable(this.contextual)) != null) {
            s.writeObject(id);
        } else {
            s.writeObject(null);
        }
        s.writeObject(this.ownerCreational);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.incompleteInstance = s.readObject();
        this.proxyInstance = s.readObject();
        HashMap depo = (HashMap)s.readObject();
        this.dependentObjects = new WeakHashMap(depo);
        String id = (String)s.readObject();
        if (id != null) {
            this.contextual = BeanManagerImpl.getManager().getPassivationCapableBean(id);
        }
        this.ownerCreational = (CreationalContextImpl)s.readObject();
    }
}

