/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.SessionContextManager;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansNameSpaceContainer;
import org.apache.webbeans.xml.XMLAnnotationTypeManager;
import org.apache.webbeans.xml.XMLSpecializesManager;

public class WebBeansFinder {
    public static final String SINGLETON_MANAGER = BeanManagerImpl.class.getName();
    public static final String SINGLETON_DECORATORS_MANAGER = DecoratorsManager.class.getName();
    public static final String SINGLETON_STEREOTYPE_MANAGER = StereoTypeManager.class.getName();
    public static final String SINGLETON_INTERCEPTORS_MANAGER = InterceptorsManager.class.getName();
    public static final String SINGLETON_CONVERSATION_MANAGER = ConversationManager.class.getName();
    public static final String SINGLETON_XML_ANNOTATION_TYPE_MANAGER = XMLAnnotationTypeManager.class.getName();
    public static final String SINGLETON_XML_SPECIALIZES_MANAGER = XMLSpecializesManager.class.getName();
    public static final String SINGLETON_CREATIONAL_CONTEXT_FACTORY = CreationalContextFactory.class.getName();
    public static final String SINGLETON_SESSION_CONTEXT_MANAGER = SessionContextManager.class.getName();
    public static final String SINGLETON_WEBBEANS_NAMESPACE_CONTAINER = WebBeansNameSpaceContainer.class.getName();
    private static Map<String, Map<ClassLoader, Object>> singletonMap = new HashMap<String, Map<ClassLoader, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSingletonInstance(String singletonName) {
        Object object = null;
        Map<String, Map<ClassLoader, Object>> map = singletonMap;
        synchronized (map) {
            ClassLoader classLoader = WebBeansUtil.getCurrentClassLoader();
            Map<ClassLoader, Object> managerMap = singletonMap.get(singletonName);
            if (managerMap == null) {
                managerMap = new HashMap<ClassLoader, Object>();
                singletonMap.put(singletonName, managerMap);
            }
            if ((object = managerMap.get(classLoader)) == null) {
                Class<?> clazz = ClassUtil.getClassFromName(singletonName);
                if (clazz == null) {
                    throw new WebBeansException("Cannot find class : " + singletonName);
                }
                try {
                    object = clazz.newInstance();
                    managerMap.put(classLoader, object);
                }
                catch (InstantiationException e) {
                    throw new WebBeansException("Unable to instantiate class : " + singletonName, e);
                }
                catch (IllegalAccessException e) {
                    throw new WebBeansException("Illegal access exception in creating instance with class : " + singletonName, e);
                }
            }
        }
        return object;
    }

    public static void clearInstances() {
        if (singletonMap != null) {
            singletonMap.clear();
        }
    }

    public static void removeInstance(String name) {
        singletonMap.remove(name);
    }
}

