/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class AbstractBeanCreator<T>
implements BeanCreator<T> {
    private final AbstractOwbBean<T> bean;
    private BeanCreator.MetaDataProvider metadataProvider = BeanCreator.MetaDataProvider.DEFAULT;
    private Producer<T> producer;
    private final Annotation[] beanAnnotations;
    private AnnotatedType<T> annotatedType;
    private boolean producerSet = false;

    public AbstractBeanCreator(AbstractOwbBean<T> bean, Annotation[] beanAnnotations) {
        this.bean = bean;
        this.beanAnnotations = beanAnnotations;
    }

    @Override
    public boolean isProducerSet() {
        return this.producerSet;
    }

    @Override
    public void checkCreateConditions() {
    }

    @Override
    public void defineApiType() {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineApiTypes(this.bean, this.bean.getReturnType());
        } else {
            Set types = this.annotatedType.getTypeClosure();
            this.bean.getTypes().addAll(types);
        }
    }

    @Override
    public void defineQualifier() {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineQualifiers(this.bean, this.beanAnnotations);
        } else {
            DefinitionUtil.defineQualifiers(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()));
        }
    }

    @Override
    public void defineName(String defaultName) {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineName(this.bean, this.beanAnnotations, defaultName);
        } else {
            DefinitionUtil.defineName(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()), WebBeansUtil.getManagedBeanDefaultName(this.annotatedType.getJavaClass().getSimpleName()));
        }
    }

    @Override
    public void defineScopeType(String errorMessage) {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineScopeType(this.bean, this.beanAnnotations, errorMessage);
        } else {
            DefinitionUtil.defineScopeType(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()), errorMessage);
        }
    }

    @Override
    public void defineSerializable() {
        DefinitionUtil.defineSerializable(this.bean);
    }

    @Override
    public void defineStereoTypes() {
        if (this.isDefaultMetaDataProvider()) {
            DefinitionUtil.defineStereoTypes(this.bean, this.beanAnnotations);
        } else {
            DefinitionUtil.defineStereoTypes(this.bean, AnnotationUtil.getAnnotationsFromSet(this.annotatedType.getAnnotations()));
        }
    }

    @Override
    public BeanCreator.MetaDataProvider getMetaDataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetaDataProvider(BeanCreator.MetaDataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected boolean isDefaultMetaDataProvider() {
        return this.metadataProvider.equals((Object)BeanCreator.MetaDataProvider.DEFAULT);
    }

    @Override
    public Producer<T> getProducer() {
        return this.producer;
    }

    @Override
    public void setProducer(Producer<T> producer) {
        this.producer = producer;
        this.producerSet = true;
    }

    @Override
    public AbstractOwbBean<T> getBean() {
        return this.bean;
    }

    public void dispose(T instance) {
        this.producer.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.producer.getInjectionPoints();
    }

    public T produce(CreationalContext<T> creationalContext) {
        return (T)this.producer.produce(creationalContext);
    }

    protected AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    public void setAnnotatedType(AnnotatedType<T> annotatedType) {
        this.annotatedType = annotatedType;
    }
}

