/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.inheritance.BeanInheritedMetaData;
import org.apache.webbeans.config.inheritance.IBeanInheritedMetaData;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorHandler;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ServiceLoader;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class AbstractInjectionTargetBean<T>
extends AbstractOwbBean<T>
implements InjectionTargetBean<T> {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(this.getClass());
    private Set<Method> observableMethods = new HashSet<Method>();
    private Set<Field> injectedFields = new HashSet<Field>();
    private Set<Method> injectedMethods = new HashSet<Method>();
    private Set<Field> injectedFromSuperFields = new HashSet<Field>();
    private Set<Method> injectedFromSuperMethods = new HashSet<Method>();
    private AnnotatedType<T> annotatedType;
    private boolean fullyInitialize = true;
    protected List<InterceptorData> interceptorStack = new ArrayList<InterceptorData>();
    protected List<Decorator<?>> decorators = new ArrayList();
    protected IBeanInheritedMetaData inheritedMetaData;
    protected InjectionTarget<T> injectionTarget;

    protected AbstractInjectionTargetBean(WebBeansType webBeansType, Class<T> returnType) {
        super(webBeansType, returnType);
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        Object instance = null;
        if (this.isInjectionTargetSet()) {
            instance = this.getInjectionTarget().produce(creationalContext);
            this.getInjectionTarget().inject(instance, creationalContext);
            this.postConstruct(instance, creationalContext);
        } else {
            instance = this.createDefaultInstance(creationalContext);
        }
        return (T)instance;
    }

    protected T createDefaultInstance(CreationalContext<T> creationalContext) {
        CreationalContextImpl cc;
        this.beforeConstructor();
        T instance = this.createComponentInstance(creationalContext);
        if (!this.isFullyInitialize()) {
            return instance;
        }
        if (creationalContext instanceof CreationalContextImpl) {
            cc = (CreationalContextImpl)creationalContext;
            cc.push(instance);
        }
        this.afterConstructor(instance, creationalContext);
        if (creationalContext instanceof CreationalContextImpl) {
            cc = (CreationalContextImpl)creationalContext;
            cc.remove();
            cc.setProxyInstance(null);
        }
        return instance;
    }

    @Override
    protected void destroyInstance(T instance, CreationalContext<T> creationalContext) {
        this.destroyComponentInstance(instance, creationalContext);
    }

    protected T createComponentInstance(CreationalContext<T> creationalContext) {
        return null;
    }

    protected void destroyComponentInstance(T instance, CreationalContext<T> creationalContext) {
        this.preDestroy(instance, creationalContext);
    }

    protected void beforeConstructor() {
    }

    protected void afterConstructor(T instance, CreationalContext<T> creationalContext) {
        this.injectResources(instance, creationalContext);
        this.injectSuperFields(instance, creationalContext);
        this.injectSuperMethods(instance, creationalContext);
        this.injectFields(instance, creationalContext);
        this.injectMethods(instance, creationalContext);
        this.postConstruct(instance, creationalContext);
    }

    @Override
    public void postConstruct(T instance, CreationalContext<T> cretionalContext) {
        if (this.isInjectionTargetSet()) {
            this.getInjectionTarget().postConstruct(instance);
        } else {
            this.postConstructDefault(instance, cretionalContext);
        }
    }

    protected void postConstructDefault(T instance, CreationalContext<T> ownerCreationalContext) {
        if (this.getWebBeansType().equals((Object)WebBeansType.MANAGED) && WebBeansUtil.isContainsInterceptorMethod(this.getInterceptorStack(), InterceptorType.POST_CONSTRUCT)) {
            InterceptorHandler.injectInterceptorFields(this.getInterceptorStack(), (CreationalContextImpl)ownerCreationalContext);
            InvocationContextImpl impl = new InvocationContextImpl(null, instance, null, null, WebBeansUtil.getInterceptorMethods(this.getInterceptorStack(), InterceptorType.POST_CONSTRUCT), InterceptorType.POST_CONSTRUCT);
            try {
                impl.proceed();
            }
            catch (Exception e) {
                this.logger.error("ERROR_0008", new Object[]{"@PostConstruct."}, e);
                throw new WebBeansException(e);
            }
        }
    }

    @Override
    public void preDestroy(T instance, CreationalContext<T> creationalContext) {
        if (this.isInjectionTargetSet()) {
            this.getInjectionTarget().preDestroy(instance);
        } else {
            this.preDestroyDefault(instance, creationalContext);
        }
    }

    protected void preDestroyDefault(T instance, CreationalContext<T> creationalContext) {
        if ((this.getWebBeansType().equals((Object)WebBeansType.MANAGED) || this.getWebBeansType().equals((Object)WebBeansType.DECORATOR)) && WebBeansUtil.isContainsInterceptorMethod(this.getInterceptorStack(), InterceptorType.PRE_DESTROY)) {
            InterceptorHandler.injectInterceptorFields(this.getInterceptorStack(), (CreationalContextImpl)creationalContext);
            InvocationContextImpl impl = new InvocationContextImpl(null, instance, null, null, WebBeansUtil.getInterceptorMethods(this.getInterceptorStack(), InterceptorType.PRE_DESTROY), InterceptorType.PRE_DESTROY);
            try {
                impl.proceed();
            }
            catch (Exception e) {
                this.getLogger().error("ERROR_0008", new Object[]{"@PreDestroy."}, e);
                throw new WebBeansException(e);
            }
        }
    }

    @Override
    public void injectFields(T instance, CreationalContext<T> creationalContext) {
        Set<Field> fields = this.getInjectedFields();
        for (Field field : fields) {
            if (field.getAnnotation(Delegate.class) != null) continue;
            if (!field.getType().equals(InjectionPoint.class)) {
                this.injectField(field, instance, creationalContext);
                continue;
            }
            Bean injectionPointBean = (Bean)this.getManager().getBeans(InjectionPoint.class, new Annotation[]{new DefaultLiteral()}).iterator().next();
            Object reference = this.getManager().getReference(injectionPointBean, InjectionPoint.class, this.getManager().createCreationalContext((Contextual)injectionPointBean));
            ClassUtil.setField(instance, field, reference);
        }
    }

    @Override
    public void injectSuperFields(T instance, CreationalContext<T> creationalContext) {
        Set<Field> fields = this.getInjectedFromSuperFields();
        for (Field field : fields) {
            if (field.getAnnotation(Delegate.class) != null) continue;
            this.injectField(field, instance, creationalContext);
        }
    }

    @Override
    public void injectSuperMethods(T instance, CreationalContext<T> creationalContext) {
        Set<Method> methods = this.getInjectedFromSuperMethods();
        for (Method method : methods) {
            this.injectMethod(method, instance, creationalContext);
        }
    }

    private void injectField(Field field, Object instance, CreationalContext<?> creationalContext) {
        InjectableField f = new InjectableField(field, instance, this, creationalContext);
        f.doInjection();
    }

    @Override
    public void injectMethods(T instance, CreationalContext<T> creationalContext) {
        Set<Method> methods = this.getInjectedMethods();
        for (Method method : methods) {
            this.injectMethod(method, instance, creationalContext);
        }
    }

    private void injectMethod(Method method, Object instance, CreationalContext<?> creationalContext) {
        InjectableMethods m = new InjectableMethods(method, instance, this, creationalContext);
        m.doInjection();
    }

    @Override
    public void injectResources(T instance, CreationalContext<T> creationalContext) {
        if (this.getWebBeansType().equals((Object)WebBeansType.MANAGED)) {
            try {
                ResourceInjectionService service = null;
                try {
                    service = ServiceLoader.getService(ResourceInjectionService.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (service != null) {
                    service.injectJavaEEResources(instance);
                }
            }
            catch (Exception e) {
                this.logger.error("Error is occured while injection Java EE Resources for the bean instance : " + instance);
                throw new WebBeansException("Error is occured while injection Java EE Resources for the bean instance : " + instance, e);
            }
        }
    }

    @Override
    public void addObservableMethod(Method observerMethod) {
        this.observableMethods.add(observerMethod);
    }

    @Override
    public Set<Method> getObservableMethods() {
        return this.observableMethods;
    }

    @Override
    public Set<Field> getInjectedFields() {
        return this.injectedFields;
    }

    @Override
    public void addInjectedField(Field field) {
        this.injectedFields.add(field);
    }

    @Override
    public Set<Field> getInjectedFromSuperFields() {
        return this.injectedFromSuperFields;
    }

    @Override
    public void addInjectedFieldToSuper(Field field) {
        this.injectedFromSuperFields.add(field);
    }

    @Override
    public Set<Method> getInjectedMethods() {
        return this.injectedMethods;
    }

    @Override
    public void addInjectedMethod(Method method) {
        this.injectedMethods.add(method);
    }

    @Override
    public Set<Method> getInjectedFromSuperMethods() {
        return this.injectedFromSuperMethods;
    }

    @Override
    public void addInjectedMethodToSuper(Method method) {
        this.injectedFromSuperMethods.add(method);
    }

    @Override
    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    @Override
    public List<InterceptorData> getInterceptorStack() {
        return this.interceptorStack;
    }

    @Override
    public List<Decorator<?>> getDecoratorStack() {
        return this.decorators;
    }

    @Override
    public IBeanInheritedMetaData getInheritedMetaData() {
        return this.inheritedMetaData;
    }

    protected void setInheritedMetaData() {
        this.inheritedMetaData = new BeanInheritedMetaData(this);
    }

    @Override
    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    protected boolean isInjectionTargetSet() {
        return this.injectionTarget != null;
    }

    @Override
    protected WebBeansLogger getLogger() {
        return this.logger;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        if (this.isInjectionTargetSet()) {
            return this.getInjectionTarget().getInjectionPoints();
        }
        return super.getInjectionPoints();
    }

    @Override
    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public void setAnnotatedType(AnnotatedType<T> annotatedType) {
        this.annotatedType = annotatedType;
    }

    @Override
    public void setFullyInitialize(boolean initialize) {
        this.fullyInitialize = initialize;
    }

    @Override
    public boolean isFullyInitialize() {
        return this.fullyInitialize;
    }

    @Override
    public void validatePassivationDependencies() {
        super.validatePassivationDependencies();
        for (Decorator<?> dec : this.decorators) {
            WebBeansDecorator decorator = (WebBeansDecorator)dec;
            if (!decorator.isPassivationCapable()) {
                throw new WebBeansConfigurationException("Passivation bean : " + this.toString() + " decorators must be passivating capable");
            }
            decorator.validatePassivationDependencies();
        }
        for (InterceptorData interceptorData : this.interceptorStack) {
            Class<?> interceptorClass;
            if (interceptorData.isDefinedWithWebBeansInterceptor()) {
                WebBeansInterceptor interceptor = (WebBeansInterceptor)interceptorData.getWebBeansInterceptor();
                if (!interceptor.isPassivationCapable()) {
                    throw new WebBeansConfigurationException("Passivation bean : " + this.toString() + " interceptors must be passivating capable");
                }
                interceptor.validatePassivationDependencies();
                continue;
            }
            Object interceptorInstance = interceptorData.getInterceptorInstance();
            if (interceptorInstance == null || Serializable.class.isAssignableFrom(interceptorClass = interceptorInstance.getClass())) continue;
            throw new WebBeansConfigurationException("Passivation bean : " + this.toString() + " interceptors must be passivating capable");
        }
    }
}

