/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.component;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.spi.BeanAttributes;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.util.ClassUtil;

public abstract class BaseEjbBean<T>
extends InjectionTargetBean<T>
implements EnterpriseBeanMarker {
    public static final Object[] OBJECT_EMPTY = new Object[0];
    protected final SessionBeanType ejbType;
    private Map<Object, Object> dependentSFSBToBeRemoved = new ConcurrentHashMap<Object, Object>();

    protected BaseEjbBean(WebBeansContext webBeansContext, SessionBeanType type, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, Class<T> beanClass, InjectionTargetFactoryImpl<T> factory) {
        super(webBeansContext, WebBeansType.ENTERPRISE, annotatedType, beanAttributes, beanClass, factory);
        this.ejbType = type;
    }

    protected BaseEjbBean(WebBeansContext webBeansContext, SessionBeanType type, AnnotatedType<T> annotatedType, BeanAttributesImpl<T> beanAttributes, Class<T> beanClass) {
        super(webBeansContext, WebBeansType.ENTERPRISE, annotatedType, beanAttributes, beanClass);
        this.ejbType = type;
    }

    public boolean isPassivationCapable() {
        return this.getEjbType().equals((Object)SessionBeanType.STATEFUL);
    }

    protected void destroyStatefulSessionBeanInstance(T proxyInstance, Object ejbInstance) {
        Method removeMeth = null;
        for (Method m : this.getRemoveMethods()) {
            try {
                removeMeth = proxyInstance.getClass().getMethod(m.getName(), m.getParameterTypes());
                ClassUtil.callInstanceMethod((Method)removeMeth, proxyInstance, (Object[])OBJECT_EMPTY);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().log(Level.SEVERE, "Error calling Stateful Session Bean remove method: ", e);
                throw new RuntimeException(e);
            }
        }
    }

    public List<Method> getRemoveMethods() {
        return null;
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        return null;
    }

    public String getEjbName() {
        return null;
    }

    public SessionBeanType getEjbType() {
        return this.ejbType;
    }

    public void addDependentSFSB(Object dependentSFSB, Object proxy) {
        this.dependentSFSBToBeRemoved.put(proxy, dependentSFSB);
    }

    public void removeDependentSFSB(Object proxy) {
        this.dependentSFSBToBeRemoved.remove(proxy);
    }

    public Object getDependentSFSBForProxy(Object proxy) {
        return this.dependentSFSBToBeRemoved.get(proxy);
    }

    public boolean needsBeanLocalViewAddedToTypes() {
        return false;
    }
}

