/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.resource;

import java.lang.annotation.Annotation;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.CreationException;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManager;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.webbeans.ejb.EjbPlugin;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.spi.api.ResourceReference;

class ResourceInjectionProcessor {
    private Context context = null;
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ResourceInjectionProcessor.class);

    ResourceInjectionProcessor(Context context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) throws Exception {
        X resource = null;
        if (this.context == null) {
            return null;
        }
        if (resourceReference.supports(Resource.class)) {
            Resource annotation = (Resource)resourceReference.getAnnotation(Resource.class);
            String name = annotation.name();
            if (name == null || name.equals("")) {
                name = resourceReference.getOwnerClass() + "/" + resourceReference.getName();
            }
            resource = this.lookupFieldResource(this.context, "openejb/Resource/" + name, resourceReference.getResourceType());
            return resource;
        }
        if (resourceReference.supports(EJB.class)) {
            EJB annotation = (EJB)resourceReference.getAnnotation(EJB.class);
            String intf = null;
            if (annotation.beanInterface() != null && annotation.beanInterface() != Object.class && !annotation.beanInterface().equals("")) {
                intf = annotation.beanInterface().getName();
            }
            if (intf == null) {
                intf = resourceReference.getResourceType().getName();
            }
            if (intf == null && annotation.beanName() == null) {
                String name;
                if (logger.wblWillLogWarn()) {
                    logger.warn("To inject @EJBs into the managed beans you have to give @EJB(beanName), trying to get inject with @EJB(name) where name is the internal JNDI name of the OpenEJB Bean");
                }
                if ((name = annotation.name()) == null || name.equals("")) {
                    name = resourceReference.getOwnerClass() + "/" + resourceReference.getName();
                }
                resource = this.lookupFieldResource(this.context, "openejb/Deployment/" + name, resourceReference.getResourceType());
                return resource;
            }
            EjbPlugin plugin = (EjbPlugin)PluginLoader.getInstance().getEjbPlugin();
            return (X)plugin.getEjbInstance(intf, resourceReference.getResourceType());
        }
        if (resourceReference.supports(WebServiceRef.class)) {
            WebServiceRef annotation = (WebServiceRef)resourceReference.getAnnotation(WebServiceRef.class);
            String name = annotation.name();
            if (name == null || name.equals("")) {
                name = resourceReference.getOwnerClass() + "/" + resourceReference.getName();
            }
            resource = this.lookupFieldResource(this.context, name, resourceReference.getResourceType());
            return resource;
        }
        if (resourceReference.supports(PersistenceUnit.class)) {
            PersistenceUnit annotation = (PersistenceUnit)resourceReference.getAnnotation(PersistenceUnit.class);
            resource = this.getPersistenceUnit(this.context, annotation.unitName(), resourceReference.getResourceType());
            return resource;
        }
        if (!resourceReference.supports(PersistenceContext.class)) return resource;
        PersistenceContext annotation = (PersistenceContext)resourceReference.getAnnotation(PersistenceContext.class);
        resource = this.getPersistenceContext(this.context, annotation.unitName(), resourceReference.getResourceType());
        return resource;
    }

    protected <X> X lookupFieldResource(Context context, String name, Class<X> clazz) throws NamingException, IllegalAccessException {
        Object lookedupResource = null;
        if (name != null && name.length() > 0) {
            lookedupResource = context.lookup("java:/" + name);
        }
        return clazz.cast(lookedupResource);
    }

    private <X> X getPersistenceContext(Context context, String unitName, Class<X> clazz) {
        JtaEntityManagerRegistry jtaEntityManagerRegistry = (JtaEntityManagerRegistry)SystemInstance.get().getComponent(JtaEntityManagerRegistry.class);
        EntityManagerFactory factory = this.getPersistenceUnit(context, unitName, EntityManagerFactory.class);
        JtaEntityManager jtaEntityManager = new JtaEntityManager(jtaEntityManagerRegistry, factory, null, false);
        return clazz.cast(jtaEntityManager);
    }

    private <X> X getPersistenceUnit(Context context, String unitName, Class<X> clazz) {
        EntityManagerFactory factory;
        try {
            NamingEnumeration<NameClassPair> persUnits = context.list("java:openejb/PersistenceUnit");
            if (persUnits == null) {
                throw new CreationException("No PersistenceUnit found in java:openejb/PersistenceUnit!");
            }
            String shortestMatch = null;
            while (persUnits.hasMore()) {
                NameClassPair puNc = persUnits.next();
                if (!puNc.getName().startsWith(unitName) || shortestMatch != null && shortestMatch.length() <= puNc.getName().length()) continue;
                shortestMatch = puNc.getName();
            }
            if (shortestMatch == null) {
                throw new CreationException("PersistenceUnit '" + unitName + "' not found");
            }
            factory = (EntityManagerFactory)context.lookup("java:openejb/PersistenceUnit/" + shortestMatch);
        }
        catch (NamingException e) {
            throw new CreationException("PersistenceUnit '" + unitName + "' not found", (Throwable)e);
        }
        return clazz.cast(factory);
    }
}

