/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.openejb.DeploymentInfo;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.ejb.component.EjbBean;
import org.apache.webbeans.ejb.component.creation.EjbBeanCreatorImpl;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class EjbUtility {
    private EjbUtility() {
    }

    public static <T> void fireEvents(Class<T> clazz, EjbBean<T> ejbBean) {
        AnnotatedType annotatedType = AnnotatedElementFactory.newAnnotatedType(clazz);
        GProcessAnnotatedType processAnnotatedEvent = WebBeansUtil.fireProcessAnnotatedTypeEvent((AnnotatedType)annotatedType);
        EjbBeanCreatorImpl<T> ejbBeanCreator = new EjbBeanCreatorImpl<T>(ejbBean);
        ejbBeanCreator.checkCreateConditions();
        if (processAnnotatedEvent.isVeto()) {
            return;
        }
        if (processAnnotatedEvent.isSet()) {
            ejbBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
        }
        ejbBeanCreator.defineSerializable();
        ejbBeanCreator.defineStereoTypes();
        ejbBeanCreator.defineApiType();
        ejbBeanCreator.defineScopeType("Session Bean implementation class : " + clazz.getName() + " stereotypes must declare same @ScopeType annotations");
        ejbBeanCreator.defineQualifier();
        ejbBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName((String)clazz.getSimpleName()));
        Set producerMethodBeans = ejbBeanCreator.defineProducerMethods();
        EjbUtility.checkProducerMethods(producerMethodBeans, ejbBean);
        Set producerFieldBeans = ejbBeanCreator.defineProducerFields();
        ejbBeanCreator.defineInjectedFields();
        ejbBeanCreator.defineInjectedMethods();
        Set<ObserverMethod<?>> observerMethods = ejbBeanCreator.defineObserverMethods();
        GProcessInjectionTarget processInjectionTargetEvent = WebBeansUtil.fireProcessInjectionTargetEvent(ejbBean);
        WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
        if (processInjectionTargetEvent.isSet()) {
            ejbBeanCreator.setInjectedTarget(processInjectionTargetEvent.getInjectionTarget());
        }
        HashMap<ProducerMethodBean, AnnotatedMethod> annotatedMethods = new HashMap<ProducerMethodBean, AnnotatedMethod>();
        for (ProducerMethodBean producerMethod : producerMethodBeans) {
            AnnotatedMethod method = AnnotatedElementFactory.newAnnotatedMethod((Method)producerMethod.getCreatorMethod(), (Class)producerMethod.getParent().getReturnType());
            GProcessProducer producerEvent = WebBeansUtil.fireProcessProducerEventForMethod((ProducerMethodBean)producerMethod, (AnnotatedMethod)method);
            WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
            annotatedMethods.put(producerMethod, method);
            if (producerEvent.isProducerSet()) {
                producerMethod.setProducer(ejbBeanCreator);
            }
            producerEvent.setProducerSet(false);
        }
        HashMap<ProducerFieldBean, AnnotatedField> annotatedFields = new HashMap<ProducerFieldBean, AnnotatedField>();
        for (ProducerFieldBean producerField : producerFieldBeans) {
            AnnotatedField field = AnnotatedElementFactory.newAnnotatedField((Field)producerField.getCreatorField(), (Class)producerField.getParent().getReturnType());
            GProcessProducer producerEvent = WebBeansUtil.fireProcessProducerEventForField((ProducerFieldBean)producerField, (AnnotatedField)field);
            WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
            annotatedFields.put(producerField, field);
            if (producerEvent.isProducerSet()) {
                producerField.setProducer(ejbBeanCreator);
            }
            producerEvent.setProducerSet(false);
        }
        HashMap observerMethodsMap = new HashMap();
        for (ObserverMethod<?> observerMethod : observerMethods) {
            ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
            AnnotatedMethod method = AnnotatedElementFactory.newAnnotatedMethod((Method)impl.getObserverMethod(), (Class)impl.getBeanClass());
            observerMethodsMap.put(observerMethod, method);
        }
        GProcessSessionBean processBeanEvent = new GProcessSessionBean(ejbBean, annotatedType, ejbBean.getEjbName(), ejbBean.getEjbType());
        BeanManagerImpl.getManager().fireEvent((Object)processBeanEvent, new Annotation[0]);
        WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessSessionBean event observers for managed beans. Look at logs for further details");
        WebBeansUtil.fireProcessProducerMethodBeanEvent(annotatedMethods);
        WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
        WebBeansUtil.fireProcessProducerFieldBeanEvent(annotatedFields);
        WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
        WebBeansUtil.fireProcessObservableMethodBeanEvent(observerMethodsMap);
        WebBeansUtil.inspectErrorStack((String)"There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
        if (ejbBeanCreator.isInjectionTargetSet()) {
            ejbBean.setInjectionTarget((InjectionTarget)ejbBeanCreator);
        }
        BeanManagerImpl.getManager().addBean((Bean)WebBeansUtil.createNewBean(ejbBean));
        BeanManagerImpl.getManager().addBean(ejbBean);
        BeanManagerImpl.getManager().getBeans().addAll(producerMethodBeans);
        ejbBeanCreator.defineDisposalMethods();
        BeanManagerImpl.getManager().getBeans().addAll(producerFieldBeans);
    }

    private static void checkProducerMethods(Set<ProducerMethodBean<?>> producerMethodBeans, EjbBean<?> bean) {
        for (ProducerMethodBean<?> producerMethodBean : producerMethodBeans) {
            Method producerMethod = producerMethodBean.getCreatorMethod();
            if (ClassUtil.isStatic((Integer)producerMethod.getModifiers()) || EjbUtility.isBusinessMethod(producerMethod, bean)) continue;
            throw new WebBeansConfigurationException("Producer Method Bean must be business method of session bean : " + bean);
        }
    }

    public static boolean isBusinessMethod(Method method, EjbBean<?> bean) {
        DeploymentInfo info = bean.getDeploymentInfo();
        List businessLocals = info.getBusinessLocalInterfaces();
        for (Class clz : businessLocals) {
            try {
                clz.getMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (SecurityException e) {
                throw new WebBeansException("Security exception", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
            }
        }
        return false;
    }
}

