/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.component.creation;

import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.DeploymentInfo;
import org.apache.webbeans.component.creation.AbstractInjectedTargetBeanCreator;
import org.apache.webbeans.ejb.component.EjbBean;
import org.apache.webbeans.ejb.component.creation.EjbBeanCreator;
import org.apache.webbeans.ejb.util.EjbValidator;
import org.apache.webbeans.exception.WebBeansPassivationException;

public class EjbBeanCreatorImpl<T>
extends AbstractInjectedTargetBeanCreator<T>
implements EjbBeanCreator<T> {
    public EjbBeanCreatorImpl(EjbBean<T> ejbBean) {
        super(ejbBean);
    }

    public void checkCreateConditions() {
        EjbValidator.validateDecoratorOrInterceptor(this.getBean().getReturnType());
    }

    public void defineScopeType(String errorMessage) throws WebBeansPassivationException {
        block2: {
            try {
                super.defineScopeType(errorMessage);
            }
            catch (WebBeansPassivationException e) {
                SessionBeanType type = this.getBean().getEjbType();
                if (type.equals((Object)SessionBeanType.STATEFUL)) break block2;
                throw e;
            }
        }
        EjbValidator.validateEjbScopeType(this.getBean());
        EjbValidator.validateGenericBeanType(this.getBean().getReturnType(), this.getBean().getScope());
    }

    public void defineApiType() {
        if (this.isDefaultMetaDataProvider()) {
            DeploymentInfo info = this.getBean().getDeploymentInfo();
            List businessLocals = info.getBusinessLocalInterfaces();
            for (Class clazz : businessLocals) {
                this.getBean().addApiType(clazz);
            }
            this.getBean().addApiType(Object.class);
        }
    }

    public Set<ObserverMethod<?>> defineObserverMethods() {
        Set observerMethods = super.defineObserverMethods();
        EjbValidator.validateObserverMethods(this.getBean(), observerMethods);
        return observerMethods;
    }

    public EjbBean<T> getBean() {
        return (EjbBean)((Object)EjbBean.class.cast(super.getBean()));
    }
}

