/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.component;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.WebBeansType;

public class EjbBean<T>
extends AbstractInjectionTargetBean<T>
implements EnterpriseBeanMarker {
    private SessionBeanType ejbType;
    private DeploymentInfo deploymentInfo;
    private T instance = null;
    private Class<?> iface = null;
    private boolean removeStatefulInstance = false;

    public EjbBean(Class<T> ejbClassType) {
        super(WebBeansType.ENTERPRISE, ejbClassType);
        this.setInheritedMetaData();
    }

    public void setIface(Class<?> iface) {
        this.iface = iface;
    }

    public void setRemoveStatefulInstance(boolean remove) {
        this.removeStatefulInstance = remove;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public void injectFields(T instance, CreationalContext<T> creationalContext) {
    }

    public boolean isPassivationCapable() {
        return this.ejbType.equals((Object)SessionBeanType.STATEFUL);
    }

    public void injectFieldInInterceptor(Object instance, CreationalContext<?> creationalContext) {
        super.injectFields(instance, creationalContext);
    }

    protected T createComponentInstance(CreationalContext<T> creationalContext) {
        if (this.instance == null) {
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            Context jndiContext = containerSystem.getJNDIContext();
            DeploymentInfo deploymentInfo = this.getDeploymentInfo();
            try {
                if (this.iface != null) {
                    InterfaceType type = deploymentInfo.getInterfaceType(this.iface);
                    if (!type.equals((Object)InterfaceType.BUSINESS_LOCAL)) {
                        throw new IllegalArgumentException("Interface type is not legal business local interface for session bean class : " + this.getReturnType().getName());
                    }
                } else {
                    this.iface = this.deploymentInfo.getBusinessLocalInterface();
                }
                String jndiName = "java:openejb/Deployment/" + JndiBuilder.format((Object)deploymentInfo.getDeploymentID(), (String)this.iface.getName());
                this.instance = this.iface.cast(jndiContext.lookup(jndiName));
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.instance;
    }

    protected void destroyComponentInstance(T instance, CreationalContext<T> creational) {
        if (!this.removeStatefulInstance || this.getEjbType().equals((Object)SessionBeanType.STATEFUL)) {
            // empty if block
        }
        this.instance = null;
    }

    public void setEjbType(SessionBeanType type) {
        this.ejbType = type;
    }

    public String getEjbName() {
        return this.deploymentInfo.getEjbName();
    }

    public SessionBeanType getEjbType() {
        return this.ejbType;
    }
}

