/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.set.MapBackedSet;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.event.TransactionEventManager;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.DetachManager;
import org.apache.openjpa.kernel.ExpressionStoreQuery;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.ExtentImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FindCallbacks;
import org.apache.openjpa.kernel.InverseManager;
import org.apache.openjpa.kernel.LocalManagedRuntime;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.MethodStoreQuery;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPASavepoint;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.SavepointFieldManager;
import org.apache.openjpa.kernel.SavepointManager;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.UUIDHexSeq;
import org.apache.openjpa.kernel.UUIDStringSeq;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ReferenceHashMap;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.lib.util.concurrent.ReentrantLock;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.CallbackException;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.NoTransactionException;
import org.apache.openjpa.util.ObjectExistsException;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;

public class BrokerImpl
implements Broker,
FindCallbacks,
Cloneable {
    protected static final int FLUSH_INC = 0;
    protected static final int FLUSH_COMMIT = 1;
    protected static final int FLUSH_ROLLBACK = 2;
    protected static final int FLUSH_LOGICAL = 3;
    static final int STATUS_INIT = 0;
    static final int STATUS_TRANSIENT = 1;
    static final int STATUS_OID_ASSIGN = 2;
    static final int STATUS_COMMIT_NEW = 3;
    private static final int FLAG_ACTIVE = 2;
    private static final int FLAG_STORE_ACTIVE = 4;
    private static final int FLAG_CLOSE_INVOKED = 8;
    private static final int FLAG_PRESTORING = 16;
    private static final int FLAG_DEREFDELETING = 32;
    private static final int FLAG_FLUSHING = 64;
    private static final int FLAG_STORE_FLUSHING = 128;
    private static final int FLAG_FLUSHED = 256;
    private static final int FLAG_FLUSH_REQUIRED = 512;
    private static final int FLAG_REMOTE_LISTENER = 1024;
    private static final int FLAG_RETAINED_CONN = 2048;
    private static final int FLAG_TRANS_ENDING = 4096;
    private static final Localizer _loc = Localizer.forPackage((Class)BrokerImpl.class);
    private DelegatingStoreManager _store = null;
    private AbstractBrokerFactory _factory = null;
    private OpenJPAConfiguration _conf = null;
    private Compatibility _compat = null;
    private FetchConfiguration _fc = null;
    private Log _log = null;
    private String _user = null;
    private String _pass = null;
    private ManagedRuntime _runtime = null;
    private LockManager _lm = null;
    private InverseManager _im = null;
    private ReentrantLock _lock = null;
    private OpCallbacks _call = null;
    private RuntimeExceptionTranslator _extrans = null;
    private ClassLoader _loader = null;
    private Synchronization _sync = null;
    private Map _userObjects = null;
    private ManagedCache _cache = null;
    private TransactionalCache _transCache = null;
    private Set _transAdditions = null;
    private Set _derefCache = null;
    private Set _derefAdditions = null;
    private Map _loading = null;
    private Set _operating = null;
    private Set _persistedClss = null;
    private Set _updatedClss = null;
    private Set _deletedClss = null;
    private Set _pending = null;
    private int findAllDepth = 0;
    private Set _savepointCache = null;
    private LinkedMap _savepoints = null;
    private SavepointManager _spm = null;
    private ReferenceHashSet _queries = null;
    private ReferenceHashSet _extents = null;
    private int _operationCount = 0;
    private boolean _nontransRead = false;
    private boolean _nontransWrite = false;
    private boolean _retainState = false;
    private int _autoClear = 0;
    private int _restoreState = 1;
    private boolean _optimistic = false;
    private boolean _ignoreChanges = false;
    private boolean _multithreaded = false;
    private boolean _managed = false;
    private boolean _syncManaged = false;
    private int _connRetainMode = 0;
    private boolean _evictDataCache = false;
    private boolean _populateDataCache = true;
    private boolean _largeTransaction = false;
    private int _autoDetach = 0;
    private int _detachState = 1;
    private boolean _detachedNew = true;
    private boolean _orderDirty = false;
    private int _flags = 0;
    private boolean _closed = false;
    private RuntimeException _closedException = null;
    private TransactionEventManager _transEventManager = null;
    private int _transCallbackMode = 0;
    private LifecycleEventManager _lifeEventManager = null;
    private int _lifeCallbackMode = 0;
    private boolean _initializeWasInvoked = false;
    private static final Object[] EMPTY_OBJECTS = new Object[0];

    public void setAuthentication(String user, String pass) {
        this._user = user;
        this._pass = pass;
    }

    public void initialize(AbstractBrokerFactory factory, DelegatingStoreManager sm, boolean managed, int connMode) {
        this._initializeWasInvoked = true;
        this._loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        this._conf = factory.getConfiguration();
        this._compat = this._conf.getCompatibilityInstance();
        this._factory = factory;
        this._log = this._conf.getLog("openjpa.Runtime");
        this._cache = new ManagedCache(this.newManagedObjectCache());
        this._operating = MapBackedSet.decorate((Map)new IdentityMap());
        this._connRetainMode = connMode;
        this._managed = managed;
        this._runtime = managed ? this._conf.getManagedRuntimeInstance() : new LocalManagedRuntime(this);
        this._lifeEventManager = new LifecycleEventManager(this._conf.getLog("openjpa.Runtime"));
        this._transEventManager = new TransactionEventManager();
        int cmode = this._conf.getMetaDataRepositoryInstance().getMetaDataFactory().getDefaults().getCallbackMode();
        this.setLifecycleListenerCallbackMode(cmode);
        this.setTransactionListenerCallbackMode(cmode);
        this._factory.configureBroker(this);
        this._store = sm;
        this._lm = this._conf.newLockManagerInstance();
        this._im = this._conf.newInverseManagerInstance();
        this._spm = this._conf.getSavepointManagerInstance();
        this._store.setContext(this);
        this._lm.setContext(this);
        if (this._connRetainMode == 2) {
            this.retainConnection();
        }
        this._fc = this._store.newFetchConfiguration();
        this._fc.setContext(this);
        if (this._factory.syncWithManagedTransaction(this, false)) {
            this.beginInternal();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        if (this._initializeWasInvoked) {
            throw new CloneNotSupportedException();
        }
        return super.clone();
    }

    protected Map newManagedObjectCache() {
        return new ReferenceHashMap(0, 2);
    }

    public Broker getBroker() {
        return this;
    }

    public void setImplicitBehavior(OpCallbacks call, RuntimeExceptionTranslator ex) {
        if (this._call == null) {
            this._call = call;
        }
        if (this._extrans == null) {
            this._extrans = ex;
        }
    }

    RuntimeExceptionTranslator getInstanceExceptionTranslator() {
        return this._operationCount == 0 ? this._extrans : null;
    }

    public BrokerFactory getBrokerFactory() {
        return this._factory;
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public FetchConfiguration getFetchConfiguration() {
        return this._fc;
    }

    public int getConnectionRetainMode() {
        return this._connRetainMode;
    }

    public boolean isManaged() {
        return this._managed;
    }

    public ManagedRuntime getManagedRuntime() {
        return this._runtime;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public DelegatingStoreManager getStoreManager() {
        return this._store;
    }

    public LockManager getLockManager() {
        return this._lm;
    }

    public InverseManager getInverseManager() {
        return this._im;
    }

    public String getConnectionUserName() {
        return this._user;
    }

    public String getConnectionPassword() {
        return this._pass;
    }

    public boolean getMultithreaded() {
        return this._multithreaded;
    }

    public void setMultithreaded(boolean multithreaded) {
        this.assertOpen();
        this._multithreaded = multithreaded;
        if (multithreaded && this._lock == null) {
            this._lock = new ReentrantLock();
        } else if (!multithreaded) {
            this._lock = null;
        }
    }

    public boolean getIgnoreChanges() {
        return this._ignoreChanges;
    }

    public void setIgnoreChanges(boolean val) {
        this.assertOpen();
        this._ignoreChanges = val;
    }

    public boolean getNontransactionalRead() {
        return this._nontransRead;
    }

    public void setNontransactionalRead(boolean val) {
        this.assertOpen();
        if ((this._flags & 0x10) != 0) {
            throw new UserException(_loc.get("illegal-op-in-prestore"));
        }
        if (val) {
            if (!this._conf.supportedOptions().contains("openjpa.option.NontransactionalRead")) {
                throw new UnsupportedException(_loc.get("nontrans-read-not-supported"));
            }
        }
        this._nontransRead = val;
    }

    public boolean getNontransactionalWrite() {
        return this._nontransWrite;
    }

    public void setNontransactionalWrite(boolean val) {
        this.assertOpen();
        if ((this._flags & 0x10) != 0) {
            throw new UserException(_loc.get("illegal-op-in-prestore"));
        }
        this._nontransWrite = val;
    }

    public boolean getOptimistic() {
        return this._optimistic;
    }

    public void setOptimistic(boolean val) {
        this.assertOpen();
        if ((this._flags & 2) != 0) {
            throw new InvalidStateException(_loc.get("trans-active", (Object)"Optimistic"));
        }
        if (val) {
            if (!this._conf.supportedOptions().contains("openjpa.option.Optimistic")) {
                throw new UnsupportedException(_loc.get("optimistic-not-supported"));
            }
        }
        this._optimistic = val;
    }

    public int getRestoreState() {
        return this._restoreState;
    }

    public void setRestoreState(int val) {
        this.assertOpen();
        if ((this._flags & 2) != 0) {
            throw new InvalidStateException(_loc.get("trans-active", (Object)"Restore"));
        }
        this._restoreState = val;
    }

    public boolean getRetainState() {
        return this._retainState;
    }

    public void setRetainState(boolean val) {
        this.assertOpen();
        if ((this._flags & 0x10) != 0) {
            throw new UserException(_loc.get("illegal-op-in-prestore"));
        }
        this._retainState = val;
    }

    public int getAutoClear() {
        return this._autoClear;
    }

    public void setAutoClear(int val) {
        this.assertOpen();
        this._autoClear = val;
    }

    public int getAutoDetach() {
        return this._autoDetach;
    }

    public void setAutoDetach(int detachFlags) {
        this.assertOpen();
        this._autoDetach = detachFlags;
    }

    public void setAutoDetach(int detachFlag, boolean on) {
        this.assertOpen();
        this._autoDetach = on ? (this._autoDetach |= detachFlag) : (this._autoDetach &= ~detachFlag);
    }

    public int getDetachState() {
        return this._detachState;
    }

    public void setDetachState(int mode) {
        this.assertOpen();
        this._detachState = mode;
    }

    public boolean isDetachedNew() {
        return this._detachedNew;
    }

    public void setDetachedNew(boolean isNew) {
        this.assertOpen();
        this._detachedNew = isNew;
    }

    public boolean getSyncWithManagedTransactions() {
        return this._syncManaged;
    }

    public void setSyncWithManagedTransactions(boolean sync) {
        this.assertOpen();
        this._syncManaged = sync;
    }

    public boolean getEvictFromDataCache() {
        return this._evictDataCache;
    }

    public void setEvictFromDataCache(boolean evict) {
        this.assertOpen();
        this._evictDataCache = evict;
    }

    public boolean getPopulateDataCache() {
        return this._populateDataCache;
    }

    public void setPopulateDataCache(boolean cache) {
        this.assertOpen();
        this._populateDataCache = cache;
    }

    public boolean isTrackChangesByType() {
        return this._largeTransaction;
    }

    public void setTrackChangesByType(boolean largeTransaction) {
        this.assertOpen();
        this._largeTransaction = largeTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserObject(Object key) {
        this.beginOperation(false);
        try {
            Object var2_2 = this._userObjects == null ? null : this._userObjects.get(key);
            return var2_2;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putUserObject(Object key, Object val) {
        this.beginOperation(false);
        try {
            if (val == null) {
                Object var3_3 = this._userObjects == null ? null : this._userObjects.remove(key);
                return var3_3;
            }
            if (this._userObjects == null) {
                this._userObjects = new HashMap();
            }
            Object object = this._userObjects.put(key, val);
            return object;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(Object listener, Class[] classes) {
        this.beginOperation(false);
        try {
            this._lifeEventManager.addListener(listener, classes);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(Object listener) {
        this.beginOperation(false);
        try {
            this._lifeEventManager.removeListener(listener);
        }
        finally {
            this.endOperation();
        }
    }

    public int getLifecycleListenerCallbackMode() {
        return this._lifeCallbackMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifecycleListenerCallbackMode(int mode) {
        this.beginOperation(false);
        try {
            this._lifeCallbackMode = mode;
            this._lifeEventManager.setFailFast((mode & 2) != 0);
        }
        finally {
            this.endOperation();
        }
    }

    public LifecycleEventManager getLifecycleEventManager() {
        return this._lifeEventManager;
    }

    boolean fireLifecycleEvent(Object src, Object related, ClassMetaData meta, int eventType) {
        if (this._lifeEventManager == null) {
            return false;
        }
        this.handleCallbackExceptions(this._lifeEventManager.fireEvent(src, related, meta, eventType), this._lifeCallbackMode);
        return true;
    }

    private void handleCallbackExceptions(Exception[] exceps, int mode) {
        if (exceps.length == 0 || (mode & 4) != 0) {
            return;
        }
        OpenJPAException ce = exceps.length == 1 ? new CallbackException(exceps[0]) : new CallbackException(_loc.get("callback-err")).setNestedThrowables(exceps);
        if ((mode & 0x20) != 0 && (this._flags & 2) != 0) {
            ce.setFatal(true);
            this.setRollbackOnlyInternal(ce);
        }
        if ((mode & 8) != 0 && this._log.isWarnEnabled()) {
            this._log.warn((Object)ce);
        }
        if ((mode & 0x10) != 0) {
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionListener(Object tl) {
        this.beginOperation(false);
        try {
            this._transEventManager.addListener(tl);
            if (tl instanceof RemoteCommitEventManager) {
                this._flags |= 0x400;
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionListener(Object tl) {
        this.beginOperation(false);
        try {
            if (this._transEventManager.removeListener(tl) && tl instanceof RemoteCommitEventManager) {
                this._flags &= 0xFFFFFBFF;
            }
        }
        finally {
            this.endOperation();
        }
    }

    public int getTransactionListenerCallbackMode() {
        return this._transCallbackMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionListenerCallbackMode(int mode) {
        this.beginOperation(false);
        try {
            this._transCallbackMode = mode;
            this._transEventManager.setFailFast((mode & 2) != 0);
        }
        finally {
            this.endOperation();
        }
    }

    private void fireTransactionEvent(TransactionEvent trans) {
        if (this._transEventManager != null) {
            this.handleCallbackExceptions(this._transEventManager.fireEvent(trans), this._transCallbackMode);
        }
    }

    public Object find(Object oid, boolean validate, FindCallbacks call) {
        int flags = 28;
        if (!validate) {
            flags |= 2;
        }
        return this.find(oid, this._fc, null, null, flags, call);
    }

    public Object find(Object oid, FetchConfiguration fetch, BitSet exclude, Object edata, int flags) {
        return this.find(oid, fetch, exclude, edata, flags, null);
    }

    protected Object find(Object oid, FetchConfiguration fetch, BitSet exclude, Object edata, int flags, FindCallbacks call) {
        if (call == null) {
            call = this;
        }
        if ((oid = call.processArgument(oid)) == null) {
            if ((flags & 2) == 0) {
                throw new ObjectNotFoundException(_loc.get("null-oid"));
            }
            return call.processReturn(oid, null);
        }
        if (fetch == null) {
            fetch = this._fc;
        }
        this.beginOperation(true);
        try {
            this.assertNontransactionalRead();
            StateManagerImpl sm = this.getStateManagerImplById(oid, (flags & 0x10) != 0 || (this._flags & 0x100) != 0);
            if (sm != null) {
                if (!this.requiresLoad(sm, true, fetch, edata, flags)) {
                    Object object = call.processReturn(oid, sm);
                    return object;
                }
                if (!sm.isLoading()) {
                    boolean loaded;
                    if (!sm.isTransactional() && this.useTransactionalState(fetch)) {
                        sm.transactional();
                    }
                    try {
                        loaded = sm.load(fetch, 0, exclude, edata, false);
                    }
                    catch (ObjectNotFoundException onfe) {
                        if ((flags & 4) != 0 || (flags & 2) != 0) {
                            throw onfe;
                        }
                        Object object = call.processReturn(oid, null);
                        this.endOperation();
                        return object;
                    }
                    if (!loaded && (flags & 2) == 0 && this._compat.getValidateTrueChecksStore() && !sm.isTransactional() && !this._store.exists(sm, edata)) {
                        if ((flags & 4) == 0) {
                            Object onfe = call.processReturn(oid, null);
                            return onfe;
                        }
                        throw new ObjectNotFoundException(_loc.get("del-instance", sm.getManagedInstance(), oid)).setFailedObject(sm.getManagedInstance());
                    }
                }
                if ((this._flags & 2) != 0) {
                    int level = fetch.getReadLockLevel();
                    this._lm.lock(sm, level, fetch.getLockTimeout(), edata);
                    sm.readLocked(level, fetch.getWriteLockLevel());
                }
                Object level = call.processReturn(oid, sm);
                return level;
            }
            if (oid instanceof StateManagerId) {
                Object level = call.processReturn(oid, null);
                return level;
            }
            sm = this.newStateManagerImpl(oid, (flags & 8) != 0);
            boolean load = this.requiresLoad(sm, false, fetch, edata, flags);
            if ((sm = this.initialize(sm, load, fetch, edata)) == null) {
                if ((flags & 2) != 0) {
                    throw new ObjectNotFoundException(oid);
                }
                Object onfe = call.processReturn(oid, null);
                return onfe;
            }
            if (load) {
                try {
                    sm.load(fetch, 0, exclude, edata, false);
                }
                catch (ObjectNotFoundException onfe) {
                    if ((flags & 4) != 0 || (flags & 2) != 0) {
                        throw onfe;
                    }
                    Object object = call.processReturn(oid, null);
                    this.endOperation();
                    return object;
                }
            }
            Object object = call.processReturn(oid, sm);
            return object;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateManagerImpl initialize(StateManagerImpl sm, boolean load, FetchConfiguration fetch, Object edata) {
        if (!load) {
            sm.initialize(sm.getMetaData().getDescribedType(), PCState.HOLLOW);
        } else {
            PCState state = this.useTransactionalState(fetch) ? PCState.PCLEAN : PCState.PNONTRANS;
            sm.setLoading(true);
            try {
                if (!this._store.initialize(sm, state, fetch, edata)) {
                    StateManagerImpl stateManagerImpl = null;
                    return stateManagerImpl;
                }
            }
            finally {
                sm.setLoading(false);
            }
        }
        return sm;
    }

    public Object[] findAll(Collection oids, boolean validate, FindCallbacks call) {
        int flags = 28;
        if (!validate) {
            flags |= 2;
        }
        return this.findAll(oids, this._fc, null, null, flags, call);
    }

    public Object[] findAll(Collection oids, FetchConfiguration fetch, BitSet exclude, Object edata, int flags) {
        return this.findAll(oids, fetch, exclude, edata, flags, null);
    }

    protected Object[] findAll(Collection oids, FetchConfiguration fetch, BitSet exclude, Object edata, int flags, FindCallbacks call) {
        ++this.findAllDepth;
        if (oids == null) {
            throw new NullPointerException("oids == null");
        }
        if ((flags & 2) != 0 && oids.contains(null)) {
            throw new UserException(_loc.get("null-oids"));
        }
        if (this._loading == null) {
            this._loading = new HashMap((int)((double)oids.size() * 1.33 + 1.0));
        }
        if (call == null) {
            call = this;
        }
        if (fetch == null) {
            fetch = this._fc;
        }
        this.beginOperation(true);
        try {
            PCState state;
            Collection failed;
            StateManagerImpl sm;
            Object oid;
            this.assertNontransactionalRead();
            ArrayList<StateManagerImpl> load = null;
            boolean transState = this.useTransactionalState(fetch);
            int idx = 0;
            Iterator itr = oids.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                oid = call.processArgument(obj);
                if (oid != null && !this._loading.containsKey(obj)) {
                    boolean initialized;
                    sm = this.getStateManagerImplById(oid, (flags & 0x10) != 0 || (this._flags & 0x100) != 0);
                    boolean bl = initialized = sm != null;
                    if (!initialized) {
                        sm = this.newStateManagerImpl(oid, (flags & 8) != 0);
                    }
                    this._loading.put(obj, sm);
                    if (this.requiresLoad(sm, initialized, fetch, edata, flags)) {
                        boolean bl2 = transState = transState || this.useTransactionalState(fetch);
                        if (initialized && !sm.isTransactional() && transState) {
                            sm.transactional();
                        }
                        if (load == null) {
                            load = new ArrayList<StateManagerImpl>(oids.size() - idx);
                        }
                        load.add(sm);
                    } else if (!initialized) {
                        sm.initialize(sm.getMetaData().getDescribedType(), PCState.HOLLOW);
                    }
                }
                ++idx;
            }
            if (load != null && (failed = this._store.loadAll(load, state = transState ? PCState.PCLEAN : PCState.PNONTRANS, 0, fetch, edata)) != null && !failed.isEmpty()) {
                if ((flags & 2) != 0) {
                    throw BrokerImpl.newObjectNotFoundException(failed);
                }
                Iterator itr2 = failed.iterator();
                while (itr2.hasNext()) {
                    this._loading.put(itr2.next(), null);
                }
            }
            Object[] results = new Object[oids.size()];
            boolean active = (this._flags & 2) != 0;
            int level = fetch.getReadLockLevel();
            idx = 0;
            Iterator itr3 = oids.iterator();
            while (itr3.hasNext()) {
                oid = itr3.next();
                sm = (StateManagerImpl)this._loading.get(oid);
                if (sm != null && this.requiresLoad(sm, true, fetch, edata, flags)) {
                    try {
                        sm.load(fetch, 0, exclude, edata, false);
                        if (active) {
                            this._lm.lock(sm, level, fetch.getLockTimeout(), edata);
                            sm.readLocked(level, fetch.getWriteLockLevel());
                        }
                    }
                    catch (ObjectNotFoundException onfe) {
                        if ((flags & 4) != 0 || (flags & 2) != 0) {
                            throw onfe;
                        }
                        sm = null;
                    }
                }
                results[idx] = call.processReturn(oid, sm);
                ++idx;
            }
            Object[] objectArray = results;
            return objectArray;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            --this.findAllDepth;
            if (this.findAllDepth == 0) {
                this._loading = null;
            }
            this.endOperation();
        }
    }

    private boolean requiresLoad(OpenJPAStateManager sm, boolean initialized, FetchConfiguration fetch, Object edata, int flags) {
        if (!fetch.requiresLoad()) {
            return false;
        }
        if ((flags & 2) == 0) {
            return true;
        }
        if (edata != null) {
            return true;
        }
        if (initialized && sm.getPCState() != PCState.HOLLOW) {
            return false;
        }
        if (!initialized && sm.getMetaData().getPCSubclasses().length > 0) {
            return true;
        }
        return !this._compat.getValidateFalseReturnsHollow();
    }

    private boolean useTransactionalState(FetchConfiguration fetch) {
        return (this._flags & 2) != 0 && (!this._optimistic || this._autoClear == 1 || fetch.getReadLockLevel() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findCached(Object oid, FindCallbacks call) {
        if (call == null) {
            call = this;
        }
        if ((oid = call.processArgument(oid)) == null) {
            return call.processReturn(oid, null);
        }
        this.beginOperation(true);
        try {
            StateManagerImpl sm = this.getStateManagerImplById(oid, true);
            Object object = call.processReturn(oid, sm);
            return object;
        }
        finally {
            this.endOperation();
        }
    }

    public Class getObjectIdType(Class cls) {
        if (cls == null) {
            return null;
        }
        this.beginOperation(false);
        try {
            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(cls, this._loader, false);
            if (meta == null || meta.getIdentityType() == 0) {
                Class clazz = null;
                return clazz;
            }
            if (meta.getIdentityType() == 2) {
                Class clazz = meta.getObjectIdType();
                return clazz;
            }
            Class clazz = this._store.getDataStoreIdType(meta);
            return clazz;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public Object newObjectId(Class cls, Object val) {
        if (val == null) {
            return null;
        }
        this.beginOperation(false);
        try {
            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(cls, this._loader, true);
            switch (meta.getIdentityType()) {
                case 1: {
                    if (val instanceof String && ((String)val).startsWith("openjpasm:")) {
                        StateManagerId stateManagerId = new StateManagerId((String)val);
                        return stateManagerId;
                    }
                    Object object = this._store.newDataStoreId(val, meta);
                    return object;
                }
                case 2: {
                    Object[] objectArray;
                    if (ImplHelper.isAssignable(meta.getObjectIdType(), val.getClass())) {
                        if (!meta.isOpenJPAIdentity() && meta.isObjectIdTypeShared()) {
                            ObjectId objectId = new ObjectId(cls, val);
                            return objectId;
                        }
                        Object object = val;
                        return object;
                    }
                    if (val instanceof String && !this._conf.getCompatibilityInstance().getStrictIdentityValues() && !Modifier.isAbstract(cls.getModifiers())) {
                        Object object = PCRegistry.newObjectId(cls, (String)val);
                        return object;
                    }
                    if (val instanceof Object[]) {
                        objectArray = (Object[])val;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = val;
                    }
                    Object[] arr = objectArray;
                    Object object = ApplicationIds.fromPKValues(arr, meta);
                    return object;
                }
            }
            try {
                throw new UserException(_loc.get("meta-unknownid", (Object)cls));
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (ClassCastException cce) {
                throw new UserException(_loc.get("bad-id-value", val, (Object)val.getClass().getName(), (Object)cls)).setCause(cce);
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
        }
        finally {
            this.endOperation();
        }
    }

    private StateManagerImpl newStateManagerImpl(Object oid, boolean copy) {
        StateManagerImpl sm;
        if (this._loading != null && (sm = (StateManagerImpl)this._loading.get(oid)) != null && sm.getPersistenceCapable() == null) {
            return sm;
        }
        Class pcType = this._store.getManagedType(oid);
        MetaDataRepository repos = this._conf.getMetaDataRepositoryInstance();
        ClassMetaData meta = pcType != null ? repos.getMetaData(pcType, this._loader, true) : repos.getMetaData(oid, this._loader, true);
        if (copy && this._compat.getCopyObjectIds()) {
            if (meta.getIdentityType() == 2) {
                oid = ApplicationIds.copy(oid, meta);
            } else {
                if (meta.getIdentityType() == 0) {
                    throw new UserException(_loc.get("meta-unknownid", (Object)meta));
                }
                oid = this._store.copyDataStoreId(oid, meta);
            }
        }
        sm = this.newStateManagerImpl(oid, meta);
        sm.setObjectId(oid);
        return sm;
    }

    protected StateManagerImpl newStateManagerImpl(Object oid, ClassMetaData meta) {
        return new StateManagerImpl(oid, meta, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) != 0) {
                throw new InvalidStateException(_loc.get("active"));
            }
            this._factory.syncWithManagedTransaction(this, true);
            this.beginInternal();
        }
        finally {
            this.endOperation();
        }
    }

    private void beginInternal() {
        try {
            this.beginStoreManagerTransaction(this._optimistic);
            this._flags |= 2;
            if (!this._optimistic) {
                this._fc.setReadLockLevel(this._conf.getReadLockLevelConstant());
                this._fc.setWriteLockLevel(this._conf.getWriteLockLevelConstant());
                this._fc.setLockTimeout(this._conf.getLockTimeout());
            }
            this._lm.beginTransaction();
            if (this._transEventManager.hasBeginListeners()) {
                this.fireTransactionEvent(new TransactionEvent(this, 0, null, null, null, null));
            }
        }
        catch (OpenJPAException ke) {
            if ((this._flags & 2) != 0) {
                this.setRollbackOnlyInternal(ke);
            }
            throw ke.setFatal(true);
        }
        catch (RuntimeException re) {
            if ((this._flags & 2) != 0) {
                this.setRollbackOnlyInternal(re);
            }
            throw new StoreException(re).setFatal(true);
        }
        if (this._pending != null) {
            Iterator it = this._pending.iterator();
            while (it.hasNext()) {
                StateManagerImpl sm = (StateManagerImpl)it.next();
                sm.transactional();
                if (!sm.isDirty()) continue;
                this.setDirty(sm, true);
            }
            this._pending = null;
        }
    }

    public void beginStore() {
        this.beginOperation(true);
        try {
            this.assertTransactionOperation();
            if ((this._flags & 4) == 0) {
                this.beginStoreManagerTransaction(false);
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new StoreException(re);
        }
        finally {
            this.endOperation();
        }
    }

    private void beginStoreManagerTransaction(boolean optimistic) {
        if (!optimistic) {
            this.retainConnection();
            this._store.begin();
            this._flags |= 4;
        } else {
            if (this._connRetainMode == 1) {
                this.retainConnection();
            }
            this._store.beginOptimistic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeException endStoreManagerTransaction(boolean rollback) {
        RuntimeException err;
        boolean forcedRollback;
        block17: {
            forcedRollback = false;
            boolean releaseConn = false;
            err = null;
            try {
                if ((this._flags & 4) != 0) {
                    boolean bl = releaseConn = this._connRetainMode != 2;
                    if (rollback) {
                        this._store.rollback();
                    } else {
                        this._store.commit();
                    }
                } else {
                    releaseConn = this._connRetainMode == 1;
                    this._store.rollbackOptimistic();
                }
            }
            catch (RuntimeException re) {
                if (!rollback) {
                    forcedRollback = true;
                    try {
                        this._store.rollback();
                    }
                    catch (RuntimeException re2) {
                        // empty catch block
                    }
                }
                err = re;
            }
            finally {
                this._flags &= 0xFFFFFFFB;
            }
            if (releaseConn) {
                try {
                    this.releaseConnection();
                }
                catch (RuntimeException re) {
                    if (err != null) break block17;
                    err = re;
                }
            }
        }
        if (forcedRollback) {
            throw err;
        }
        return err;
    }

    public void commit() {
        this.beginOperation(false);
        try {
            this.assertTransactionOperation();
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                throw new InvalidStateException(_loc.get("null-trans"));
            }
            trans.commit();
        }
        catch (OpenJPAException ke) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)ke);
            }
            throw ke;
        }
        catch (Exception e) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)e);
            }
            throw new StoreException(e);
        }
        finally {
            this.endOperation();
        }
    }

    public void rollback() {
        this.beginOperation(false);
        try {
            this.assertTransactionOperation();
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans != null) {
                trans.rollback();
            }
        }
        catch (OpenJPAException ke) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)ke);
            }
            throw ke;
        }
        catch (Exception e) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)e);
            }
            throw new StoreException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncWithManagedTransaction() {
        this.assertOpen();
        this.lock();
        try {
            if ((this._flags & 2) != 0) {
                boolean bl = true;
                return bl;
            }
            if (!this._managed) {
                throw new InvalidStateException(_loc.get("trans-not-managed"));
            }
            if (this._factory.syncWithManagedTransaction(this, false)) {
                this.beginInternal();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public void commitAndResume() {
        this.endAndResume(true);
    }

    public void rollbackAndResume() {
        this.endAndResume(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endAndResume(boolean commit) {
        this.beginOperation(false);
        try {
            if (commit) {
                this.commit();
            } else {
                this.rollback();
            }
            this.begin();
        }
        finally {
            this.endOperation();
        }
    }

    public boolean getRollbackOnly() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0) {
                boolean bl = false;
                return bl;
            }
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = trans.getStatus() == 1;
            return bl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    public Throwable getRollbackCause() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0) {
                Throwable throwable = null;
                return throwable;
            }
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                Throwable throwable = null;
                return throwable;
            }
            if (trans.getStatus() == 1) {
                Throwable throwable = this._runtime.getRollbackCause();
                return throwable;
            }
            Throwable throwable = null;
            return throwable;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    public void setRollbackOnly() {
        this.setRollbackOnly(new UserException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly(Throwable cause) {
        this.beginOperation(true);
        try {
            this.assertTransactionOperation();
            this.setRollbackOnlyInternal(cause);
        }
        finally {
            this.endOperation();
        }
    }

    private void setRollbackOnlyInternal(Throwable cause) {
        try {
            Transaction trans = this._runtime.getTransactionManager().getTransaction();
            if (trans == null) {
                throw new InvalidStateException(_loc.get("null-trans"));
            }
            int tranStatus = trans.getStatus();
            if (tranStatus != 6 && tranStatus != 4 && tranStatus != 3) {
                this._runtime.setRollbackOnly(cause);
            } else if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("invalid-tran-status", (Object)new Integer(tranStatus), (Object)"setRollbackOnly"));
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public void setSavepoint(String name) {
        this.beginOperation(true);
        try {
            this.assertActiveTransaction();
            if (this._savepoints != null && this._savepoints.containsKey((Object)name)) {
                throw new UserException(_loc.get("savepoint-exists", (Object)name));
            }
            if ((this._flags & 0x100) != 0 && !this._spm.supportsIncrementalFlush()) {
                throw new UnsupportedException(_loc.get("savepoint-flush-not-supported"));
            }
            OpenJPASavepoint save = this._spm.newSavepoint(name, this);
            if (this._savepoints == null || this._savepoints.isEmpty()) {
                save.save(this.getTransactionalStates());
                this._savepoints = new LinkedMap();
            } else if (this._savepointCache == null) {
                save.save(Collections.EMPTY_LIST);
            } else {
                save.save(this._savepointCache);
                this._savepointCache.clear();
            }
            this._savepoints.put((Object)name, (Object)save);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSavepoint() {
        this.beginOperation(false);
        try {
            if (this._savepoints == null || this._savepoints.isEmpty()) {
                throw new UserException(_loc.get("no-lastsavepoint"));
            }
            this.releaseSavepoint((String)this._savepoints.get(this._savepoints.size() - 1));
        }
        finally {
            this.endOperation();
        }
    }

    public void releaseSavepoint(String savepoint) {
        this.beginOperation(false);
        try {
            OpenJPASavepoint save;
            int index;
            this.assertActiveTransaction();
            int n = index = this._savepoints == null ? -1 : this._savepoints.indexOf((Object)savepoint);
            if (index < 0) {
                throw new UserException(_loc.get("no-savepoint", (Object)savepoint));
            }
            while (this._savepoints.size() > index + 1) {
                save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
                save.release(false);
            }
            save = (OpenJPASavepoint)this._savepoints.remove(index);
            save.release(true);
            if (this._savepointCache != null) {
                this._savepointCache.clear();
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackToSavepoint() {
        this.beginOperation(false);
        try {
            if (this._savepoints == null || this._savepoints.isEmpty()) {
                throw new UserException(_loc.get("no-lastsavepoint"));
            }
            this.rollbackToSavepoint((String)this._savepoints.get(this._savepoints.size() - 1));
        }
        finally {
            this.endOperation();
        }
    }

    public void rollbackToSavepoint(String savepoint) {
        this.beginOperation(false);
        try {
            OpenJPASavepoint save;
            int index;
            this.assertActiveTransaction();
            int n = index = this._savepoints == null ? -1 : this._savepoints.indexOf((Object)savepoint);
            if (index < 0) {
                throw new UserException(_loc.get("no-savepoint", (Object)savepoint));
            }
            while (this._savepoints.size() > index + 1) {
                save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
                save.release(false);
            }
            save = (OpenJPASavepoint)this._savepoints.remove(index);
            Collection saved = save.rollback(this._savepoints.values());
            if (this._savepointCache != null) {
                this._savepointCache.clear();
            }
            if (this.hasTransactionalObjects()) {
                StateManagerImpl sm;
                TransactionalCache oldTransCache = this._transCache;
                TransactionalCache newTransCache = new TransactionalCache(this._orderDirty);
                this._transCache = null;
                Iterator itr = saved.iterator();
                while (itr.hasNext()) {
                    SavepointFieldManager fm = (SavepointFieldManager)itr.next();
                    sm = fm.getStateManager();
                    sm.rollbackToSavepoint(fm);
                    oldTransCache.remove(sm);
                    if (sm.isDirty()) {
                        newTransCache.addDirty(sm);
                        continue;
                    }
                    newTransCache.addClean(sm);
                }
                itr = oldTransCache.iterator();
                while (itr.hasNext()) {
                    sm = (StateManagerImpl)itr.next();
                    sm.rollback();
                    this.removeFromTransaction(sm);
                }
                oldTransCache.clear();
                this._transCache = newTransCache;
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0 || (this._flags & 0x80) != 0) {
                return;
            }
            if (!this._conf.supportedOptions().contains("openjpa.option.IncrementalFlush")) {
                throw new UnsupportedException(_loc.get("incremental-flush-not-supported"));
            }
            if (this._savepoints != null && !this._savepoints.isEmpty() && !this._spm.supportsIncrementalFlush()) {
                throw new UnsupportedException(_loc.get("savepoint-flush-not-supported"));
            }
            try {
                this.flushSafe(0);
                this._flags |= 0x100;
            }
            catch (OpenJPAException ke) {
                this.setRollbackOnly(ke);
                throw ke.setFatal(true);
            }
            catch (RuntimeException re) {
                this.setRollbackOnly(re);
                throw new StoreException(re).setFatal(true);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preFlush() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) != 0) {
                this.flushSafe(3);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateChanges() {
        this.beginOperation(true);
        try {
            if ((this._flags & 2) == 0) {
                return;
            }
            if ((this._flags & 4) != 0) {
                this.flush();
                return;
            }
            if (!this._conf.supportedOptions().contains("openjpa.option.IncrementalFlush")) {
                throw new UnsupportedException(_loc.get("incremental-flush-not-supported"));
            }
            try {
                this.flushSafe(2);
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new StoreException(re);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.beginOperation(true);
        try {
            boolean bl = (this._flags & 2) != 0;
            return bl;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStoreActive() {
        this.beginOperation(true);
        try {
            boolean bl = (this._flags & 4) != 0;
            return bl;
        }
        finally {
            this.endOperation();
        }
    }

    boolean isTransactionEnding() {
        return (this._flags & 0x1000) != 0;
    }

    public boolean beginOperation(boolean syncTrans) {
        this.lock();
        try {
            this.assertOpen();
            if (syncTrans && this._operationCount == 0 && this._syncManaged && (this._flags & 2) == 0) {
                this.syncWithManagedTransaction();
            }
            return this._operationCount++ == 1;
        }
        catch (OpenJPAException ke) {
            this.unlock();
            throw ke;
        }
        catch (RuntimeException re) {
            this.unlock();
            throw new GeneralException(re);
        }
    }

    public boolean endOperation() {
        try {
            if (this._operationCount == 1 && (this._autoDetach & 8) != 0 && (this._flags & 2) == 0) {
                this.detachAllInternal(null);
            }
            if (this._operationCount < 1) {
                throw new InternalException(_loc.get("multi-threaded-access"));
            }
            boolean bl = this._operationCount == 1;
            return bl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            --this._operationCount;
            if (this._operationCount == 0) {
                this._operating.clear();
            }
            this.unlock();
        }
    }

    public Synchronization getSynchronization() {
        return this._sync;
    }

    public void setSynchronization(Synchronization sync) {
        this.assertOpen();
        this._sync = sync;
    }

    public void beforeCompletion() {
        this.beginOperation(false);
        try {
            if (this._sync != null) {
                this._sync.beforeCompletion();
            }
            this.flushSafe(1);
        }
        catch (OpenJPAException ke) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)ke);
            }
            throw this.translateManagedCompletionException(ke);
        }
        catch (RuntimeException re) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)re);
            }
            throw this.translateManagedCompletionException(new StoreException(re));
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(int status) {
        block12: {
            this.beginOperation(false);
            try {
                this.assertActiveTransaction();
                this._flags |= 0x1000;
                this.endTransaction(status);
                if (this._sync != null) {
                    this._sync.afterCompletion(status);
                }
                if ((this._autoDetach & 4) != 0) {
                    this.detachAllInternal(null);
                } else if (status == 4 && (this._autoDetach & 0x10) != 0) {
                    this.detachAllInternal(null);
                }
                if ((this._flags & 8) != 0 && this._compat.getCloseOnManagedCommit()) {
                    this.free();
                }
                this._flags &= 0xFFFFFFFD;
                this._flags &= 0xFFFFFEFF;
                this._flags &= 0xFFFFEFFF;
                if (this._transEventManager == null) break block12;
            }
            catch (OpenJPAException ke) {
                try {
                    if (!this._log.isTraceEnabled()) throw this.translateManagedCompletionException(ke);
                    this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)ke);
                    throw this.translateManagedCompletionException(ke);
                    catch (RuntimeException re) {
                        if (!this._log.isTraceEnabled()) throw this.translateManagedCompletionException(new StoreException(re));
                        this._log.trace((Object)_loc.get("end-trans-error"), (Throwable)re);
                        throw this.translateManagedCompletionException(new StoreException(re));
                    }
                }
                catch (Throwable throwable) {
                    this._flags &= 0xFFFFFFFD;
                    this._flags &= 0xFFFFFEFF;
                    this._flags &= 0xFFFFEFFF;
                    if (this._transEventManager != null && this._transEventManager.hasEndListeners()) {
                        this.fireTransactionEvent(new TransactionEvent(this, status == 3 ? 7 : 8, null, null, null, null));
                    }
                    this.endOperation();
                    throw throwable;
                }
            }
            if (this._transEventManager.hasEndListeners()) {
                this.fireTransactionEvent(new TransactionEvent(this, status == 3 ? 7 : 8, null, null, null, null));
            }
        }
        this.endOperation();
    }

    private RuntimeException translateManagedCompletionException(RuntimeException re) {
        return !this._managed || this._extrans == null ? re : this._extrans.translate(re);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSafe(int reason) {
        if ((this._flags & 0x40) != 0) {
            throw new InvalidStateException(_loc.get("reentrant-flush"));
        }
        this._flags |= 0x40;
        try {
            this.flush(reason);
        }
        finally {
            this._flags &= 0xFFFFFFBF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(int reason) {
        List exceps;
        ManagedObjectCollection mobjs;
        boolean flush;
        block31: {
            Iterator itr3;
            boolean listeners;
            Collection transactional = this.getTransactionalStates();
            flush = (this._flags & 0x200) != 0;
            boolean bl = listeners = !(!this._transEventManager.hasFlushListeners() && !this._transEventManager.hasEndListeners() || (this._flags & 0x400) != 0 && this._transEventManager.getListeners().size() <= 1);
            if (!(flush || reason == 1 && listeners)) {
                return;
            }
            mobjs = null;
            this._flags |= 0x10;
            try {
                Iterator itr2;
                if (flush) {
                    itr2 = transactional.iterator();
                    while (itr2.hasNext()) {
                        ((StateManagerImpl)itr2.next()).beforeFlush(reason, this._call);
                    }
                    this.flushAdditions(transactional, reason);
                }
                this._flags |= 0x20;
                if (flush && this._derefCache != null && !this._derefCache.isEmpty()) {
                    itr2 = this._derefCache.iterator();
                    while (itr2.hasNext()) {
                        this.deleteDeref((StateManagerImpl)itr2.next());
                    }
                    this.flushAdditions(transactional, reason);
                }
                if (reason != 3) {
                    if ((this._flags & 4) == 0) {
                        this.beginStoreManagerTransaction(false);
                    }
                    if ((this._transEventManager.hasFlushListeners() || this._transEventManager.hasEndListeners()) && (flush || reason == 1)) {
                        mobjs = new ManagedObjectCollection(transactional);
                        if (reason == 1 && this._transEventManager.hasEndListeners()) {
                            this.fireTransactionEvent(new TransactionEvent(this, 3, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
                            this.flushAdditions(transactional, reason);
                            boolean bl2 = flush = (this._flags & 0x200) != 0;
                        }
                        if (flush && this._transEventManager.hasFlushListeners()) {
                            this.fireTransactionEvent(new TransactionEvent(this, 1, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
                            this.flushAdditions(transactional, reason);
                        }
                    }
                }
            }
            finally {
                this._flags &= 0xFFFFFFEF;
                this._flags &= 0xFFFFFFDF;
                this._transAdditions = null;
                this._derefAdditions = null;
                if (this._derefCache != null) {
                    this._derefCache.clear();
                }
            }
            exceps = null;
            try {
                if (flush && reason != 3) {
                    this._flags |= 0x80;
                    exceps = this.add(exceps, this.newFlushException(this._store.flush(transactional)));
                }
                Object var9_8 = null;
                this._flags &= 0xFFFFFF7F;
                if (reason == 2) {
                    exceps = this.add(exceps, this.endStoreManagerTransaction(true));
                } else if (reason != 3) {
                    this._flags &= 0xFFFFFDFF;
                }
                if (!flush) break block31;
                itr3 = transactional.iterator();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this._flags &= 0xFFFFFF7F;
                if (reason == 2) {
                    exceps = this.add(exceps, this.endStoreManagerTransaction(true));
                } else if (reason != 3) {
                    this._flags &= 0xFFFFFDFF;
                }
                if (flush) {
                    Iterator itr3 = transactional.iterator();
                    while (itr3.hasNext()) {
                        StateManagerImpl sm = (StateManagerImpl)itr3.next();
                        try {
                            if (sm.getPCState() == PCState.TRANSIENT) continue;
                            sm.afterFlush(reason);
                            if (reason != 0) continue;
                            sm.proxyFields(true, false);
                            this._transCache.flushed(sm);
                        }
                        catch (Exception e) {
                            exceps = this.add(exceps, e);
                        }
                    }
                }
                throw throwable;
            }
            while (itr3.hasNext()) {
                StateManagerImpl sm = (StateManagerImpl)itr3.next();
                try {
                    if (sm.getPCState() == PCState.TRANSIENT) continue;
                    sm.afterFlush(reason);
                    if (reason != 0) continue;
                    sm.proxyFields(true, false);
                    this._transCache.flushed(sm);
                }
                catch (Exception e) {
                    exceps = this.add(exceps, e);
                }
            }
        }
        this.throwNestedExceptions(exceps, true);
        if (flush && reason != 2 && reason != 3 && this._transEventManager.hasFlushListeners()) {
            this.fireTransactionEvent(new TransactionEvent(this, 2, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
        }
    }

    private void flushAdditions(Collection transactional, int reason) {
        boolean loop;
        while (loop = this.flushTransAdditions(transactional, reason) | this.deleteDerefAdditions(this._derefCache)) {
        }
    }

    private boolean flushTransAdditions(Collection transactional, int reason) {
        if (this._transAdditions == null || this._transAdditions.isEmpty()) {
            return false;
        }
        transactional.addAll(this._transAdditions);
        StateManagerImpl[] states = this._transAdditions.toArray(new StateManagerImpl[this._transAdditions.size()]);
        this._transAdditions.clear();
        for (int i = 0; i < states.length; ++i) {
            states[i].beforeFlush(reason, this._call);
        }
        return true;
    }

    private boolean deleteDerefAdditions(Collection derefs) {
        if (this._derefAdditions == null || this._derefAdditions.isEmpty()) {
            return false;
        }
        derefs.addAll(this._derefAdditions);
        StateManagerImpl[] states = this._derefAdditions.toArray(new StateManagerImpl[this._derefAdditions.size()]);
        this._derefAdditions.clear();
        for (int i = 0; i < states.length; ++i) {
            this.deleteDeref(states[i]);
        }
        return true;
    }

    private void deleteDeref(StateManagerImpl sm) {
        int action = this.processArgument(1, sm.getManagedInstance(), sm, null);
        if ((action & 4) != 0) {
            sm.delete();
        }
        if ((action & 2) != 0) {
            sm.cascadeDelete(this._call);
        }
    }

    private int processArgument(int op, Object obj, OpenJPAStateManager sm, OpCallbacks call) {
        if (call != null) {
            return call.processArgument(op, obj, sm);
        }
        if (this._call != null) {
            return this._call.processArgument(op, obj, sm);
        }
        return 6;
    }

    private OpenJPAException newFlushException(Collection exceps) {
        if (exceps == null || exceps.isEmpty()) {
            return null;
        }
        Throwable[] t = exceps.toArray(new Throwable[exceps.size()]);
        ArrayList<Object> failed = new ArrayList<Object>(t.length);
        boolean opt = true;
        for (int i = 0; opt && i < t.length; ++i) {
            Object f;
            opt = t[i] instanceof OptimisticException;
            if (!opt || (f = ((OptimisticException)t[i]).getFailedObject()) == null) continue;
            failed.add(f);
        }
        if (opt && !failed.isEmpty()) {
            return new OptimisticException(failed, t);
        }
        if (opt) {
            return new OptimisticException(t);
        }
        return new StoreException(_loc.get("rolled-back")).setNestedThrowables(t).setFatal(true);
    }

    protected void endTransaction(int status) {
        boolean rollback = status != 3;
        List exceps = null;
        try {
            exceps = this.add(exceps, this.endStoreManagerTransaction(rollback));
        }
        catch (RuntimeException re) {
            rollback = true;
            exceps = this.add(exceps, re);
        }
        this._fc.setReadLockLevel(0);
        this._fc.setWriteLockLevel(0);
        this._fc.setLockTimeout(-1);
        Collection transStates = this.hasTransactionalObjects() ? this._transCache : Collections.EMPTY_LIST;
        ManagedObjectCollection mobjs = null;
        if (this._transEventManager.hasEndListeners()) {
            mobjs = new ManagedObjectCollection(transStates);
            int eventType = rollback ? 5 : 4;
            this.fireTransactionEvent(new TransactionEvent(this, eventType, mobjs, this._persistedClss, this._updatedClss, this._deletedClss));
        }
        this._transCache = null;
        if (this._persistedClss != null) {
            this._persistedClss.clear();
        }
        if (this._updatedClss != null) {
            this._updatedClss.clear();
        }
        if (this._deletedClss != null) {
            this._deletedClss.clear();
        }
        this._cache.clearNew();
        if (this._derefCache != null && !this._derefCache.isEmpty()) {
            Iterator itr = this._derefCache.iterator();
            while (itr.hasNext()) {
                ((StateManagerImpl)itr.next()).setDereferencedDependent(false, false);
            }
            this._derefCache.clear();
        }
        Iterator itr = transStates.iterator();
        while (itr.hasNext()) {
            StateManagerImpl sm = (StateManagerImpl)itr.next();
            try {
                if (rollback) {
                    sm.setDereferencedDependent(false, false);
                    sm.rollback();
                    continue;
                }
                sm.commit();
            }
            catch (RuntimeException re) {
                exceps = this.add(exceps, re);
            }
        }
        this._lm.endTransaction();
        while (this._savepoints != null && this._savepoints.size() > 0) {
            OpenJPASavepoint save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
            save.release(false);
        }
        this._savepoints = null;
        this._savepointCache = null;
        if (this._transEventManager.hasEndListeners()) {
            this.fireTransactionEvent(new TransactionEvent(this, 6, mobjs, null, null, null));
        }
        if (transStates != Collections.EMPTY_LIST) {
            this._transCache = (TransactionalCache)transStates;
            this._transCache.clear();
        }
        this.throwNestedExceptions(exceps, true);
    }

    public void persist(Object obj, OpCallbacks call) {
        this.persist(obj, null, true, call);
    }

    public OpenJPAStateManager persist(Object obj, Object id, OpCallbacks call) {
        return this.persist(obj, id, true, call);
    }

    public void persistAll(Collection objs, OpCallbacks call) {
        this.persistAll(objs, true, call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAll(Collection objs, boolean explicit, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        this.beginOperation(true);
        List exceps = null;
        try {
            this.assertWriteOperation();
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.persist(itr.next(), explicit, call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
        }
        finally {
            this.endOperation();
        }
        this.throwNestedExceptions(exceps, false);
    }

    private List add(List l, Object o) {
        if (o == null) {
            return l;
        }
        if (l == null) {
            l = new LinkedList<Object>();
        }
        l.add(o);
        return l;
    }

    private void throwNestedExceptions(List exceps, boolean datastore) {
        if (exceps == null || exceps.isEmpty()) {
            return;
        }
        if (datastore && exceps.size() == 1) {
            throw (RuntimeException)exceps.get(0);
        }
        boolean fatal = false;
        Throwable[] t = exceps.toArray(new Throwable[exceps.size()]);
        for (int i = 0; i < t.length; ++i) {
            if (!(t[i] instanceof OpenJPAException) || !((OpenJPAException)t[i]).isFatal()) continue;
            fatal = true;
        }
        OpenJPAException err = datastore ? new StoreException(_loc.get("nested-exceps")) : new UserException(_loc.get("nested-exceps"));
        throw err.setNestedThrowables(t).setFatal(fatal);
    }

    public void persist(Object obj, boolean explicit, OpCallbacks call) {
        this.persist(obj, null, explicit, call);
    }

    public OpenJPAStateManager persist(Object obj, Object id, boolean explicit, OpCallbacks call) {
        if (obj == null) {
            return null;
        }
        this.beginOperation(true);
        try {
            StateManagerImpl other;
            PersistenceCapable pc;
            this.assertWriteOperation();
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if (!this._operating.add(obj)) {
                StateManagerImpl stateManagerImpl = sm;
                return stateManagerImpl;
            }
            int action = this.processArgument(0, obj, sm, call);
            if (action == 0) {
                StateManagerImpl stateManagerImpl = sm;
                return stateManagerImpl;
            }
            if ((action & 4) == 0) {
                if (sm != null) {
                    sm.cascadePersist(call);
                } else {
                    this.cascadeTransient(0, obj, call, "persist");
                }
                StateManagerImpl stateManagerImpl = sm;
                return stateManagerImpl;
            }
            if (sm != null) {
                if (sm.isDetached()) {
                    throw new ObjectExistsException(_loc.get("persist-detached", (Object)Exceptions.toString(obj))).setFailedObject(obj);
                }
                if (!sm.isEmbedded()) {
                    sm.persist();
                    this._cache.persist(sm);
                    if ((action & 2) != 0) {
                        sm.cascadePersist(call);
                    }
                    StateManagerImpl stateManagerImpl = sm;
                    return stateManagerImpl;
                }
                sm.getOwner().dirty(sm.getOwnerMetaData().getFieldMetaData().getIndex());
                this._cache.persist(sm);
                pc = sm.getPersistenceCapable();
            } else {
                pc = this.assertPersistenceCapable(obj);
                if (pc.pcIsDetached() == Boolean.TRUE) {
                    throw new ObjectExistsException(_loc.get("persist-detached", (Object)Exceptions.toString(obj))).setFailedObject(obj);
                }
            }
            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
            this.fireLifecycleEvent(obj, null, meta, 0);
            if (id == null) {
                if (meta.getIdentityType() == 2) {
                    id = ApplicationIds.create(pc, meta);
                } else {
                    if (meta.getIdentityType() == 0) {
                        throw new UserException(_loc.get("meta-unknownid", (Object)meta));
                    }
                    id = StateManagerId.newInstance(this);
                }
            }
            if ((other = this.getStateManagerImplById(id, false)) != null && !other.isDeleted() && !other.isNew()) {
                throw new ObjectExistsException(_loc.get("cache-exists", (Object)obj.getClass().getName(), id)).setFailedObject(obj);
            }
            if (sm != null) {
                pc.pcReplaceStateManager(null);
            }
            sm = new StateManagerImpl(id, meta, this);
            if ((this._flags & 2) != 0) {
                if (explicit) {
                    sm.initialize(pc, PCState.PNEW);
                } else {
                    sm.initialize(pc, PCState.PNEWPROVISIONAL);
                }
            } else {
                sm.initialize(pc, PCState.PNONTRANSNEW);
            }
            if ((action & 2) != 0) {
                sm.cascadePersist(call);
            }
            StateManagerImpl stateManagerImpl = sm;
            return stateManagerImpl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cascadeTransient(int op, Object obj, OpCallbacks call, String errOp) {
        PersistenceCapable pc = this.assertPersistenceCapable(obj);
        if (pc.pcGetStateManager() != null) {
            throw this.newDetachedException(obj, errOp);
        }
        ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
        StateManagerImpl sm = new StateManagerImpl(StateManagerId.newInstance(this), meta, this);
        sm.initialize(pc, PCState.TLOADED);
        try {
            switch (op) {
                case 0: {
                    sm.cascadePersist(call);
                    return;
                }
                case 1: {
                    sm.cascadeDelete(call);
                    return;
                }
                case 2: {
                    sm.gatherCascadeRefresh(call);
                    return;
                }
                default: {
                    throw new InternalException(String.valueOf(op));
                }
            }
        }
        finally {
            sm.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(Collection objs, OpCallbacks call) {
        this.beginOperation(true);
        try {
            this.assertWriteOperation();
            List exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    Object obj = itr.next();
                    if (obj == null) continue;
                    this.delete(obj, this.getStateManagerImpl(obj, true), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            this.throwNestedExceptions(exceps, false);
        }
        finally {
            this.endOperation();
        }
    }

    public void delete(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertWriteOperation();
            this.delete(obj, this.getStateManagerImpl(obj, true), call);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    void delete(Object obj, StateManagerImpl sm, OpCallbacks call) {
        if (!this._operating.add(obj)) {
            return;
        }
        int action = this.processArgument(1, obj, sm, call);
        if (action == 0) {
            return;
        }
        if ((action & 4) == 0) {
            if (sm != null) {
                sm.cascadeDelete(call);
            } else {
                this.cascadeTransient(1, obj, call, "delete");
            }
            return;
        }
        if (sm != null) {
            if (sm.isDetached()) {
                throw this.newDetachedException(obj, "delete");
            }
            if ((action & 2) != 0) {
                sm.cascadeDelete(call);
            }
            sm.delete();
        } else if (this.assertPersistenceCapable(obj).pcIsDetached() == Boolean.TRUE) {
            throw this.newDetachedException(obj, "delete");
        }
    }

    private OpenJPAException newDetachedException(Object obj, String operation) {
        throw new UserException(_loc.get("bad-detached-op", (Object)operation, (Object)Exceptions.toString(obj))).setFailedObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll(Collection objs, OpCallbacks call) {
        this.beginOperation(false);
        try {
            List exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.release(itr.next(), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            this.throwNestedExceptions(exceps, false);
        }
        finally {
            this.endOperation();
        }
    }

    public void release(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(false);
        try {
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            int action = this.processArgument(4, obj, sm, call);
            if (sm == null) {
                return;
            }
            if ((action & 4) != 0 && sm.isPersistent()) {
                boolean pending = sm.isPendingTransactional();
                sm.release(true);
                if (pending) {
                    this.removeFromPendingTransaction(sm);
                }
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenJPAStateManager embed(Object obj, Object id, OpenJPAStateManager owner, ValueMetaData ownerMeta) {
        this.beginOperation(true);
        try {
            PCState state;
            PersistenceCapable copy;
            ClassMetaData meta;
            StateManagerImpl orig = this.getStateManagerImpl(obj, true);
            if (orig != null) {
                if (orig.getOwner() == owner && orig.getMetaData().getEmbeddingMetaData() == ownerMeta) {
                    StateManagerImpl stateManagerImpl = orig;
                    return stateManagerImpl;
                }
                orig.load(this._fc, 1, null, null, false);
            }
            if ((meta = ownerMeta.getEmbeddedMetaData()) == null) {
                throw new InternalException(_loc.get("bad-embed", (Object)ownerMeta));
            }
            if (id == null) {
                id = StateManagerId.newInstance(this);
            }
            StateManagerImpl sm = new StateManagerImpl(id, meta, this);
            sm.setOwner((StateManagerImpl)owner, ownerMeta);
            Class type = meta.getDescribedType();
            if (type.isInterface()) {
                type = meta.getInterfaceImpl();
            }
            if (obj != null) {
                PersistenceCapable pc;
                StateManagerImpl copySM;
                if (orig == null) {
                    copySM = sm;
                    pc = this.assertPersistenceCapable(obj);
                    pc.pcReplaceStateManager(sm);
                } else {
                    copySM = orig;
                    pc = orig.getPersistenceCapable();
                }
                try {
                    copy = PCRegistry.newInstance(type, copySM, false);
                    int[] fields = new int[meta.getFields().length];
                    for (int i = 0; i < fields.length; ++i) {
                        fields[i] = i;
                    }
                    copy.pcCopyFields(pc, fields);
                    state = PCState.ECOPY;
                    copy.pcReplaceStateManager(null);
                }
                finally {
                    if (orig == null) {
                        pc.pcReplaceStateManager(null);
                    }
                }
            } else {
                copy = PCRegistry.newInstance(type, sm, false);
                state = (this._flags & 2) != 0 && !this._optimistic ? PCState.ECLEAN : PCState.ENONTRANS;
            }
            sm.initialize(copy, state);
            StateManagerImpl stateManagerImpl = sm;
            return stateManagerImpl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenJPAStateManager copy(OpenJPAStateManager copy, PCState state) {
        this.beginOperation(true);
        try {
            this.assertOpen();
            Object oid = copy.fetchObjectId();
            Class<?> type = copy.getManagedInstance().getClass();
            if (oid == null) {
                throw new InternalException();
            }
            StateManagerImpl sm = null;
            if (!copy.isEmbedded()) {
                sm = this.getStateManagerImplById(oid, true);
            }
            if (sm == null) {
                MetaDataRepository repos = this._conf.getMetaDataRepositoryInstance();
                ClassMetaData meta = repos.getMetaData(type, this._loader, true);
                sm = new StateManagerImpl(oid, meta, this);
                sm.setObjectId(oid);
                sm.initialize(sm.getMetaData().getDescribedType(), state);
            }
            StateManagerImpl stateManagerImpl = sm;
            return stateManagerImpl;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAll(Collection objs, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertNontransactionalRead();
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                this.gatherCascadeRefresh(itr.next(), call);
            }
            if (this._operating.isEmpty()) {
                return;
            }
            if (this._operating.size() == 1) {
                this.refreshInternal(this._operating.iterator().next(), call);
            } else {
                this.refreshInternal(this._operating, call);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertNontransactionalRead();
            this.gatherCascadeRefresh(obj, call);
            if (this._operating.isEmpty()) {
                return;
            }
            if (this._operating.size() == 1) {
                this.refreshInternal(this._operating.iterator().next(), call);
            } else {
                this.refreshInternal(this._operating, call);
            }
        }
        finally {
            this.endOperation();
        }
    }

    void gatherCascadeRefresh(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        if (!this._operating.add(obj)) {
            return;
        }
        StateManagerImpl sm = this.getStateManagerImpl(obj, false);
        int action = this.processArgument(2, obj, sm, call);
        if ((action & 2) == 0) {
            return;
        }
        if (sm != null) {
            sm.gatherCascadeRefresh(call);
        } else {
            this.cascadeTransient(2, obj, call, "refresh");
        }
    }

    protected void refreshInternal(Collection objs, OpCallbacks call) {
        List exceps = null;
        try {
            StateManagerImpl sm;
            ArrayList<StateManagerImpl> load = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj == null) continue;
                try {
                    sm = this.getStateManagerImpl(obj, true);
                    if ((this.processArgument(2, obj, sm, call) & 4) == 0) continue;
                    if (sm != null) {
                        if (sm.isDetached()) {
                            throw this.newDetachedException(obj, "refresh");
                        }
                        if (!sm.beforeRefresh(true)) continue;
                        if (load == null) {
                            load = new ArrayList<StateManagerImpl>(objs.size());
                        }
                        load.add(sm);
                        continue;
                    }
                    if (this.assertPersistenceCapable(obj).pcIsDetached() != Boolean.TRUE) continue;
                    throw this.newDetachedException(obj, "refresh");
                }
                catch (OpenJPAException ke) {
                    exceps = this.add(exceps, ke);
                }
            }
            if (load != null) {
                Collection failed = this._store.loadAll(load, null, 3, this._fc, null);
                if (failed != null && !failed.isEmpty()) {
                    exceps = this.add(exceps, BrokerImpl.newObjectNotFoundException(failed));
                }
                Iterator itr2 = load.iterator();
                while (itr2.hasNext()) {
                    sm = (StateManagerImpl)itr2.next();
                    if (failed != null && failed.contains(sm.getId())) continue;
                    try {
                        sm.afterRefresh();
                        sm.load(this._fc, 0, null, null, false);
                    }
                    catch (OpenJPAException ke) {
                        exceps = this.add(exceps, ke);
                    }
                }
            }
            itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    sm = this.getStateManagerImpl(itr.next(), true);
                    if (sm == null || sm.isDetached()) continue;
                    this.fireLifecycleEvent(sm.getManagedInstance(), null, sm.getMetaData(), 17);
                }
                catch (OpenJPAException ke) {
                    exceps = this.add(exceps, ke);
                }
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        this.throwNestedExceptions(exceps, false);
    }

    protected void refreshInternal(Object obj, OpCallbacks call) {
        try {
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(2, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm != null) {
                if (sm.isDetached()) {
                    throw this.newDetachedException(obj, "refresh");
                }
                if (sm.beforeRefresh(false)) {
                    sm.load(this._fc, 0, null, null, false);
                    sm.afterRefresh();
                }
                this.fireLifecycleEvent(sm.getManagedInstance(), null, sm.getMetaData(), 17);
            } else if (this.assertPersistenceCapable(obj).pcIsDetached() == Boolean.TRUE) {
                throw this.newDetachedException(obj, "refresh");
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
    }

    public void retrieveAll(Collection objs, boolean dfgOnly, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.retrieve(objs.iterator().next(), dfgOnly, call);
            return;
        }
        List exceps = null;
        this.beginOperation(true);
        try {
            StateManagerImpl sm;
            this.assertOpen();
            this.assertNontransactionalRead();
            ArrayList<StateManagerImpl> load = null;
            ArrayList<StateManagerImpl> sms = new ArrayList<StateManagerImpl>(objs.size());
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj == null) continue;
                try {
                    sm = this.getStateManagerImpl(obj, true);
                    if ((this.processArgument(3, obj, sm, call) & 4) == 0) continue;
                    if (sm != null) {
                        if (sm.isDetached()) {
                            throw this.newDetachedException(obj, "retrieve");
                        }
                        if (!sm.isPersistent()) continue;
                        sms.add(sm);
                        if (sm.getPCState() != PCState.HOLLOW) continue;
                        if (load == null) {
                            load = new ArrayList<StateManagerImpl>();
                        }
                        load.add(sm);
                        continue;
                    }
                    if (this.assertPersistenceCapable(obj).pcIsDetached() != Boolean.TRUE) continue;
                    throw this.newDetachedException(obj, "retrieve");
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            Collection failed = null;
            if (load != null) {
                int mode = dfgOnly ? 1 : 2;
                failed = this._store.loadAll(load, null, mode, this._fc, null);
                if (failed != null && !failed.isEmpty()) {
                    exceps = this.add(exceps, BrokerImpl.newObjectNotFoundException(failed));
                }
            }
            Iterator itr2 = sms.iterator();
            while (itr2.hasNext()) {
                sm = (StateManagerImpl)itr2.next();
                if (failed != null && failed.contains(sm.getId())) continue;
                int mode = dfgOnly ? 0 : 1;
                try {
                    sm.beforeRead(-1);
                    sm.load(this._fc, mode, null, null, false);
                }
                catch (OpenJPAException ke) {
                    exceps = this.add(exceps, ke);
                }
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
        this.throwNestedExceptions(exceps, false);
    }

    public void retrieve(Object obj, boolean dfgOnly, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertOpen();
            this.assertNontransactionalRead();
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(3, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm != null) {
                if (sm.isDetached()) {
                    throw this.newDetachedException(obj, "retrieve");
                }
                if (sm.isPersistent()) {
                    int mode = dfgOnly ? 0 : 1;
                    sm.beforeRead(-1);
                    sm.load(this._fc, mode, null, null, false);
                }
            } else if (this.assertPersistenceCapable(obj).pcIsDetached() == Boolean.TRUE) {
                throw this.newDetachedException(obj, "retrieve");
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll(OpCallbacks call) {
        this.beginOperation(false);
        try {
            Collection c = this.getManagedStates();
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                StateManagerImpl sm = (StateManagerImpl)itr.next();
                if (!sm.isPersistent() || sm.isDirty()) continue;
                this.evict(sm.getManagedInstance(), call);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll(Collection objs, OpCallbacks call) {
        List exceps = null;
        this.beginOperation(false);
        try {
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.evict(itr.next(), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
        }
        finally {
            this.endOperation();
        }
        this.throwNestedExceptions(exceps, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll(Extent extent, OpCallbacks call) {
        if (extent == null) {
            return;
        }
        this.beginOperation(false);
        try {
            Collection c = this.getManagedStates();
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Class cls;
                StateManagerImpl sm = (StateManagerImpl)itr.next();
                if (!sm.isPersistent() || sm.isDirty() || (cls = sm.getMetaData().getDescribedType()) != extent.getElementType() && (!extent.hasSubclasses() || !extent.getElementType().isAssignableFrom(cls))) continue;
                this.evict(sm.getManagedInstance(), call);
            }
        }
        finally {
            this.endOperation();
        }
    }

    public void evict(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(false);
        try {
            DataCache cache;
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(5, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm == null) {
                return;
            }
            sm.evict();
            if (this._evictDataCache && sm.getObjectId() != null && (cache = sm.getMetaData().getDataCache()) != null) {
                cache.remove(sm.getObjectId());
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public Object detach(Object obj, OpCallbacks call) {
        if (obj == null) {
            return null;
        }
        if (call == null) {
            call = this._call;
        }
        this.beginOperation(true);
        try {
            Object object = new DetachManager(this, false, call).detach(obj);
            return object;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public Object[] detachAll(Collection objs, OpCallbacks call) {
        if (objs == null) {
            return null;
        }
        if (objs.isEmpty()) {
            return EMPTY_OBJECTS;
        }
        if (call == null) {
            call = this._call;
        }
        this.beginOperation(true);
        try {
            Object[] objectArray = new DetachManager(this, false, call).detachAll(objs);
            return objectArray;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public void detachAll(OpCallbacks call) {
        this.detachAll(call, true);
    }

    public void detachAll(OpCallbacks call, boolean flush) {
        this.beginOperation(true);
        try {
            if (flush && (this._flags & 0x200) != 0) {
                this.flush();
            }
            this.detachAllInternal(call);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    private void detachAllInternal(OpCallbacks call) {
        Collection states = this.getManagedStates();
        Iterator itr = states.iterator();
        while (itr.hasNext()) {
            StateManagerImpl sm = (StateManagerImpl)itr.next();
            if (!sm.isPersistent()) {
                itr.remove();
                continue;
            }
            if (sm.getMetaData().isDetachable()) continue;
            sm.release(true);
            itr.remove();
        }
        if (states.isEmpty()) {
            return;
        }
        if (call == null) {
            call = this._call;
        }
        new DetachManager(this, true, call).detachAll(new ManagedObjectCollection(states));
    }

    /*
     * Exception decompiling
     */
    public Object attach(Object obj, boolean copyNew, OpCallbacks call) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Object[] attachAll(Collection objs, boolean copyNew, OpCallbacks call) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nontransactionalAll(Collection objs, OpCallbacks call) {
        this.beginOperation(true);
        try {
            List exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                try {
                    this.nontransactional(itr.next(), call);
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            this.throwNestedExceptions(exceps, false);
        }
        finally {
            this.endOperation();
        }
    }

    public void nontransactional(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(8, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm != null) {
                sm.nontransactional();
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public void transactionalAll(Collection objs, boolean updateVersion, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.transactional(objs.iterator().next(), updateVersion, call);
            return;
        }
        this.beginOperation(true);
        try {
            ArrayList<StateManagerImpl> load = null;
            ArrayList<StateManagerImpl> sms = new ArrayList<StateManagerImpl>(objs.size());
            List exceps = null;
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj == null) continue;
                try {
                    StateManagerImpl sm = this.getStateManagerImpl(obj, true);
                    if ((this.processArgument(9, obj, sm, call) & 4) == 0) continue;
                    if (sm == null) {
                        ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
                        sm = new StateManagerImpl(StateManagerId.newInstance(this), meta, this);
                        sm.initialize(this.assertPersistenceCapable(obj), PCState.TCLEAN);
                        continue;
                    }
                    if (!sm.isPersistent()) continue;
                    this.assertActiveTransaction();
                    sms.add(sm);
                    if (sm.getPCState() == PCState.HOLLOW) {
                        if (load == null) {
                            load = new ArrayList<StateManagerImpl>();
                        }
                        load.add(sm);
                    }
                    sm.setCheckVersion(true);
                    if (updateVersion) {
                        sm.setUpdateVersion(true);
                    }
                    this._flags |= 0x200;
                }
                catch (UserException ue) {
                    exceps = this.add(exceps, ue);
                }
            }
            Collection failed = null;
            if (load != null) {
                failed = this._store.loadAll(load, null, 0, this._fc, null);
                if (failed != null && !failed.isEmpty()) {
                    exceps = this.add(exceps, BrokerImpl.newObjectNotFoundException(failed));
                }
            }
            this.transactionalStatesAll(sms, failed, exceps);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public void transactional(Object obj, boolean updateVersion, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(9, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm != null && sm.isPersistent()) {
                this.assertActiveTransaction();
                sm.transactional();
                sm.load(this._fc, 0, null, null, false);
                sm.setCheckVersion(true);
                if (updateVersion) {
                    sm.setUpdateVersion(true);
                }
                this._flags |= 0x200;
            } else if (sm == null) {
                ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(obj.getClass(), this._loader, true);
                StateManagerId id = StateManagerId.newInstance(this);
                sm = new StateManagerImpl(id, meta, this);
                sm.initialize(this.assertPersistenceCapable(obj), PCState.TCLEAN);
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    private void transactionalStatesAll(Collection sms, Collection failed, List exceps) {
        Iterator itr = sms.iterator();
        while (itr.hasNext()) {
            StateManagerImpl sm = (StateManagerImpl)itr.next();
            if (failed != null && failed.contains(sm.getId())) continue;
            try {
                sm.transactional();
                sm.load(this._fc, 0, null, null, false);
            }
            catch (OpenJPAException ke) {
                exceps = this.add(exceps, ke);
            }
        }
        this.throwNestedExceptions(exceps, false);
    }

    public Extent newExtent(Class type, boolean subclasses) {
        return this.newExtent(type, subclasses, null);
    }

    private Extent newExtent(Class type, boolean subclasses, FetchConfiguration fetch) {
        this.beginOperation(true);
        try {
            ExtentImpl extent = new ExtentImpl(this, type, subclasses, fetch);
            if (this._extents == null) {
                this._extents = new ReferenceHashSet(2);
            }
            this._extents.add((Object)extent);
            ExtentImpl extentImpl = extent;
            return extentImpl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public Iterator extentIterator(Class type, boolean subclasses, FetchConfiguration fetch, boolean ignoreChanges) {
        Extent extent = this.newExtent(type, subclasses, fetch);
        extent.setIgnoreChanges(ignoreChanges);
        return extent.iterator();
    }

    public Query newQuery(String lang, Class cls, Object query) {
        Query q = this.newQuery(lang, query);
        q.setCandidateType(cls, true);
        return q;
    }

    public Query newQuery(String lang, Object query) {
        if (query instanceof Extent || query instanceof Class) {
            throw new UserException(_loc.get("bad-new-query"));
        }
        this.beginOperation(false);
        try {
            StoreQuery sq = this._store.newQuery(lang);
            if (sq == null) {
                ExpressionParser ep = QueryLanguages.parserForLanguage(lang);
                if (ep != null) {
                    sq = new ExpressionStoreQuery(ep);
                } else if ("openjpa.MethodQL".equals(lang)) {
                    sq = new MethodStoreQuery();
                } else {
                    throw new UnsupportedException(lang);
                }
            }
            QueryImpl q = this.newQueryImpl(lang, sq);
            q.setIgnoreChanges(this._ignoreChanges);
            if (query != null) {
                q.setQuery(query);
            }
            if (this._queries == null) {
                this._queries = new ReferenceHashSet(2);
            }
            this._queries.add((Object)q);
            QueryImpl queryImpl = q;
            return queryImpl;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    protected QueryImpl newQueryImpl(String lang, StoreQuery sq) {
        return new QueryImpl(this, lang, sq);
    }

    public Seq getIdentitySequence(ClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        return this.getSequence(meta, null);
    }

    public Seq getValueSequence(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        return this.getSequence(fmd.getDefiningMetaData(), fmd);
    }

    private Seq getSequence(ClassMetaData meta, FieldMetaData fmd) {
        int strategy = fmd == null ? meta.getIdentityStrategy() : fmd.getValueStrategy();
        switch (strategy) {
            case 6: {
                return UUIDHexSeq.getInstance();
            }
            case 5: {
                return UUIDStringSeq.getInstance();
            }
            case 2: {
                SequenceMetaData smd = fmd == null ? meta.getIdentitySequenceMetaData() : fmd.getValueSequenceMetaData();
                return smd.getInstance(this._loader);
            }
        }
        if (fmd == null) {
            return this._store.getDataStoreIdSequence(meta);
        }
        return this._store.getValueSequence(fmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object obj, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.lock(obj, this._fc.getWriteLockLevel(), this._fc.getLockTimeout(), call);
        }
        finally {
            this.endOperation();
        }
    }

    public void lock(Object obj, int level, int timeout, OpCallbacks call) {
        if (obj == null) {
            return;
        }
        this.beginOperation(true);
        try {
            this.assertActiveTransaction();
            StateManagerImpl sm = this.getStateManagerImpl(obj, true);
            if ((this.processArgument(10, obj, sm, call) & 4) == 0) {
                return;
            }
            if (sm == null || !sm.isPersistent()) {
                return;
            }
            this._lm.lock(sm, level, timeout, null);
            sm.readLocked(level, level);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAll(Collection objs, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        this.beginOperation(true);
        try {
            this.lockAll(objs, this._fc.getWriteLockLevel(), this._fc.getLockTimeout(), call);
        }
        finally {
            this.endOperation();
        }
    }

    public void lockAll(Collection objs, int level, int timeout, OpCallbacks call) {
        if (objs.isEmpty()) {
            return;
        }
        if (objs.size() == 1) {
            this.lock(objs.iterator().next(), level, timeout, call);
            return;
        }
        this.beginOperation(true);
        try {
            this.assertActiveTransaction();
            ArrayList<StateManagerImpl> sms = new ArrayList<StateManagerImpl>(objs.size());
            Iterator itr = objs.iterator();
            while (itr.hasNext()) {
                StateManagerImpl sm;
                Object obj = itr.next();
                if (obj == null || (this.processArgument(10, obj, sm = this.getStateManagerImpl(obj, true), call) & 4) == 0 || sm == null || !sm.isPersistent()) continue;
                sms.add(sm);
            }
            this._lm.lockAll(sms, level, timeout, null);
            itr = sms.iterator();
            while (itr.hasNext()) {
                ((StateManagerImpl)itr.next()).readLocked(level, level);
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.endOperation();
        }
    }

    public boolean cancelAll() {
        this.assertOpen();
        try {
            if ((this._flags & 0x80) != 0) {
                this.setRollbackOnlyInternal(new UserException());
            }
            return this._store.cancelAll();
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new StoreException(re);
        }
    }

    public Object getConnection() {
        this.assertOpen();
        if (!this._conf.supportedOptions().contains("openjpa.option.DataStoreConnection")) {
            throw new UnsupportedException(_loc.get("conn-not-supported"));
        }
        return this._store.getClientConnection();
    }

    public boolean hasConnection() {
        this.assertOpen();
        return (this._flags & 0x800) != 0;
    }

    private void retainConnection() {
        if ((this._flags & 0x800) == 0) {
            this._store.retainConnection();
            this._flags |= 0x800;
        }
    }

    private void releaseConnection() {
        if ((this._flags & 0x800) != 0) {
            this._store.releaseConnection();
            this._flags &= 0xFFFFF7FF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getManagedObjects() {
        this.beginOperation(false);
        try {
            ManagedObjectCollection managedObjectCollection = new ManagedObjectCollection(this.getManagedStates());
            return managedObjectCollection;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTransactionalObjects() {
        this.beginOperation(false);
        try {
            ManagedObjectCollection managedObjectCollection = new ManagedObjectCollection(this.getTransactionalStates());
            return managedObjectCollection;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getPendingTransactionalObjects() {
        this.beginOperation(false);
        try {
            ManagedObjectCollection managedObjectCollection = new ManagedObjectCollection(this.getPendingTransactionalStates());
            return managedObjectCollection;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDirtyObjects() {
        this.beginOperation(false);
        try {
            ManagedObjectCollection managedObjectCollection = new ManagedObjectCollection(this.getDirtyStates());
            return managedObjectCollection;
        }
        finally {
            this.endOperation();
        }
    }

    public boolean getOrderDirtyObjects() {
        return this._orderDirty;
    }

    public void setOrderDirtyObjects(boolean order) {
        this._orderDirty = order;
    }

    protected Collection getManagedStates() {
        return this._cache.copy();
    }

    protected Collection getTransactionalStates() {
        if (!this.hasTransactionalObjects()) {
            return Collections.EMPTY_LIST;
        }
        return this._transCache.copy();
    }

    private boolean hasTransactionalObjects() {
        this._cache.dirtyCheck();
        return this._transCache != null;
    }

    protected Collection getDirtyStates() {
        if (!this.hasTransactionalObjects()) {
            return Collections.EMPTY_LIST;
        }
        return this._transCache.copyDirty();
    }

    protected Collection getPendingTransactionalStates() {
        if (this._pending == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this._pending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setStateManager(Object id, StateManagerImpl sm, int status) {
        this.lock();
        try {
            switch (status) {
                case 0: {
                    this._cache.add(sm);
                    return;
                }
                case 1: {
                    this._cache.remove(id, sm);
                    return;
                }
                case 2: {
                    this._cache.assignObjectId(id, sm);
                    return;
                }
                case 3: {
                    this._cache.commitNew(id, sm);
                    return;
                }
                default: {
                    throw new InternalException();
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTransaction(StateManagerImpl sm) {
        if (sm.isDirty()) {
            return;
        }
        this.lock();
        try {
            if (!this.hasTransactionalObjects()) {
                this._transCache = new TransactionalCache(this._orderDirty);
            }
            this._transCache.addClean(sm);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromTransaction(StateManagerImpl sm) {
        this.lock();
        try {
            if (this._transCache != null) {
                this._transCache.remove(sm);
            }
            if (this._derefCache != null && !sm.isPersistent()) {
                this._derefCache.remove(sm);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDirty(StateManagerImpl sm, boolean firstDirty) {
        if (sm.isPersistent()) {
            this._flags |= 0x200;
        }
        if (this._savepoints != null && !this._savepoints.isEmpty()) {
            if (this._savepointCache == null) {
                this._savepointCache = new HashSet();
            }
            this._savepointCache.add(sm);
        }
        if (firstDirty && sm.isTransactional()) {
            this.lock();
            try {
                if (!this.hasTransactionalObjects()) {
                    this._transCache = new TransactionalCache(this._orderDirty);
                }
                this._transCache.addDirty(sm);
                if (sm.isNew()) {
                    if (this._persistedClss == null) {
                        this._persistedClss = new HashSet();
                    }
                    this._persistedClss.add(sm.getMetaData().getDescribedType());
                } else if (sm.isDeleted()) {
                    if (this._deletedClss == null) {
                        this._deletedClss = new HashSet();
                    }
                    this._deletedClss.add(sm.getMetaData().getDescribedType());
                } else {
                    if (this._updatedClss == null) {
                        this._updatedClss = new HashSet();
                    }
                    this._updatedClss.add(sm.getMetaData().getDescribedType());
                }
                if ((this._flags & 0x10) != 0) {
                    if (this._transAdditions == null) {
                        this._transAdditions = new HashSet();
                    }
                    this._transAdditions.add(sm);
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPendingTransaction(StateManagerImpl sm) {
        this.lock();
        try {
            if (this._pending == null) {
                this._pending = new HashSet();
            }
            this._pending.add(sm);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromPendingTransaction(StateManagerImpl sm) {
        this.lock();
        try {
            if (this._pending != null) {
                this._pending.remove(sm);
            }
            if (this._derefCache != null && !sm.isPersistent()) {
                this._derefCache.remove(sm);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDereferencedDependent(StateManagerImpl sm) {
        this.lock();
        try {
            if ((this._flags & 0x20) != 0) {
                if (this._derefAdditions == null) {
                    this._derefAdditions = new HashSet();
                }
                this._derefAdditions.add(sm);
            } else {
                if (this._derefCache == null) {
                    this._derefCache = new HashSet();
                }
                this._derefCache.add(sm);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDereferencedDependent(StateManagerImpl sm) {
        this.lock();
        try {
            boolean removed = false;
            if (this._derefAdditions != null) {
                removed = this._derefAdditions.remove(sm);
            }
            if (!(removed || this._derefCache != null && this._derefCache.remove(sm))) {
                throw new InvalidStateException(_loc.get("not-derefed", (Object)Exceptions.toString(sm.getManagedInstance()))).setFailedObject(sm.getManagedInstance()).setFatal(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirtyType(Class cls) {
        if (cls == null) {
            return;
        }
        this.beginOperation(false);
        try {
            if (this._updatedClss == null) {
                this._updatedClss = new HashSet();
            }
            this._updatedClss.add(cls);
        }
        finally {
            this.endOperation();
        }
    }

    public Collection getPersistedTypes() {
        if (this._persistedClss == null || this._persistedClss.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._persistedClss);
    }

    public Collection getUpdatedTypes() {
        if (this._updatedClss == null || this._updatedClss.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._updatedClss);
    }

    public Collection getDeletedTypes() {
        if (this._deletedClss == null || this._deletedClss.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._deletedClss);
    }

    public boolean isClosed() {
        return this._closed;
    }

    public boolean isCloseInvoked() {
        return this._closed || (this._flags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.beginOperation(false);
        try {
            if (!this._managed && (this._flags & 2) != 0) {
                throw new InvalidStateException(_loc.get("active"));
            }
            this._flags |= 8;
            if ((this._flags & 2) == 0) {
                this.free();
            }
        }
        finally {
            this.endOperation();
        }
    }

    protected void free() {
        RuntimeException err = null;
        if ((this._autoDetach & 2) != 0) {
            try {
                this.detachAllInternal(this._call);
            }
            catch (RuntimeException re) {
                err = re;
            }
        }
        this._sync = null;
        this._userObjects = null;
        this._cache.clear();
        this._transCache = null;
        this._persistedClss = null;
        this._updatedClss = null;
        this._deletedClss = null;
        this._derefCache = null;
        this._pending = null;
        this._loader = null;
        this._transEventManager = null;
        this._lifeEventManager = null;
        while (this._savepoints != null && !this._savepoints.isEmpty()) {
            OpenJPASavepoint save = (OpenJPASavepoint)this._savepoints.remove(this._savepoints.size() - 1);
            save.release(false);
        }
        this._savepoints = null;
        this._savepointCache = null;
        if (this._queries != null) {
            Iterator itr = this._queries.iterator();
            while (itr.hasNext()) {
                try {
                    ((Query)itr.next()).closeResources();
                }
                catch (RuntimeException re) {}
            }
            this._queries = null;
        }
        if (this._extents != null) {
            Iterator itr = this._extents.iterator();
            while (itr.hasNext()) {
                Extent e = (Extent)itr.next();
                try {
                    e.closeAll();
                }
                catch (RuntimeException re) {}
            }
            this._extents = null;
        }
        try {
            this.releaseConnection();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this._lm.close();
        this._store.close();
        this._flags = 0;
        this._closed = true;
        if (this._log.isTraceEnabled()) {
            this._closedException = new IllegalStateException();
        }
        if (err != null) {
            throw err;
        }
    }

    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    public void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    public Object newInstance(Class cls) {
        this.assertOpen();
        if (cls.isInterface()) {
            ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(cls, this._loader, true);
            cls = meta.getInterfaceImpl();
        } else if (Modifier.isAbstract(cls.getModifiers())) {
            throw new UnsupportedOperationException(_loc.get("new-abstract", (Object)cls).getMessage());
        }
        if (!PCRegistry.isRegistered(cls)) {
            try {
                Class.forName(cls.getName(), true, (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction((Class)cls)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return PCRegistry.newInstance(cls, null, false);
    }

    public Object getObjectId(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcFetchObjectId();
        }
        return null;
    }

    public int getLockLevel(Object o) {
        this.assertOpen();
        if (o == null) {
            return 0;
        }
        OpenJPAStateManager sm = this.getStateManager(o);
        if (sm == null) {
            return 0;
        }
        return this.getLockManager().getLockLevel(sm);
    }

    public Object getVersion(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcGetVersion();
        }
        return null;
    }

    public boolean isDirty(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this._conf);
            return pc.pcIsDirty();
        }
        return false;
    }

    public boolean isTransactional(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsTransactional();
        }
        return false;
    }

    public boolean isPersistent(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsPersistent();
        }
        return false;
    }

    public boolean isNew(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsNew();
        }
        return false;
    }

    public boolean isDeleted(Object obj) {
        this.assertOpen();
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf).pcIsDeleted();
        }
        return false;
    }

    public boolean isDetached(Object obj) {
        if (!ImplHelper.isManageable(obj)) {
            return false;
        }
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this._conf);
        Boolean detached = pc.pcIsDetached();
        if (detached != null) {
            return detached;
        }
        ClassMetaData meta = this._conf.getMetaDataRepositoryInstance().getMetaData(ImplHelper.getManagedInstance(pc).getClass(), this._loader, true);
        Object oid = ApplicationIds.create(pc, meta);
        if (oid == null) {
            return false;
        }
        return this.find(oid, null, EXCLUDE_ALL, null, 0) != null;
    }

    public OpenJPAStateManager getStateManager(Object obj) {
        this.assertOpen();
        return this.getStateManagerImpl(obj, false);
    }

    protected StateManagerImpl getStateManagerImpl(Object obj, boolean assertThisContext) {
        if (ImplHelper.isManageable(obj)) {
            PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this._conf);
            if (pc.pcGetGenericContext() == this) {
                return (StateManagerImpl)pc.pcGetStateManager();
            }
            if (assertThisContext && pc.pcGetGenericContext() != null) {
                throw new UserException(_loc.get("not-managed", (Object)Exceptions.toString(obj))).setFailedObject(obj);
            }
        }
        return null;
    }

    protected StateManagerImpl getStateManagerImplById(Object oid, boolean allowNew) {
        return this._cache.getById(oid, allowNew);
    }

    protected PersistenceCapable assertPersistenceCapable(Object obj) {
        if (obj == null) {
            return null;
        }
        if (ImplHelper.isManageable(obj)) {
            return ImplHelper.toPersistenceCapable(obj, this._conf);
        }
        Class<?>[] intfs = obj.getClass().getInterfaces();
        for (int i = 0; intfs != null && i < intfs.length; ++i) {
            if (!intfs[i].getName().equals((class$org$apache$openjpa$enhance$PersistenceCapable == null ? BrokerImpl.class$("org.apache.openjpa.enhance.PersistenceCapable") : class$org$apache$openjpa$enhance$PersistenceCapable).getName())) continue;
            throw new UserException(_loc.get("pc-loader-different", (Object)Exceptions.toString(obj), (Object)((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction((Class)PersistenceCapable.class))), (Object)((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(intfs[i]))))).setFailedObject(obj);
        }
        throw new UserException(_loc.get("pc-cast", (Object)Exceptions.toString(obj))).setFailedObject(obj);
    }

    public void assertOpen() {
        if (this._closed) {
            if (this._closedException == null) {
                throw new InvalidStateException(_loc.get("closed-notrace")).setFatal(true);
            }
            throw new InvalidStateException(_loc.get("closed"), (Object)this._closedException).setFatal(true);
        }
    }

    public void assertActiveTransaction() {
        if ((this._flags & 2) == 0) {
            throw new NoTransactionException(_loc.get("not-active"));
        }
    }

    private void assertTransactionOperation() {
        if ((this._flags & 2) == 0) {
            throw new InvalidStateException(_loc.get("not-active"));
        }
    }

    public void assertNontransactionalRead() {
        if ((this._flags & 2) == 0 && !this._nontransRead) {
            throw new InvalidStateException(_loc.get("non-trans-read"));
        }
    }

    public void assertWriteOperation() {
        if (!((this._flags & 2) != 0 || this._nontransWrite && (this._autoDetach & 8) == 0)) {
            throw new NoTransactionException(_loc.get("write-operation"));
        }
    }

    private static ObjectNotFoundException newObjectNotFoundException(Collection failed) {
        Throwable[] t = new Throwable[failed.size()];
        int idx = 0;
        Iterator itr = failed.iterator();
        while (itr.hasNext()) {
            t[idx] = new ObjectNotFoundException(itr.next());
            ++idx;
        }
        return new ObjectNotFoundException(failed, t);
    }

    public Object processArgument(Object oid) {
        return oid;
    }

    public Object processReturn(Object oid, OpenJPAStateManager sm) {
        return sm == null ? null : sm.getManagedInstance();
    }

    private static class ManagedObjectCollection
    extends AbstractCollection {
        private final Collection _states;

        public ManagedObjectCollection(Collection states) {
            this._states = states;
        }

        public Collection getStateManagers() {
            return this._states;
        }

        public int size() {
            return this._states.size();
        }

        public Iterator iterator() {
            return new Iterator(){
                private final Iterator _itr;
                {
                    this._itr = ManagedObjectCollection.this._states.iterator();
                }

                public boolean hasNext() {
                    return this._itr.hasNext();
                }

                public Object next() {
                    return ((OpenJPAStateManager)this._itr.next()).getManagedInstance();
                }

                public void remove() {
                    throw new UnsupportedException();
                }
            };
        }
    }

    private static class StateManagerId
    implements Serializable {
        public static final String STRING_PREFIX = "openjpasm:";
        private static long _generator = 0L;
        private final int _bhash;
        private final long _id;

        public static StateManagerId newInstance(Broker b) {
            return new StateManagerId(System.identityHashCode(b), _generator++);
        }

        private StateManagerId(int bhash, long id) {
            this._bhash = bhash;
            this._id = id;
        }

        public StateManagerId(String str) {
            str = str.substring(STRING_PREFIX.length());
            int idx = str.indexOf(58);
            this._bhash = Integer.parseInt(str.substring(0, idx));
            this._id = Long.parseLong(str.substring(idx + 1));
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof StateManagerId)) {
                return false;
            }
            StateManagerId sid = (StateManagerId)other;
            return this._bhash == sid._bhash && this._id == sid._id;
        }

        public int hashCode() {
            return (int)(this._id ^ this._id >>> 32);
        }

        public String toString() {
            return STRING_PREFIX + this._bhash + ":" + this._id;
        }
    }

    private static class TransactionalCache
    implements Set {
        private final boolean _orderDirty;
        private Set _dirty = null;
        private Set _clean = null;

        public TransactionalCache(boolean orderDirty) {
            this._orderDirty = orderDirty;
        }

        public Collection copy() {
            Iterator itr;
            if (this.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList copy = new ArrayList(this.size());
            if (this._dirty != null) {
                itr = this._dirty.iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            if (this._clean != null) {
                itr = this._clean.iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            return copy;
        }

        public Collection copyDirty() {
            if (this._dirty == null || this._dirty.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return new ArrayList(this._dirty);
        }

        public void flushed(StateManagerImpl sm) {
            if (sm.isDirty() && this._dirty != null && this._dirty.remove(sm)) {
                this.addCleanInternal(sm);
            }
        }

        public void addClean(StateManagerImpl sm) {
            if (this.addCleanInternal(sm) && this._dirty != null) {
                this._dirty.remove(sm);
            }
        }

        private boolean addCleanInternal(StateManagerImpl sm) {
            if (this._clean == null) {
                this._clean = new ReferenceHashSet(1);
            }
            return this._clean.add(sm);
        }

        public void addDirty(StateManagerImpl sm) {
            if (this._dirty == null) {
                this._dirty = this._orderDirty ? MapBackedSet.decorate((Map)new LinkedMap()) : new HashSet();
            }
            if (this._dirty.add(sm)) {
                this.removeCleanInternal(sm);
            }
        }

        public boolean remove(StateManagerImpl sm) {
            return this.removeCleanInternal(sm) || this._dirty != null && this._dirty.remove(sm);
        }

        private boolean removeCleanInternal(StateManagerImpl sm) {
            return this._clean != null && this._clean.remove(sm);
        }

        public Iterator iterator() {
            IteratorChain chain = new IteratorChain();
            if (this._dirty != null && !this._dirty.isEmpty()) {
                chain.addIterator(this._dirty.iterator());
            }
            if (this._clean != null && !this._clean.isEmpty()) {
                chain.addIterator(this._clean.iterator());
            }
            return chain;
        }

        public boolean contains(Object obj) {
            return this._dirty != null && this._dirty.contains(obj) || this._clean != null && this._clean.contains(obj);
        }

        public boolean containsAll(Collection coll) {
            Iterator itr = coll.iterator();
            while (itr.hasNext()) {
                if (this.contains(itr.next())) continue;
                return false;
            }
            return true;
        }

        public void clear() {
            if (this._dirty != null) {
                this._dirty.clear();
            }
            if (this._clean != null) {
                this._clean.clear();
            }
        }

        public boolean isEmpty() {
            return !(this._dirty != null && !this._dirty.isEmpty() || this._clean != null && !this._clean.isEmpty());
        }

        public int size() {
            int size = 0;
            if (this._dirty != null) {
                size += this._dirty.size();
            }
            if (this._clean != null) {
                size += this._clean.size();
            }
            return size;
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray(Object[] arr) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ManagedCache {
        private final Map _main;
        private Map _conflicts = null;
        private Map _news = null;
        private Collection _embeds = null;
        private Collection _untracked = null;

        public ManagedCache(Map cache) {
            this._main = cache;
        }

        public StateManagerImpl getById(Object oid, boolean allowNew) {
            StateManagerImpl sm2;
            if (oid == null) {
                return null;
            }
            StateManagerImpl sm = (StateManagerImpl)this._main.get(oid);
            if (sm != null) {
                if (sm.isNew()) {
                    return allowNew ? sm : null;
                }
                if (!allowNew || !sm.isDeleted()) {
                    return sm;
                }
                if (this._conflicts != null && (sm2 = (StateManagerImpl)this._conflicts.get(oid)) != null) {
                    return sm2;
                }
            }
            if (allowNew && this._news != null && !this._news.isEmpty() && (sm2 = (StateManagerImpl)this._news.get(oid)) != null) {
                return sm2;
            }
            return sm;
        }

        public void add(StateManagerImpl sm) {
            if (!sm.isIntercepting()) {
                if (this._untracked == null) {
                    this._untracked = new HashSet();
                }
                this._untracked.add(sm);
            }
            if (!sm.isPersistent() || sm.isEmbedded()) {
                if (this._embeds == null) {
                    this._embeds = new ReferenceHashSet(2);
                }
                this._embeds.add(sm);
                return;
            }
            if (sm.isNew()) {
                if (this._news == null) {
                    this._news = new HashMap();
                }
                this._news.put(sm.getId(), sm);
                return;
            }
            StateManagerImpl orig = this._main.put(sm.getObjectId(), sm);
            if (orig != null) {
                this._main.put(sm.getObjectId(), orig);
                throw new UserException(_loc.get("dup-load", sm.getObjectId(), (Object)Exceptions.toString(orig.getManagedInstance()))).setFailedObject(sm.getManagedInstance());
            }
        }

        public void remove(Object id, StateManagerImpl sm) {
            Object orig;
            if (sm.getObjectId() != null) {
                Object orig2 = this._main.remove(id);
                if (orig2 != sm) {
                    if (orig2 != null) {
                        this._main.put(id, orig2);
                    }
                    if (this._conflicts != null && (orig2 = this._conflicts.remove(id)) != null && orig2 != sm) {
                        this._conflicts.put(id, orig2);
                    }
                }
            } else if (!(this._embeds != null && this._embeds.remove(sm) || this._news == null || (orig = this._news.remove(id)) == null || orig == sm)) {
                this._news.put(id, orig);
            }
            if (this._untracked != null) {
                this._untracked.remove(sm);
            }
        }

        public void persist(StateManagerImpl sm) {
            if (this._embeds != null) {
                this._embeds.remove(sm);
            }
        }

        public void assignObjectId(Object id, StateManagerImpl sm) {
            StateManagerImpl orig = (StateManagerImpl)this._news.remove(id);
            if (orig != null && orig != sm) {
                this._news.put(id, orig);
            }
            if ((orig = this._main.put(sm.getObjectId(), sm)) != null) {
                this._main.put(sm.getObjectId(), orig);
                if (!orig.isDeleted()) {
                    throw new UserException(_loc.get("dup-oid-assign", sm.getObjectId(), (Object)Exceptions.toString(sm.getManagedInstance()))).setFailedObject(sm.getManagedInstance());
                }
                if (this._conflicts == null) {
                    this._conflicts = new HashMap();
                }
                this._conflicts.put(sm.getObjectId(), sm);
            }
        }

        public void commitNew(Object id, StateManagerImpl sm) {
            StateManagerImpl orig;
            if (sm.getObjectId() == id) {
                StateManagerImpl orig2;
                StateManagerImpl stateManagerImpl = orig2 = this._conflicts == null ? null : (StateManagerImpl)this._conflicts.remove(id);
                if (orig2 == sm && (orig2 = this._main.put(id, sm)) != null && !orig2.isDeleted()) {
                    this._main.put(sm.getObjectId(), orig2);
                    throw new UserException(_loc.get("dup-oid-assign", sm.getObjectId(), (Object)Exceptions.toString(sm.getManagedInstance()))).setFailedObject(sm.getManagedInstance()).setFatal(true);
                }
                return;
            }
            if (this._news != null) {
                this._news.remove(id);
            }
            if ((orig = this._main.put(sm.getObjectId(), sm)) != null && orig != sm && !orig.isDeleted()) {
                this._main.put(sm.getObjectId(), orig);
                throw new UserException(_loc.get("dup-oid-assign", sm.getObjectId(), (Object)Exceptions.toString(sm.getManagedInstance()))).setFailedObject(sm.getManagedInstance()).setFatal(true);
            }
        }

        public Collection copy() {
            int size = this._main.size();
            if (this._conflicts != null) {
                size += this._conflicts.size();
            }
            if (this._news != null) {
                size += this._news.size();
            }
            if (this._embeds != null) {
                size += this._embeds.size();
            }
            if (size == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> copy = new ArrayList<Object>(size);
            Iterator<Object> itr = this._main.values().iterator();
            while (itr.hasNext()) {
                copy.add(itr.next());
            }
            if (this._conflicts != null && !this._conflicts.isEmpty()) {
                itr = this._conflicts.values().iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            if (this._news != null && !this._news.isEmpty()) {
                itr = this._news.values().iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            if (this._embeds != null && !this._embeds.isEmpty()) {
                itr = this._embeds.iterator();
                while (itr.hasNext()) {
                    copy.add(itr.next());
                }
            }
            return copy;
        }

        public void clear() {
            this._main.clear();
            if (this._conflicts != null) {
                this._conflicts.clear();
            }
            if (this._news != null) {
                this._news.clear();
            }
            if (this._embeds != null) {
                this._embeds.clear();
            }
            if (this._untracked != null) {
                this._untracked.clear();
            }
        }

        public void clearNew() {
            if (this._news != null) {
                this._news.clear();
            }
        }

        private void dirtyCheck() {
            if (this._untracked == null) {
                return;
            }
            Iterator iter = this._untracked.iterator();
            while (iter.hasNext()) {
                ((StateManagerImpl)iter.next()).dirtyCheck();
            }
        }
    }
}

