/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import org.apache.openejb.loader.Files;
import org.apache.xbean.finder.UrlSet;

public final class URLs {
    public static File toFile(URL url) {
        return Files.toFile(url);
    }

    public static URL toFileUrl(URL url) {
        if ("jar".equals(url.getProtocol())) {
            try {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    throw new MalformedURLException("no ! found in jar url spec:" + spec);
                }
                return new URL(spec.substring(0, separator++));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        if ("file".equals(url.getProtocol())) {
            return url;
        }
        throw new IllegalArgumentException("Unsupported URL scheme: " + url.toExternalForm());
    }

    public static String toFilePath(URL url) {
        return URLs.toFile(url).getAbsolutePath();
    }

    public static UrlSet cullSystemAndOpenEJBJars(UrlSet original) throws IOException {
        return URLs.cullSystemJars(URLs.cullOpenEJBJars(original));
    }

    public static UrlSet cullSystemJars(UrlSet original) throws IOException {
        UrlSet urls = new UrlSet((Collection)original.getUrls());
        urls = urls.exclude(ClassLoader.getSystemClassLoader().getParent());
        urls = urls.excludeJvm();
        urls = urls.excludePaths(System.getProperty("sun.boot.class.path", ""));
        urls = urls.exclude(".*/JavaVM.framework/.*");
        return urls;
    }

    public static UrlSet cullOpenEJBJars(UrlSet original) throws IOException {
        UrlSet urls = new UrlSet((Collection)original.getUrls());
        urls = urls.exclude(".*openejb.*");
        return urls;
    }

    public static URI uri(String uri) {
        File f;
        if (!uri.startsWith("file") && !uri.startsWith("jar") && !uri.isEmpty() && (f = new File(uri)).exists()) {
            return f.toURI();
        }
        return URI.create(uri.replace(" ", "%20").replace("#", "%23"));
    }

    private URLs() {
    }
}

